import threading
from serial import Serial
from time import time, sleep
from lib.utils import Utils

class SerialLib(Utils):
    def __init__(self, usbdevnode, config, baudrate: int = 38400, log_id = "SERIAL") -> None:
        self.config = config
        self.baudrate = baudrate
        self.timeout = 0.5
        self.log_id = log_id
        self.usbdevnode = usbdevnode
        self.last_valve_timestamp = time()
        
        threading.Thread(target = self.connect).start()

    def connect(self) -> None:
        """
        This function attempts to establish a serial connection with the specified USB device node.

        """

        try:
            self.log(f"Try to connect serial port: {self.usbdevnode.get_devnode()}")
            self.serial_module = Serial(self.usbdevnode.get_devnode(), self.baudrate, timeout=self.timeout)
            self.read()

        except Exception as Ex:
            self.log(Ex)

    def read(self) -> None:
        """
        This function continuously reads lines from the serial module and processes them.
        If the line is empty, the function skips it.

        """
        # modo:0;extra:0;ltr:0;ltc:0;rtr:0;rtc:0;m_extra:1;m_ltr:0;m_ltc:1;m_rtr:1;m_rtc:1;a_extra:1;a_ltr:0;a_ltc:1;a_rtr:1;a_rtc:1;templm:0.0
        self.log("Reading line from serial")
        while True:
            raw_line = self.serial_module.readline().decode("utf-8")
            line = raw_line.strip()
            if line =="":
                pass
            else:
                self.log(f"GOT: {line}")
                if "modo" in line:self.process_line(line)
            sleep(0.01)

    def process_line(self, line: str) -> None:
        try:
            data_dict = {}
            data_split = line.split(';')
            for data in data_split:
                if not data: continue
                data = data.upper()
                if "M_" in data or "EXTRA" in data: self.log(data)
                serial_var, serial_value = data.split(':')
                data_dict[serial_var] = int(float(serial_value))
                

            self.log(data_dict)
            valve_state = {
                "valve_state": [data_dict["M_LTR"], data_dict["M_LTC"], data_dict["M_RTC"], data_dict["M_RTR"]],
                "timestamp": time()
            }
            self.emit(data_type=self.log_id, data=valve_state)
            self.last_valve_timestamp = time()
            

        except:
            self.traceback() 
               


    


