import subprocess
import datetime
import actualizacion_datalogger

class Actualizar():
    def __init__(self):
        self.log_id="ACTUALIZADOR"

    def getProductId(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","robot"]).decode()
        tcp = int(data.split(":")[2])
        return (tcp - 10000) # Mother/Jarvis product ID

    def getProductName(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","name"]).decode()
        data = data.split("'")[3].strip()
        return data
    
    # Metodo Lanza linea de comando: None
    def comando(self,orden,modo=1):
        orden_s=orden.split(' ')
        if modo==1:
            res=subprocess.check_output(orden_s)
            if res.decode()!='\n' or res.decode()!='':
                print(res.decode())
        elif modo==0:
            try:
                res=subprocess.check_output(orden_s)
                if res.decode()!='\n' or res.decode()!='':
                    print(res.decode())
            except: pass

    # Metodo entrega tipo de equipo: STRING
    def tipo(self):
        res=subprocess.check_output('machinename')
        nombre=res.decode().split('-')
        return nombre[0].lower() # return en minuscula


    # Metodo entrega el numero del equipo: INT
    # Ejemplo: ecom-500 entrega 500
    def numero(self):
        res=subprocess.check_output('machinename')
        num_equipo=res.decode().split('-')
        try:
            return int(num_equipo[1])
        except:
            return 0
    
    # Metodo entrega ID; INT
    def id(self):
        res=subprocess.check_output('machineid').decode()
        return int(res)

    # Metodo que agrega el output al log: None
    def log(self,message):
        dt = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        print("[%s] %s | %s" % (self.log_id, dt, message))
        with open ("/log.txt", "a") as myfile:
            myfile.write("[%s] %s | %s\n" % (self.log_id, dt, message))

    # Meotod reemplaza string en archivo: None
    def reemplazar(self, ruta_archivo, texto_out, texto_in):
        with open(ruta_archivo,'r') as archivo:
            contenido=archivo.read()
        contenido_2 = contenido.replace(texto_out,texto_in)

        with open(ruta_archivo, 'w') as archivo_nuevo:
            archivo_nuevo.write(contenido_2)
    
    def ver_datalogger(self, opcion= 2):
        lista=[]
        resp=subprocess.check_output(['ls','/srv/']).decode()
        if self.tipo()=='mmr' and 'pruebas-riego' in resp:
            lista.append('MMR EYE3')
        if 'datalogger_mmr' in resp:
            lista.append('MMR MINING')
        if self.tipo()=='ecom' and 'dio' in resp:
            res2 = subprocess.check_output(['ls','/srv/dio/']).decode()
            if 'gps_config.json' in res2:
                lista.append('ECOM EYE3 MASTER')
            else:
                lista.append('ECOM EYE3')
        if 'datalogger_ecom' in resp:
            lista.append('ECOM MINING')
        if self.tipo()=='gimp' and 'dio' in resp:
            lista.append('GIMP EYE3')
        if 'datalogger_gimp' in resp:
            lista.append('GIMP MINING')
        for i in resp.split('\n'):
            if i=='datalogger':
                lista.append('CABINA')
        if len(lista)==0: print('No hay dataloggers instalados')
        #if opcion==1:
        for i in range(len(lista)):
            print(str(i+1)+'. '+lista[i])
        print('')
        if opcion==1:
            return []
        elif opcion==2:
            return lista
    
    # Metodo funcional: None
    def app(self):
        self.nombre = self.tipo()
        try:
            self.log("Actualizando a Mining 2.1.25...")

            if self.nombre!='tablet':
                ##########Cambiar clave de acceso root
                print('[1] Cambiando clave ususario root')
                self.comando('sudo sh cambioclave_root.sh')
                print('[2] Clave usuario root reemplazada')

                # DELETE ALL ZIP FILES IN CHECK DATALOGGER
                print('[3] Eliminar posibles zip en check datalogger directorio')
                self.comando('sudo rm *.zip', 0)
                print('[4] ZIP eliminados')

                print('[5] Agregar comando para ver los comandos disponibles')
                self.comando('cp comandos.py /bin/comandos')
                self.comando('sudo chmod 777 /bin/comandos')
                print('[6] Comando agregado')

                datalogger = self.ver_datalogger()
                if "ECOM MINING" in datalogger:
                    print('[5] Actualizar scripts ECOM')
                    self.comando('sudo cp gps_lib_ecom.py /srv/datalogger_ecom/gps/gps_lib.py')
                    self.comando('systemctl restart mining-gps.service',0)
                    self.comando('sudo cp serial_lib_ecom.py /srv/datalogger_ecom/serial/serial_lib.py')
                    self.comando('systemctl restart mining-serial.service')
                    print('[6] Scripts ECOM actualizados')
                
                elif "MMR MINING" in datalogger:
                    print('[7] Actualizar scripts MMR')
                    self.comando('sudo cp gps_lib_mmr.py /srv/datalogger_mmr/gps/gps_lib.py')
                    self.comando('systemctl restart mining-gps.service')
                    self.comando('sudo cp flow_lib.py /srv/datalogger_mmr/flow/flow_lib.py')
                    self.comando('systemctl restart mining-flow.service', 0)
                    self.comando('sudo cp serial_lib_mmr.py /srv/datalogger_mmr/serial/serial_lib.py')
                    self.comando('systemctl restart mining-serial.service')
                    self.comando('sudo cp autodetect_mmr_ports.py /srv/datalogger_mmr/lib/autodetect_mmr_ports.py')
                    print('[8] Scripts MMR actualizados')
                
                elif "GIMP MINING" in datalogger:
                    print('[9] Actualizar scripts GIMP')
                    self.comando('sudo cp gps_lib_gimp.py /srv/datalogger_gimp/gps/gps_lib.py')
                    self.comando('systemctl restart mining-gps.service')
                    print('[10] Scripts GIMP actualizados')

                ## ACTUALIZAR MINISTRO HALES, ANTUCOYA Y CANDELARIA A DATALOGGER MINING ##
                print("[11] Instalando Datalogger")
                if self.nombre == "ecom": actualizacion_datalogger.actualizar_ecom()
                elif self.nombre == "mmr": actualizacion_datalogger.actualizar_mmr()
                elif self.nombre == "gimp": actualizacion_datalogger.actualizar_gimp()
                print("[12] Datalogger actualizado")

                print('[13] Add MININSTRO HALES, ANTUCOYA Y CANDELARIA to check datalogger service')
                self.comando('sudo cp check_datalogger_main.py /etc/mining/check_datalogger/__main__.py')
                self.comando('systemctl restart mining-check-datalogger.service')
                print('[14] check datalogger actualizado')

                #ACTUALIZANDO LIVE
                print('[15] Actualizando comando live')
                if self.tipo()=='ecom':
                    datalogger = self.ver_datalogger()
                    if 'ECOM EYE3' in datalogger:
                        self.comando('sudo cp sanidad_old /bin/sanidad')
                        self.comando('sudo chmod 777 /bin/sanidad')
                    elif 'ECOM MINING' in datalogger:
                        self.comando('sudo cp sanidad /bin/sanidad')
                        self.comando('sudo chmod 777 /bin/sanidad')
                        self.comando('sudo cp models.py /srv/datalogger_ecom/database/models.py')
                    else: pass
                self.comando('sudo cp main_live.py /srv/live/__main__.py')
                self.comando('sudo systemctl restart mining-live')
                print('[16] Sistema Live Actualizado')

                #Actualizando comando usb
                print('[17] Actualizando comando usb')
                self.comando('sudo cp usb /bin/usb')
                self.comando('sudo chmod 777 /bin/usb')
                print('[18] Comando usb actualizado')

                print('[19] Actualizando comando mining...')
                self.comando('sudo cp mining /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[20] Comando mining Actualizado')

            else:
                #ACTUALIZANDO LIVE
                print('[1] Actualizando comando live')
                self.comando('sudo cp main_live.py /home/pi/live/__main__.py')
                self.comando('sudo systemctl restart mining-live')
                print('[2] Sistema Live Actualizado')

                #Actualizando comando usb
                print('[3] Actualizando comando usb')
                self.comando('sudo cp usb /bin/usb')
                self.comando('sudo chmod 777 /bin/usb')
                print('[4] Comando usb actualizado')

                print('[5] Actualizando comando mining...')
                self.comando('sudo cp mining_tablet /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[6] Comando mining Actualizado')
                    

            file = open("/etc/mining/version", "w")
            file.write("23\n")
            file.close()

            self.log("Actualizacion a Mining 2.1.25 Finalizada")

        except:
            self.log("Error actualizando el sistema")

#####RUN########
entorno = Actualizar()
entorno.app()




