import sys
import json
import os
import time

sys.path.append('/srv/datalogger_mmr/')
from lib.utils import Utils

SOURCE_CONFIG = "/srv/datalogger_mmr/config_mmr.json"
SOURCE_GEOFENCE = "/srv/datalogger_mmr/geofence.json"
SOURCE_URLS = "/srv/datalogger_mmr/config/urls.json"

#TODO: ADD AUTOUPDATE GEOFENCE
class Config(Utils):
	def __init__(self, log_id = "CONFIG"):
		self.log_id = log_id
		self.machine_id = self.get_product_id()
		self.machine_name = self.get_product_name()
		self.location = self.get_location_assigned()
		self.faena = self.get_faena_assigned()
		self.avalaible_faenas = self.get_avalaible_faenas(datalogger_type= "mmr")
	
	def check_exist(self, source_config):
		self.log("Checking config files...")
		if not os.path.isfile(source_config):
			self.log("Config_mmr.json not found")
			config_mmr = {
				"SERVER":{
					"IP": "127.0.0.1",
					"PORT": 20001,
					"MAX_LEN_PACKET_DATA": 30,
					"SECONDS_MICRODATA": 1,
				},
				"GPS_SENSOR": {
					"PORT": "GPS",
					"MODEL": "GPS_USB",
				},
				"AUTOUPLOAD": {
					"MINING":{
						"ACTIVATED": 1,
						"DATA": "",
						"LOCATION": "",
					},
					"EYE3":{
						"ACTIVATED": 1,
						"DATA": "",
						"LOCATION": "",
					}
				},
				"VALVE_SENSOR":{
					"PORT": 5,
				},
				"FLOW_SENSOR":{
					"PORT": 4,
					"MODBUS_ID": [3, 4]
				},
				"GEOFENCE_URL": "",
				"TEST_MODE":0	
			}
			
			with open(source_config, "w") as f:
				json.dump(config_mmr, f, indent=len(config_mmr))
				self.log("Config_mmr.json created")


	def update_mining_config(self, source_config):
		print("UPDATE MINING CONFIG")
		TOPIC_DATA= f"{self.faena}/dataloggers/{self.location}/{self.machine_name}"
		TOPIC_LOCATION = f"{self.faena}/dataloggers/mapa/{self.location}/{self.machine_name}"
		with open(SOURCE_CONFIG, 'r') as f:
			config = json.load(f)
		
		if config["AUTOUPLOAD"]["MINING"]["DATA"] != TOPIC_DATA or config["AUTOUPLOAD"]["MINING"]["LOCATION"] != TOPIC_LOCATION:
			config["AUTOUPLOAD"]["MINING"]["DATA"] = TOPIC_DATA
			config["AUTOUPLOAD"]["MINING"]["LOCATION"] = TOPIC_LOCATION

			with open(source_config, "w") as f:
				json.dump(config, f, indent=len(config))

			db_restart_cmd = "sudo python3 /srv/datalogger_mmr/database/models.py --reset_db true"
			self.command(db_restart_cmd)
			print("CONFIGURACION MINING ACTUALIZADA")
		
			# Update autoupload services
			self.restart_service("mining-autoupload")
			self.restart_service("mining-autoupload-gps")
		else:
			print("CONFIGURACION MINING YA ESTA ACTUALIZADA")


	def update_eye3_config(self, source_config, source_urls):
		print("UPDATE EYE3 CONFIG")
		urls_config =json.load(open(source_urls))
		urls= urls_config.get(self.faena, {})
		print(f"Faena asiganda {self.faena}")
		if urls:
			with open(source_config, 'r') as f:
				config = json.load(f)
			faena = urls.get("data", "")
			if config["AUTOUPLOAD"]["EYE3"]["DATA"] != faena:
				config["AUTOUPLOAD"]["EYE3"]["DATA"] = faena
				config["AUTOUPLOAD"]["EYE3"]["LOCATION"] = urls.get("position", "")
				config["GEOFENCE_URL"] = urls.get("geofence", "")

				with open(source_config, "w") as f:
					json.dump(config, f, indent=len(config))
				
				print("CONFIGURACION EYE3 ACTUALIZADA")

				# Update autoupload services
				self.restart_service("mining-autoupload")
				self.restart_service("mining-autoupload-gps")
			else:
				print("CONFIGURACION EYE3 YA ESTA ACTUALIZADA")
		else:
			print("NO EXISTE EL ARCHIVO DE CONFIGURACION URL")
	
	def update_geofence(self, source_config, source_geofence):
		try:
			print("Check Geofence")
			if self.faena in self.avalaible_faenas:
			# 1. Check if geofence files exist
				if not os.path.isfile(source_geofence):
					print("Geofence.json not found")
					# Download geofence from API
					self.download_geofence(source_config, source_geofence)
					self.restart_service("mining-gps")

				else:
					print("Geofence.json found")
					# checking for updates
					print("Checking for updates")
					last_timestamp_geofence = os.path.getmtime(source_geofence)
					if time.time() - last_timestamp_geofence >= 60*60*24*7: # 7 dias
						print("Geofence.json is older than 7 days, try update")
						# Update geofence from API
						self.download_geofence(source_config, source_geofence)
						self.restart_service("mining-gps")
					else: print("Geofence not cahnge in the last 7 days")
			else:
				print("No hay faena asignada")
		except:
			self.traceback()
			self.log("Error updating geofence")

	def download_geofence(self, source_config, source_geofence):
		try:
			config =json.load(open(source_config))
			api_url = config["GEOFENCE_URL"]
			if api_url:
				geofence_cmd = f"wget {api_url} -O {source_geofence}"

				print(f"Downloading GEOFENCE geometry from: {api_url}")
				print("[%s] ..." % geofence_cmd)
				self.command(geofence_cmd)

				# update tablet geofence
				print("Updating tablet geofence...")
				tablet_cmd = f"cp {source_geofence} /var/www/html/caminos.geojson"
				self.command(tablet_cmd)

				print("update_geofence(): Done")
			else:
				print("No existe url para descarga de geofence")
		except:
			self.traceback()
			self.log("Error updating geofence")

	def check_tablet(self):
		try:
			print("Check Tablet")
			if self.faena in self.avalaible_faenas:
				print("Check if index.html Tablet change...")
				path_current_index = "/var/www/html/index.html"
				path_size_base_index = f"/srv/datalogger_mmr/tablet/htmls/{self.faena.replace(' ', '')}.html"
				size_current_index = os.path.getsize(path_current_index)
				size_base_index = os.path.getsize(path_size_base_index)
				if size_current_index != size_base_index:
					print("Index Tablet change --> Actualizando .......")
					command = f"cp {path_size_base_index} {path_current_index}"
					self.command(orden = command)
				else:
					print("Index Tablet has not changed")
			else:
				print("No hay faena asignada")
		
		except:
			self.traceback()
			self.log("Error update tablet files")
		
if __name__ == "__main__":
	config = Config()
	print("Actualizando configuraciones")
	# 1. Check if config files exist
	config.check_exist(source_config= SOURCE_CONFIG)

	# 2. Update mining config
	config.update_mining_config(source_config= SOURCE_CONFIG)

	# 3. Update eye3 config
	config.update_eye3_config(source_config= SOURCE_CONFIG, source_urls= SOURCE_URLS)

	# 4. Update geofence
	config.update_geofence(source_config= SOURCE_CONFIG, source_geofence= SOURCE_GEOFENCE)

	# 5. Check Tablet
	config.check_tablet()
	