import sys
import json
import os
import requests
import re
import time

sys.path.append('/srv/datalogger_ecom/')
from lib.utils import Utils

SOURCE_CONFIG = "/srv/datalogger_ecom/config_ecom.json"
SOURCE_GEOFENCE = "/srv/datalogger_ecom/geofence.json"
SOURCE_URLS = "/srv/datalogger_ecom/config/urls.json"
TOKEN = "ab2399f4d1cb524b4148066d40b5028e4fe6e97a4b5a1c961c1ec6d96c1b479f737418da717d9b8293e554f74551b515b0fddb96251c8876d569f48d39f0751937e26942e0fabcf3bb31a4e5b9be62cd1d3252d3cc44e24230184001e2e1541a0ed2b99bb28d6cdb5d73a5ffa8e227c79ee45e14678a00d706ca917a11eeeddf"

class Config(Utils):
	def __init__(self, log_id = "CONFIG"):
		self.log_id = log_id
		self.machine_id = self.get_product_id()
		self.machine_name = self.get_product_name()
		self.location = self.get_location_assigned()
		self.faena = self.get_faena_assigned()
		self.avalaible_faenas = self.get_avalaible_faenas(datalogger_type= "ecom")
	
	def check_exist(self, source_config):
		self.log("Checking config files...")
		if not os.path.isfile(source_config):
			self.log("Config_ecom.json not found")
			config_ecom = {
				"SERVER":{
					"IP": "127.0.0.1",
					"PORT": 20001,
					"MAX_LEN_PACKET_DATA": 60,
					"SECONDS_MICRODATA": 1.5
				},
				"DUST_SENSOR":{
					"PORT": "nano",
					"MIN_VALUE_PM100": 0,
					"MAX_VALUE_PM100": 39900,
					"EVOS": [],
					"AUTOUPDATE_EVO": 1
				},
				"GPS_SENSOR": {
					"PORT": "gps",
					"MIN_VALUE_SPEED": -1,
					"MODEL": "GPS_MASTER",
				},
				"AUTOUPLOAD": {
					"MINING":{
						"ACTIVATED": 1,
						"DATA": "",
						"LOCATION": "",
					},
					"EYE3":{
						"ACTIVATED": 1,
						"DATA": "",
						"LOCATION": "",
					}
				},
				"TEST_MODE":0,
				"GEOFENCE_URL": ""	
			}

			with open(source_config, "w") as f:
				json.dump(config_ecom, f, indent=len(config_ecom))
				self.log("Config_ecom.json created")

	def update_mining_config(self, source_config):
		print("UPDATE MINING CONFIG")
		TOPIC_DATA= f"{self.faena}/dataloggers/{self.location}/{self.machine_name}"
		TOPIC_LOCATION = f"{self.faena}/dataloggers/mapa/{self.location}/{self.machine_name}"
		with open(SOURCE_CONFIG, 'r') as f:
			config = json.load(f)
		
		if config["AUTOUPLOAD"]["MINING"]["DATA"] != TOPIC_DATA or config["AUTOUPLOAD"]["MINING"]["LOCATION"] != TOPIC_LOCATION:
			print("TOPICO HA CAMBIADO, SE ACTUALIZARÁ EN EL CONFIG Y SE REINICIARÁ LA BASE DE DATOS")
			config["AUTOUPLOAD"]["MINING"]["DATA"] = TOPIC_DATA
			config["AUTOUPLOAD"]["MINING"]["LOCATION"] = TOPIC_LOCATION

			with open(source_config, "w") as f:
				json.dump(config, f, indent=len(config))
			
			db_restart_cmd = "sudo python3 /srv/datalogger_ecom/database/models.py --reset_db true"
			self.command(db_restart_cmd)
			print("CONFIGURACION MINING ACTUALIZADA")
		
			# Update autoupload services
			self.restart_service("mining-autoupload")
			self.restart_service("mining-autoupload-gps")
		else:
			print("CONFIGURACION MINING YA ESTA ACTUALIZADA")

	def update_eye3_config(self, source_config):
		POSITION_DATA_URL = ""
		MONITOR_PUSH_URL = ""
		print("UPDATE EYE3 CONFIG")	
		url = "https://mother.eye3.cl/config_script/ecom/%s" % self.machine_id
		print("")
		print("Downloading datalogger config from")
		print("[%s]..." % url)
		r = requests.get(url, verify="/etc/ssl/certs/ca-certificates.crt")
		text = r.content
		if len(text) == 0:
			print("ERROR: Received empty string, please make sure ")
			print("       there is a config script for machine id %s" % self.machine_id)
			print(" ")

		else:
			print("-------")
			#print("%s" % text)
			print("-------")
			print("Configuration saved /etc/eye3/config.py")
			print("Done.")
			data = text.decode("utf-8")
			
			for item in data.split("\n"):
				if "'position_update_url'" in item:
					line = item.strip()
					POSITION_DATA_URL = line.split("'")[3]
					print (f"URL encontrada: {POSITION_DATA_URL}")
				elif "'monitor_push_url'" in item:
					line = item.strip()
					MONITOR_PUSH_URL = line.split("'")[3]
					print (f"URL encontrada: {MONITOR_PUSH_URL}")

		if MONITOR_PUSH_URL:
			with open(SOURCE_CONFIG, 'r') as f:
				config = json.load(f)
				
			if config["AUTOUPLOAD"]["EYE3"]["DATA"] != MONITOR_PUSH_URL:
				config["AUTOUPLOAD"]["EYE3"]["DATA"] = MONITOR_PUSH_URL
				config["AUTOUPLOAD"]["EYE3"]["LOCATION"] = POSITION_DATA_URL

				with open(source_config, "w") as f:
					json.dump(config, f, indent=len(config))
				
				print("CONFIGURACION EYE3 ACTUALIZADA")

				# Update autoupload services
				self.restart_service("mining-autoupload")
				self.restart_service("mining-autoupload-gps")
			else:
				print("CONFIGURACION EYE3 YA ESTA ACTUALIZADA")
		else:
			print("NO HAY FAENA ASIGNADA EN EYE3")
	
	def update_evo(self, source_config, token):
		print("ACTUALIZANDO EVO ASIGNADO")			
		evos = []
		try:
			with open(source_config, 'r') as f:
					config = json.load(f)
			if config["DUST_SENSOR"]["AUTOUPDATE_EVO"]:
				headers = {
					'accept': 'application/json',
					'Authorization': f'Bearer {token}',
					'Content-Type': 'application/json'
				}
				url_base = "http://core.mine-360.com:1337/api/"
				url = f'{url_base}faena-ubicacions?filters[FaenaUbicacion][$eq]={self.location}&populate[sensores][fields][1]=MachineName&populate[dataloggers][fields][1]=MachineId&fields[0]=id'
				print(url)
				response = requests.get(url, headers=headers)

				if response.status_code == 200:
					data = response.json()
					print(data)
					for data_evo in data["data"]:
						exist = 0
						for datalogger in data_evo['attributes']['dataloggers']['data']:
							if str(self.machine_id) == datalogger['attributes']['MachineId']:
								exist =1
								break
						if exist == 1:
							sensores = data_evo["attributes"]["sensores"]["data"]
							print(sensores)
							for sensor_data in sensores:
								sensor = sensor_data["attributes"]["MachineName"]
								print(f"sensor: {sensor}")
								if "evo" in sensor:
									evo = sensor
									#number = re.findall('\d+', evo)
									evo_c = evo.split('-')
									if evo_c:
										evos.append(evo_c[1])
										evos.append(evo_c[1]+'c')

				if evos:
					# only if change, update config
					if sorted(config["DUST_SENSOR"]["EVOS"]) != sorted(evos):
						config["DUST_SENSOR"]["EVOS"] = evos
						with open(source_config, "w") as f:
							json.dump(config, f, indent=len(config))

						# Update serial service
						print("EVO ACTUALIZADO")
						self.restart_service("mining-serial")
					else:
						print("EVO YA ESTA ACTUALIZADO")
				else:
					print("NO HAY EVO CONFIGURADO EN STRAPI")
			else:
				print("NO ESTA CONFIGURADO EL AUTOUPDATE DE EVO")

		except Exception as e:
			print(f"An error occurred: {e}")

	def update_url_geofence(self, source_config, source_urls):
		try:
			urls_config =json.load(open(source_urls))
			urls= urls_config.get(self.faena, {})	
			url_geofence = urls.get("geofence", "")
			if url_geofence:
				with open(source_config, 'r') as f:
					config = json.load(f)
				if url_geofence != config["GEOFENCE_URL"]:
					print("URL Gofence change.. se actualizará en el config")
					config["GEOFENCE_URL"] = urls.get("geofence", "")

					with open(source_config, "w") as f:
						json.dump(config, f, indent=len(config))
					
					print("URL GEOFENCE ACTUALIZADA")
		except:
			self.traceback()
		
	def update_geofence(self, source_config, source_geofence, source_urls):
		try:
			print("Check Geofence")
			self.update_url_geofence(source_config, source_urls)
			if self.faena in self.avalaible_faenas:
			# 1. Check if geofence files exist
				if not os.path.isfile(source_geofence):
					print("Geofence.json not found")
					# Download geofence from API
					self.download_geofence(source_config, source_geofence)
					self.restart_service("mining-gps")

				else:
					print("Geofence.json found")
					# checking for updates
					print("Checking for updates")
					last_timestamp_geofence = os.path.getmtime(source_geofence)
					if time.time() - last_timestamp_geofence >= 60*60*24*7: # 7 dias
						print("Geofence.json is older than 7 days, try update")
						# Update geofence from API
						self.download_geofence(source_config, source_geofence)
						self.restart_service("mining-gps")
					else: print("Geofence not cahnge in the last 7 days")
			else:
				print("No hay faena asignada")
		except:
			self.traceback()
			self.log("Error updating geofence")

	def download_geofence(self, source_config, source_geofence):
		try:
			config =json.load(open(source_config))
			api_url = config["GEOFENCE_URL"]
			if api_url:
				geofence_cmd = f"wget {api_url} -O {source_geofence}"

				print(f"Downloading GEOFENCE geometry from: {api_url}")
				print("[%s] ..." % geofence_cmd)
				self.command(geofence_cmd)

				# update tablet geofence
				print("Updating tablet geofence...")
				tablet_cmd = f"cp {source_geofence} /var/www/html/caminos.geojson"
				self.command(tablet_cmd)

				print("update_geofence(): Done")
			else:
				print("No existe url para descarga de geofence")
		except:
			self.traceback()
			self.log("Error updating geofence")


if __name__ == "__main__":
	config = Config()
	print("Actualizando configuraciones")
	# 1. Check if config files exist
	config.check_exist(source_config= SOURCE_CONFIG)

	# 2. Update mining config
	config.update_mining_config(source_config= SOURCE_CONFIG)

	# 3. Update eye3 config
	config.update_eye3_config(source_config= SOURCE_CONFIG)

	# 4. Check EVO
	config.update_evo(source_config= SOURCE_CONFIG, token= TOKEN)

	# 5. Update geofence
	config.update_geofence(source_config= SOURCE_CONFIG, source_geofence= SOURCE_GEOFENCE, source_urls= SOURCE_URLS)










