import subprocess
import datetime

class Actualizar():
    def __init__(self):
        self.log_id="ACTUALIZADOR"

    def getProductId(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","robot"]).decode()
        tcp = int(data.split(":")[2])
        return (tcp - 10000) # Mother/Jarvis product ID

    def getProductName(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","name"]).decode()
        data = data.split("'")[3].strip()
        return data
    
    # Metodo Lanza linea de comando: None
    def comando(self,orden,modo=1):
        orden_s=orden.split(' ')
        if modo==1:
            res=subprocess.check_output(orden_s)
            if res.decode()!='\n' or res.decode()!='':
                print(res.decode())
        elif modo==0:
            try:
                res=subprocess.check_output(orden_s)
                if res.decode()!='\n' or res.decode()!='':
                    print(res.decode())
            except: pass

    # Metodo entrega tipo de equipo: STRING
    def tipo(self):
        res=subprocess.check_output('machinename')
        nombre=res.decode().split('-')
        return nombre[0].lower() # return en minuscula


    # Metodo entrega el numero del equipo: INT
    # Ejemplo: ecom-500 entrega 500
    def numero(self):
        res=subprocess.check_output('machinename')
        num_equipo=res.decode().split('-')
        try:
            return int(num_equipo[1])
        except:
            return 0
    
    # Metodo entrega ID; INT
    def id(self):
        res=subprocess.check_output('machineid').decode()
        return int(res)

    # Metodo que agrega el output al log: None
    def log(self,message):
        dt = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        print("[%s] %s | %s" % (self.log_id, dt, message))
        with open ("/log.txt", "a") as myfile:
            myfile.write("[%s] %s | %s\n" % (self.log_id, dt, message))

    # Meotod reemplaza string en archivo: None
    def reemplazar(self, ruta_archivo, texto_out, texto_in):
        with open(ruta_archivo,'r') as archivo:
            contenido=archivo.read()
        contenido_2 = contenido.replace(texto_out,texto_in)

        with open(ruta_archivo, 'w') as archivo_nuevo:
            archivo_nuevo.write(contenido_2)
    
    def ver_datalogger(self, opcion= 2):
        lista=[]
        resp=subprocess.check_output(['ls','/srv/']).decode()
        if self.tipo()=='mmr' and 'pruebas-riego' in resp:
            lista.append('MMR EYE3')
        if 'datalogger_mmr' in resp:
            lista.append('MMR MINING')
        if self.tipo()=='ecom' and 'dio' in resp:
            res2 = subprocess.check_output(['ls','/srv/dio/']).decode()
            if 'gps_config.json' in res2:
                lista.append('ECOM EYE3 MASTER')
            else:
                lista.append('ECOM EYE3')
        if 'datalogger_ecom' in resp:
            lista.append('ECOM MINING')
        if self.tipo()=='gimp' and 'dio' in resp:
            lista.append('GIMP EYE3')
        if 'datalogger_gimp' in resp:
            lista.append('GIMP MINING')
        for i in resp.split('\n'):
            if i=='datalogger':
                lista.append('CABINA')
        if len(lista)==0: print('No hay dataloggers instalados')
        #if opcion==1:
        for i in range(len(lista)):
            print(str(i+1)+'. '+lista[i])
        print('')
        if opcion==1:
            return []
        elif opcion==2:
            return lista
    
    # Metodo funcional: None
    def app(self):
        self.nombre = self.tipo()
        try:
            self.log("Actualizando a Mining 2.1.28...")

            print('[1] Actualizando comando para ver los comandos disponibles')
            self.comando('cp comandos.py /bin/comandos')
            self.comando('sudo chmod 777 /bin/comandos')
            print('[2] Comando agregado')

            print('[3] Actualizando comando wifi')
            self.comando('sudo cp wifi /bin/wifi')
            self.comando('sudo chmod 777 /bin/wifi')
            print('[4] Comando wifi actualizado')
            
            if self.nombre!='tablet':
                print('[5] Actualizando Live')
                self.comando('sudo cp main_live.py /srv/live/__main__.py')
                self.comando('sudo systemctl restart mining-live')
                print('[6] Sistema Live Actualizado')
                
                datalogger = self.ver_datalogger()
                if "ECOM MINING" in datalogger:
                    print('[7] Actualizando configuracion de evo')
                    self.comando('sudo cp main_evo.py /srv/datalogger_ecom/config/__main__.py')
                    self.comando('sudo systemctl restart mining-config')
                    print('[8] Configuracion de evo actualizada')

                print('9] Actualizando comando mining...')
                self.comando('sudo cp mining /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[10] Comando mining Actualizado')

            else:
                #ACTUALIZANDO LIVE
                print('[5] Actualizando comando live')
                self.comando('sudo cp main_live.py /home/pi/live/__main__.py')
                self.comando('sudo systemctl restart mining-live')
                print('[6] Sistema Live Actualizado')

                print('[7] Actualizando comando mining...')
                self.comando('sudo cp mining_tablet /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[8] Comando mining Actualizado')
                    

            file = open("/etc/mining/version", "w")
            file.write("26\n")
            file.close()

            self.log("Actualizacion a Mining 2.1.28 Finalizada")

        except:
            self.log("Error actualizando el sistema")

#####RUN########
entorno = Actualizar()
entorno.app()




