import time
import psutil
import subprocess
import json
import paho.mqtt.client as mqtt

class report():
    def __init__(self):

        try:
            with open('topic.json','r') as topico:
                topic_data=json.load(topico)
        except:
            with open('topic.json','r') as topico:
                topic_data=json.load(topico)
        # Configuración del broker MQTT
        self.mqtt_broker = topic_data['mqtt_topic']['web']
        self.mqtt_port = int(topic_data['mqtt_topic']['puerto'])
        self.mqtt_topic = topic_data['topic_mining']
        self.mqtt_user = topic_data['mqtt_topic']['user']
        self.mqtt_pass = topic_data['mqtt_topic']['pass']

        # Crear una instancia de cliente MQTT
        self.mqtt_client = mqtt.Client()

        # Configurar las credenciales de usuario y contraseña
        self.mqtt_client.username_pw_set(self.mqtt_user, self.mqtt_pass)

    def get_cpu_temperature(self):
        try:
            temperatures = psutil.sensors_temperatures()
            if 'cpu_thermal' in temperatures:
                temp_sensors = temperatures['cpu_thermal']
                if temp_sensors:
                    temp = temp_sensors[0].current
                    return temp
                else:
                    print("No se encontraron sensores de temperatura en 'cpu_thermal'.")
                    return None
            else:
                print("El sensor 'cpu_thermal' no está disponible en el sistema.")
                return None
        except Exception as e:
            print(f"Error obteniendo temperatura del CPU: {e}")
            return None

    def get_gpu_temperature(self):
        try:
            result = subprocess.run(['vcgencmd', 'measure_temp'], stdout=subprocess.PIPE)
            temp_str = result.stdout.decode('utf-8')
            temp = temp_str.split('=')[1].split('\'')[0]
            return float(temp)
        except Exception as e:
            print(f"Error obteniendo temperatura de la GPU: {e}")
            return None

    def get_disk_usage_percent(self):
        try:
            disk_usage = psutil.disk_usage('/')
            return disk_usage.percent
        except Exception as e:
            print(f"Error obteniendo porcentaje de uso del disco: {e}")
            return None

    def get_memory_usage_percent(self):
        try:
            memory = psutil.virtual_memory()
            return memory.percent
        except Exception as e:
            print(f"Error obteniendo porcentaje de memoria RAM utilizada: {e}")
            return None

    def get_uptime(self):
        try:
            boot_time = psutil.boot_time()
            uptime_seconds = time.time() - boot_time
            days = uptime_seconds // (24 * 3600)
            hours = (uptime_seconds % (24 * 3600)) // 3600
            minutes = (uptime_seconds % 3600) // 60
            seconds = uptime_seconds % 60
            uptime_string = f"{int(days)} days, {int(hours):02}:{int(minutes):02}:{int(seconds):02}"
            return uptime_string
        except Exception as e:
            print(f"Error obteniendo uptime: {e}")
            return None

    def get_machineid(self):
        result = subprocess.run(['machineid'], stdout=subprocess.PIPE)
        machineid = result.stdout.decode('utf-8').strip()
        return machineid

    def get_machinename(self):
        result = subprocess.run(['machinename'], stdout=subprocess.PIPE)
        machinename = result.stdout.decode('utf-8').strip()
        return machinename

    def publish_data(self):
        try:
            cpu_temp = self.get_cpu_temperature()
            gpu_temp = self.get_gpu_temperature()
            disk_usage = self.get_disk_usage_percent()
            ram_usage = self.get_memory_usage_percent()
            uptime = self.get_uptime()

            m_name = self.get_machinename()
            m_id = self.get_machineid()

            #Measurament, mediciones, equipo solo el name, y timestamp en milisegundos
            data = {
                "measurement": {
                    "temp_cpu": cpu_temp,
                    "ram_usage": ram_usage,
                    "temp_gpu": gpu_temp,
                    "disK_usage": disk_usage,
                    "hdd": disk_usage,
                    "id_equipo": m_id,
                    "uptime": uptime  # Añadir el uptime al payload
                },
                "equipo": {
                    "name": m_name
                },
                "time": int(time.time() * 1000)
            }

            print(data)

            print("TOPIC ANTES:",self.mqtt_topic)

            mqtt_topic_final = self.mqtt_topic+str(m_name)

            print("TOPIC:",mqtt_topic_final)

            self.mqtt_client.connect(self.mqtt_broker, self.mqtt_port, 60)
            self.mqtt_client.publish(mqtt_topic_final, json.dumps(data))
            print(f"Datos enviados al broker MQTT: {json.dumps(data)}")

            self.mqtt_client.disconnect()
        except Exception as e:
            print(f"Error enviando datos al broker MQTT: {e}")

if __name__ == "__main__":
    reporte=report()
    reporte.publish_data()