import requests
from datetime import datetime
from datetime import timedelta
import time
import subprocess
import json
import os
from collections import deque
import report as report
import threading
import re
import psutil
import sys
from tabulate import tabulate
import traceback



class Live():
    def __init__(self):
        
        # URL base de la API de Strapi
        self.base_url = 'http://core.mine-360.com:1337/api/dataloggers'
        self.versions_url =  'http://core.mine-360.com:1337/api/datalogger-tipo-vrsns?pagination[limit]=1000&fields[0]=id&fields[1]=Version'
        self.datalogger_version = 'http://core.mine-360.com:1337/api/datalogger-tipo-vrsns?pagination[limit]=1000&fields[0]=id&fields[1]=Version'
        self.datalogger_tipo = 'http://core.mine-360.com:1337/api/dataloggers-tipos?pagination[limit]=1000'

        # Token de autenticación Bearer
        self.token = 'e48a1c5106f9e0448a4ac2a50176c9ea8bd88bb0eb2309543a71ba58157b6f80d02d3a706c6a534a72b624b99eb7687b4eca525903ccd25b2e46c080223ba7dc4d4ff5820a2665784a707d320c67d94e6c54bc6068a91ff9696191b696203852f782afa7ad658ef6b8d50de1853a36bb69eb5e16b628dcecccb5acfefe848bcf'
        #token ='d32815730b3cb90929f0b6ef11ff43cfb0b6b25892ff08824d398415214c515b403e8708a508ccf6aff2a6f8ad2d3cb899c56ad6ab9122e2d710a36c1111b22deaea3bd225c441639852ecbfcf0d4b3b6f5502ef2c359c4d6765a0c25243354e1728666185af9ad2be014ed866a4806e4c94d6f92e5e9d28379e582e3cbb2504'

        # Configuración de la base de datos
        self.db_config = {
            'user': 'root',
            'passwd': 'claveEye3##',
            'host': 'localhost',
            'db': 'mining_db'
        }

        #Obtenemos datos basicos
        self.machineid = self.get_machineid()
        self.machinename = self.get_machinename()
        self.tipo = self.get_tipo()
        self.host_name = self.get_hostname()
        self.os_version = self.get_os_version()
        self.wifi_name = self.get_wifi_name()
        self.hdd = self.get_disk_usage()
        self.init_class_database()

        
    ## Importar la clase Database según el tipo de equipo
    def init_class_database(self):
        self.database= None
        if self.tipo in ["ecom", "mmr", "gimp"]:
            print("Iniciando database")
            try:
                sys.path.append(f'/srv/datalogger_{self.tipo}/')
                from database.models import Database
                self.database = Database()
                print(self.database)

            except:
                self.traceback()
        else: print("Tipo de equipo no posee base de datos")



    ######################PROGRAMA###########################################
    def app(self):        
        self.hilo_live = threading.Thread(target=self.app_live)
        self.hilo_live.start()

        self.hilo_topic = threading.Thread(target=self.app_topic)
        self.hilo_topic.start()


    ###PROGRAMA TOPIC
    def app_topic(self):
        #Iniciamos la clase report
        reporte_mqtt=report.report()
        try:
            reporte_mqtt.publish_data()
            # time.sleep(300)
        except:
            print('Error en reporte mqtt')

    ###PROGRAMA LIVE
    def app_live(self):
        try:
            self.update_basics()
            
            latitude, longitude = self.get_gps_data(['/run/dio/gps.json', '/run/dio/gps_alternate.json','/run/eye3_regador.json','/gps_live.json'])
            print(f'Obtenido GPS data: latitude={latitude}, longitude={longitude}')

            if self.tipo!='tablet' and self.tipo!='vis':
                import MySQLdb
                def get_uploaded_cero_count():
                    try:
                        print("Conectando a la base de datos...")
                        db = MySQLdb.connect(**self.db_config)
                        cursor = db.cursor()
                        cursor.execute("SELECT COUNT(*) FROM mining_data WHERE uploaded = 0;")
                        count = cursor.fetchone()[0]
                        print(f"Número de registros con uploaded = 0: {count}")
                        cursor.close()
                        db.close()
                        return count
                    except MySQLdb.Error as err:
                        print(f"Error: {err}")
                        return 0

                uploaded_cero = get_uploaded_cero_count()
                print(f'Registros con uploaded = 0: {uploaded_cero}')
            else:
                uploaded_cero = 0
            if int(self.machineid)==920:
                self.machinename='mining-base'
            if int(self.machineid)==986:
                self.machinename='tablet-base'
            self.update_or_create_datalogger(latitude, longitude, uploaded_cero)
            #time.sleep(180)  # Espera de 1 minuto (60 segundos) antes de la siguiente ejecución
        except: self.traceback()


            
    ############METODOS BASICOS##############################################
    #Metodo obtiene machineid: STRING
    def get_machineid(self):
        result = subprocess.run(['machineid'], stdout=subprocess.PIPE)
        machineid = result.stdout.decode('utf-8').strip()
        return machineid

    #Metodo obtiene nombre equipo: STRING
    def get_machinename(self):
        result = subprocess.run(['machinename'], stdout=subprocess.PIPE)
        machinename = result.stdout.decode('utf-8').strip()
        return machinename

    #Meotodo para obtener el nombre del equipo: STRING
    def get_tipo(self):
        res=subprocess.check_output('machinename')
        nombre=res.decode().split('-')
        return nombre[0].lower()
    
    #Metodo obtiene hostname: STRING
    def get_hostname(self):
        """
        Obtiene el nombre del host del sistema.

        :return: El nombre del host como cadena.
        """
        try:
            # Ejecutar el comando 'hostname' para obtener el nombre del host
            result = subprocess.run(['hostname'], stdout=subprocess.PIPE)
            hostname = result.stdout.decode('utf-8').strip()
            return hostname
        except Exception as e:
            print(f"Error al obtener el hostname: {e}")
            return None
    
    #Metodo obtiene verion os: STRING
    def get_os_version(self):
        versionbkp = 'Applebit'
        try:
            # Ejecutar el comando 'version' dentro de un shell
            result = subprocess.run(['bash', '-c', 'mining'], stdout=subprocess.PIPE, stderr=subprocess.PIPE)

            # Decodificar la salida a string
            output = result.stdout.decode('utf-8')

            # Buscar la línea que contiene 'Imagen base version' y extraer el texto después de ella
            match = re.search(r'Imagen base version (.+)', output)
            if match:
                version = match.group(1).strip()
                return version
            else:
                return versionbkp
        except Exception as e:
            print(f"An error occurred: {e}")

            return versionbkp
        
    #Metodo obtiene nombre wifi: STRING
    def get_wifi_name(self):
        """
        Obtiene el nombre de la red Wi-Fi a la que está conectado el dispositivo.

        :return: El nombre de la red Wi-Fi como cadena.
        """

        try:
            # Ejecutar el comando 'iwgetid' para obtener el nombre de la red Wi-Fi
            result = subprocess.run(['iwgetid', '-r'], stdout=subprocess.PIPE)
            wifi_name = result.stdout.decode('utf-8').strip()
            return wifi_name
        except Exception as e:
            print(f"Error al obtener el nombre de la red Wi-Fi: {e}")
            return None
        
    ##Metodo obtiene configuracion de wifi: STRING
    def get_wifi_config(self):
        result = subprocess.check_output(['wifi', '-v'])
        return result.decode()
    
    ###########FUNCIONES METODICAS#################################################

    #Metodo obtiene dataloggers instalados: STRING
    def get_dataloggers(self):
        result = subprocess.check_output(['datalogger', '-v'])
        return result.decode()
    
    #Actualiza info basica: NO RETURN
    def update_basics(self):
        #Obtenemos datos basicos
        self.machineid = self.get_machineid()
        self.machinename = self.get_machinename()
        self.tipo = self.get_tipo()
        self.host_name = self.get_hostname()
        self.os_version = self.get_os_version()
        self.wifi_name = self.get_wifi_name()
        self.hdd = self.get_disk_usage()

    # Función para obtener la temperatura de la Raspberry Pi: None or INT
    def get_raspberry_temp(self):
        try:
            # Leer el archivo que contiene la temperatura de la CPU
            with open("/sys/class/thermal/thermal_zone0/temp", "r") as file:
                temp_raw = file.read().strip()

            # Convertir de miligrados a grados Celsius y formatear a 1 decimal
            temp_celsius = float(temp_raw) / 1000.0
            return round(temp_celsius, 1)

        except Exception as e:
            print(f"Error al obtener la temperatura de la CPU: {e}")
            return None
    
    #Obtiene data PM de ECOM: STRING
    def get_table(self):
        data =[]
        string_table = ""
        if self.database == None: return data, string_table
        try:
            if self.tipo == "ecom": rows, col_name = self.database.get_ecom_data()
            elif self.tipo == "mmr": rows, col_name = self.database.get_mmr_data()
            elif self.tipo == "gimp": rows, col_name = self.database.get_gimp_data()
            else: return dict_data, string_table

            # Get result as list of json
            for row in rows:
                dict_data ={}
                for i in range(len(row)):
                    dict_data[col_name[i]] = row[i]
                data.append(dict_data)
            
            # Get result as string
            string_table = tabulate(rows, headers=col_name, tablefmt='psql')

        except: self.traceback()
        return data, string_table

    
    #Obtiene resumen PM de ECOM: STRING
    def get_health(self):
        data =[]
        string_table = ""
        if self.database == None: return data, string_table
        try:
            if self.tipo == "ecom": rows, col_name = self.database.get_ecom_health()
            elif self.tipo == "mmr": rows, col_name = self.database.get_mmr_health()
            else: return dict_data, string_table
            # Get result as list of json
            for row in rows:
                dict_data ={}
                for i in range(len(row)):
                    dict_data[col_name[i]] = row[i]
                data.append(dict_data)

            # Get result as string
            string_table = tabulate(rows, headers=col_name, tablefmt='psql')

        except: self.traceback()
        return data, string_table

    
    #Obtiene info de Evos: None or Dictionary
    #KEYS: EVOs -> Array of String
    def get_evo_configuration(self):
        try:
            out = subprocess.check_output(['ls','/srv/'])
            if 'datalogger_ecom' in out.decode():
                with open('/srv/datalogger_ecom/config_ecom.json', 'r') as file:
                    evo_json = json.load(file)
                    return evo_json['DUST_SENSOR']['EVOS']
            else:
                with open('/srv/dio/ecom-nrf24/evo.json', 'r') as file:
                    evo_json = json.load(file)
                    return evo_json['EVOs']
        except Exception as e:
            print(f"Error al obtener la configuración de Evos: {e}")
            return None
        
    #Obtener data cabina: STRING
    def get_last_data_cabina(self):
        """
        Captura el contenido del archivo /srv/datalogger/apiRead/ultimo_dato.txt.

        :return: Contenido del archivo como cadena.
        """
        try:
            with open('/srv/datalogger/apiRead/ultimo_dato.txt', 'r') as file:
                last_data = file.read().strip()
                return last_data
        except Exception as e:
            print(f"Error al obtener el último dato: {e}")
            return ''

    #OBtiene data gps si hubiera : TUPLA
    # STRUCTURE: LAT, LON  
    def get_gps_data(self,list_path):
        """
        Obtiene los datos de GPS desde el archivo JSON en la ruta proporcionada.
        """
        path ='X'
        if self.tipo == 'tablet':
            return '',''
        for ruta in list_path:
            if os.path.exists(ruta):
                path = ruta
                break
        if path == 'X':
            return "", ""
        with open(path, 'r') as file:
            gps_data = json.load(file)
            if path == '/gps_live.json':
                latitude = gps_data['latitude']
                longitude = gps_data['longitude']
            else:
                if 'gps' in gps_data and 'data' in gps_data['gps']:
                    latitude = gps_data['gps']['data'].get('latitude', "")
                    longitude = gps_data['gps']['data'].get('longitude', "")
                else:
                    latitude = gps_data.get('lat', "")
                    longitude = gps_data.get('lon', "")
            #if latitude and longitude:
                #return str(latitude), str(longitude)

        return str(latitude), str(longitude)
    
    #Obtiene uso del disco: INT
    def get_disk_usage(self):
        result = subprocess.run(['df', '--output=pcent', '/'], stdout=subprocess.PIPE)
        used_percentage = result.stdout.decode('utf-8').strip().split('\n')[-1].strip('%')
        return int(used_percentage)
    
    #Obtiene las lineas del log: STRING
    #lines son las lineas
    def get_log(self, lines):
        file_path = '/log.txt'
        if not os.path.exists(file_path):
            return ""
        result = subprocess.run(['tail', '-'+str(lines), file_path], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        last_lines = result.stdout.decode('utf-8')
        return last_lines

    #NO UTILIZADO POR AHORA
    def get_running_services_as_string(self):
        try:
            # Ejecutar el comando systemctl para listar servicios
            result = subprocess.run(['systemctl', 'list-units', '--type=service', '--state=running'], stdout=subprocess.PIPE)

            # Decodificar la salida a string
            output = result.stdout.decode('utf-8')

            # Procesar la salida para obtener nombres de servicios
            lines = output.splitlines()
            services = []
            for line in lines:
                if '.service' in line:
                    service_name = line.split()[0]
                    services.append(service_name)

            # Unir todos los servicios en una sola cadena con saltos de línea
            services_string = "\n".join(services)
            return services_string
        except Exception as e:
            print(f"An error occurred: {e}")
            return ""

    #Obtiene porcentaje de cpu: [FLOAT, LIST(FLOAT)]
    def get_cpu_usage(self):
        return [psutil.cpu_percent(interval=2),psutil.cpu_percent(interval=2, percpu=True)]
    
    #Obtiene porcentaje de ram: FLOAT
    def get_ram_usage(self):
        return psutil.virtual_memory().percent
    
    #Obtiene el tiempo desde el inicio del sistema operativo: STRING, INT
    def get_system_uptime(self):
        uptime_seconds = time.monotonic()
        uptime_minutes = uptime_seconds / 60
        uptime_hours = uptime_minutes / 60
        uptime_days = uptime_hours / 24

        str_uptime = f"{int(uptime_days)} days, {int(uptime_hours % 24)} hours, {int(uptime_minutes % 60)} minutes, {int(uptime_seconds % 60)} seconds"
        return str_uptime, int(uptime_seconds)

    
######################METODO EXTERNOS##################################

    def traceback(self):
        try:
            e = sys.exc_info()
            self.log("dumping traceback for [%s: %s]" % (str(e[0].__name__), str(e[1])))
            traceback.print_tb(e[2])
        except:
            foo = "bar"

    #Metodo obtiene el id de la version: STRING or ERROR MESSAGE
    def get_version_id_from_api(self):
        headers = {
            'accept': 'application/json',
            'Authorization': f'Bearer {self.token}',
            'Content-Type': 'application/json'
        }

        try:
            # Hacer la solicitud GET a la API
            response = requests.get(self.datalogger_version, headers=headers, timeout=10)

            # Comprobar si la solicitud fue exitosa
            if response.status_code == 200:
                data = response.json()
                print(data)

                # Buscar la versión en el campo 'Version'
                for item in data['data']:
                    version = item['attributes']['Version']
                    if self.os_version == version:
                        return item['id']

                return f"No se encontró la versión {self.os_version}"
            else:
                return f"Error en la solicitud: {response.status_code}"
        except Exception as e:
            print(f"An error occurred: {e}")
            return "Error al obtener la versión"

    #Metodo obtiene el tipo datalogger: STRIN OR ERROR MESSAGE
    def get_id_tipo_datalogger(self):
        headers = {
            'accept': 'application/json',
            'Authorization': f'Bearer {self.token}',
            'Content-Type': 'application/json'
        }
        try:
            response = requests.get(self.datalogger_tipo, headers=headers, timeout=10)
            if response.status_code == 200:
                data = response.json()
                for item in data['data']:
                    if item['attributes']['sigla'] == self.tipo:
                        return item['id']
                return "No se encontró el tipo de datalogger"
            else:
                return f"Error en la solicitud: {response.status_code}"
        except Exception as e:
            print(f"An error occurred: {e}")
            return "Error al obtener el tipo de datalogger"

    #Metodo de Actualizacion
    def update_or_create_datalogger(self, latitude, longitude, uploaded_cero):
        current_date = datetime.utcnow().strftime('%Y-%m-%dT%H:%M:%S.%f')[:-4] + 'Z'
        version_id = 0
        print(f"Version del sistema operativo: {self.os_version}")

        if self.os_version:
            # Buscar el ID de la versión en la API
            version_id = self.get_version_id_from_api()
            print("ID de la versión:", version_id)

            # Combinar version_id con description
            if isinstance(version_id, str):
                combined_servicios = f"ID de la versión: {self.os_version}"
            else:
                combined_servicios = f"(ID de la versión: {self.os_version})"
        else:
            combined_servicios = ''
        datalogger_tipo_id = self.get_id_tipo_datalogger()
        raspberry_temp = self.get_raspberry_temp()
        uptime = self.get_system_uptime()

        ##Obtencion del log
        log = self.get_log(80)
        delta = timedelta(hours=4)
        log_modified = 'INFO DEL LOG: '+(datetime.utcnow()-delta).strftime("%m/%d/%Y, %H:%M:%S") + '\n\n' + log

        ##Obtener ultimas filas DB y sanidad
        health = self.get_health()
        tabla = self.get_table()
        last_db_data ={
            "health": health[0],
            "tabla": tabla[0],
            "uptime": uptime[1]
        }

        if self.tipo=='ecom':
            combined_servicios += f"\n\nHostname: {self.host_name}\n\nWi-Fi Name: {self.wifi_name}\n\nWi-Fi Config: \n{self.get_wifi_config()}\n\nEvos Configuration: {self.get_evo_configuration()}\n\nTabla: \n{tabla[1]}\n\nSanidad: \n{health[1]}\n\nÚltimos datos de Sensor cabina:\n{self.get_last_data_cabina()}\n\nTemperatura: {self.get_raspberry_temp()} °C\n\nCPU: {self.get_cpu_usage()[0]}%\nRAM: {self.get_ram_usage()}%\nUPTIME: {uptime[0]}"
        elif self.tipo=='mmr':
            combined_servicios += f"\n\nHostname: {self.host_name}\n\nWi-Fi Name: {self.wifi_name}\n\nWi-Fi Config: \n{self.get_wifi_config()}\n\nTabla: \n{tabla[1]}\n\nSanidad: \n{health[1]}\n\nTemperatura: {self.get_raspberry_temp()} °C\n\nCPU: {self.get_cpu_usage()[0]}%\nRAM: {self.get_ram_usage()}%\nUPTIME: {uptime[0]}"
        elif self.tipo=='gimp':
            combined_servicios += f"\n\nHostname: {self.host_name}\n\nWi-Fi Name: {self.wifi_name}\n\nWi-Fi Config: \n{self.get_wifi_config()}\n\nTabla: \n{tabla[1]}\n\nTemperatura: {self.get_raspberry_temp()} °C\n\nCPU: {self.get_cpu_usage()[0]}%\nRAM: {self.get_ram_usage()}%\nUPTIME: {uptime[0]}"
        else:
            combined_servicios += f"\n\nHostname: {self.host_name}\n\nWi-Fi Name: {self.wifi_name}\n\nWi-Fi Config: \n{self.get_wifi_config()}\n\nTemperatura: {self.get_raspberry_temp()} °C\n\nCPU: {self.get_cpu_usage()[0]}%\nRAM: {self.get_ram_usage()}%\nUPTIME: {uptime[0]}"

        if self.tipo=='ecom' or self.tipo=='mmr' or self.tipo=='gimp':
            combined_servicios += f"\n\nDataloggers Instalados: \n{self.get_dataloggers()}"
        data = {
            "data": {
                "report_date": current_date,
                "lat": latitude,
                "lon": longitude,
                "log": [
                    {
                        "type": "paragraph",
                        "children": [
                            {
                                "type": "text",
                                "text": log_modified
                            }
                        ]
                    },

                ],
                "servicios": [
                    {
                        "type": "paragraph",
                        "children": [
                            {
                                "type": "text",
                                "text": combined_servicios
                            }
                        ]
                    },

                ],
                "datalogger_vrsn": version_id,
                "dataloggers_tipo": datalogger_tipo_id,
                "MachineId": self.machineid,
                "MachineName": self.machinename,
                "hdd": self.hdd,
                "Uploaded_cero": uploaded_cero,
                "temp": raspberry_temp,  # Campo de temperatura añadido
                "json": json.dumps(last_db_data)
            }
        }
        print("Datos a enviar para la actualización/creación:", data)

        headers = {
            'accept': 'application/json',
            'Authorization': f'Bearer {self.token}',
            'Content-Type': 'application/json'
        }

        params = {
            'filters[MachineId][$eq]': self.machineid
        }

        response = requests.get(self.base_url, headers=headers, params=params, timeout=10)

        if response.status_code == 200:
            data_response = response.json()
            print("Respuesta del servidor al obtener el registro:", data_response)

            if data_response['data']:
                record_id = data_response['data'][0]['id']
                print(f'Registro encontrado con ID: {record_id}')

                update_url = f'{self.base_url}/{record_id}'
                response = requests.put(update_url, headers=headers, json=data, timeout=10)

                if response.status_code == 200:
                    print('Los campos report_date, lat, lon, log, MachineId, MachineName, hdd y Uploaded_cero se actualizaron correctamente.')
                else:
                    print(f'Error al actualizar los campos: {response.status_code}')
                    try:
                        print(response.json())
                    except ValueError:
                        print(response.text)
            else:
                ####ACA AREGAMOS NUEVO ID Y SUS CONFIGURACIONES BASES
                print(f'No se encontró ningún registro con MachineId = {self.machineid}. Creando un nuevo registro.')
                #AGREGAMOS COONFIG BASE A DATA
                data['data']['faena']=2
                data['data']['faena_ubicacion']=16
                data['data']['datalogger_estado']=5
                print(data)
                response = requests.post(self.base_url, headers=headers, json=data, timeout=10)

                if response.status_code == 200 or response.status_code == 201:
                    print('Nuevo registro creado correctamente.')
                else:
                    print(f'Error al crear el nuevo registro: {response.status_code}')
                    try:
                        print(response.json())
                    except ValueError:
                        print(response.text)
        else:
            print(f'Error al obtener el registro: {response.status_code}')
            try:
                print(response.json())
            except ValueError:
                print(response.text)



if __name__== '__main__':
    inicio_live = Live()
    inicio_live.app()
