import requests
import sys
import json
import os

sys.path.append('/srv/datalogger_gimp/')
from lib.utils import Utils

SOURCE_CONFIG = "/srv/datalogger_gimp/config_gimp.json"
SOURCE_URLS = "/srv/datalogger_gimp/config/urls.json"
TOKEN = "ab2399f4d1cb524b4148066d40b5028e4fe6e97a4b5a1c961c1ec6d96c1b479f737418da717d9b8293e554f74551b515b0fddb96251c8876d569f48d39f0751937e26942e0fabcf3bb31a4e5b9be62cd1d3252d3cc44e24230184001e2e1541a0ed2b99bb28d6cdb5d73a5ffa8e227c79ee45e14678a00d706ca917a11eeeddf"

class Config(Utils):
	def __init__(self, log_id = "CONFIG"):
		self.log_id = log_id
		self.machine_id = self.get_product_id()
		self.machine_name = self.get_product_name()
		self.location = self.get_location_assigned()
		self.faena = self.get_faena_assigned()
	
	def check_exist(self, source_config):
		self.log("Checking config files...")
		if not os.path.isfile(source_config):
			self.log("Config_gimp.json not found")
			config_gimp = {
				"SERVER":{
					"IP": "127.0.0.1",
					"PORT": 20001
				},
				"DUST_SENSOR": {
					"PORT": "ESP32",
					"MIN_VALUE_PM100": 0,
					"MIN_VALUE_PM10": 0,
				},
				"GPS_SENSOR": {
					"PORT": "GPS",
					"MODEL": "GPS_USB",
				},

				"AMBIENT": {
					"DEVICE": "",
					"SECONDS_REQUEST": 40,
				},
				"AUTOUPLOAD": {
					"MINING":{
						"ACTIVATED": 1,
						"DATA": "",
						"LOCATION": "",
					},
					"EYE3":{
						"ACTIVATED": 1,
						"DATA": "",
					}
				},
				"TEST_MODE":0	
			}
			
			with open(source_config, "w") as f:
				json.dump(config_gimp, f, indent=len(config_gimp))
				self.log("Config_gimp.json created")


	def update_mining_config(self, source_config):
		print("UPDATE MINING CONFIG")
		TOPIC_DATA= f"{self.faena}/dataloggers/{self.location}/{self.machine_name}"
		TOPIC_LOCATION = f"{self.faena}/dataloggers/mapa/{self.location}/{self.machine_name}"
		with open(source_config, 'r') as f:
			config = json.load(f)
		
		if config["AUTOUPLOAD"]["MINING"]["DATA"] != TOPIC_DATA or config["AUTOUPLOAD"]["MINING"]["LOCATION"] != TOPIC_LOCATION:
			print("TOPICO CAMBIO SE ACTUALIZARÁ EN EL CONFIG Y SE REINICIARÁ LA BASE DE DATOS")
			config["AUTOUPLOAD"]["MINING"]["DATA"] = TOPIC_DATA
			config["AUTOUPLOAD"]["MINING"]["LOCATION"] = TOPIC_LOCATION

			with open(source_config, "w") as f:
				json.dump(config, f, indent=len(config))

			db_restart_cmd = "sudo python3 /srv/datalogger_gimp/database/models.py --reset_db true"
			self.command(db_restart_cmd)
			print("CONFIGURACION MINING ACTUALIZADA") 

			# Update autoupload services
			self.restart_service("mining-autoupload")
			self.restart_service("mining-autoupload-gps")
		else:
			print("CONFIGURACION MINING YA ESTA ACTUALIZADA")
	
	def update_eye3_config(self, source_urls, source_config):
		try:
			with open(SOURCE_CONFIG, 'r') as f:
				config = json.load(f)
			if not config["AUTOUPLOAD"]["EYE3"]["ACTIVATED"]: return

			print("UPDATE EYE3 CONFIG")
			urls_config =json.load(open(source_urls))
			print(f"Faena asiganda {self.faena}")

			if urls_config:
				faena = urls_config.get(self.faena, "")
				with open(source_config, 'r') as f:
					config = json.load(f)
				if config["AUTOUPLOAD"]["EYE3"]["DATA"] != faena:
					config["AUTOUPLOAD"]["EYE3"]["DATA"] = faena

					with open(source_config, "w") as f:
						json.dump(config, f, indent=len(config))
					
					print("CONFIGURACION EYE3 ACTUALIZADA")
					# Update autoupload service
					self.restart_service("mining-autoupload")
				else:
					print("CONFIGURACION EYE3 YA ESTA ACTUALIZADA")
			else:
				print("NO EXISTE EL ARCHIVO DE CONFIGURACION URL")
		except Exception as e:
			print(f"An error occurred: {e}")

	def update_autoupload_eye3_flag(self, source_config, token):
		print("ACTUALIZANDO AUTOUPLOAD EYE3 FLAG")			
		try:
			with open(source_config, 'r') as f:
					config = json.load(f)
			headers = {
				'accept': 'application/json',
				'Authorization': f'Bearer {token}',
				'Content-Type': 'application/json'
			}
			url_base = "http://core.mine-360.com:1337/api/"
			url = f'{url_base}faena-ubicacions?filters[FaenaUbicacion][$eq]={self.location}&[fields]=eye3'
			print(url)
			response = requests.get(url, headers=headers)

			if response.status_code == 200:
				data = response.json()
				print(data)
				if data["data"]:
					flag_eye3 = int(data["data"][0]["attributes"]["eye3"])
					# only if change, update config
					if config["AUTOUPLOAD"]["EYE3"]["ACTIVATED"] != flag_eye3:
						config["AUTOUPLOAD"]["EYE3"]["ACTIVATED"] = flag_eye3
						with open(source_config, "w") as f:
							json.dump(config, f, indent=len(config))

						# Restart autoupload and autoupload-gps service
						print("AUTOUPLOAD EYE3 FLAG ACTUALIZADO")
						self.restart_service("mining-autoupload")
						self.restart_service("mining-autoupload-gps")
				else:
					print("NO EXISTE LA FAENA UBICACION EN EL CORE")
			else:
				print("FALLA AL CONECTAR CON EL CORE")

		except Exception as e:
			print(f"An error occurred: {e}")

	
	def update_em(self, token, source_config):
		em = ""
		try:
			headers = {
				'accept': 'application/json',
				'Authorization': f'Bearer {token}',
				'Content-Type': 'application/json'
			}
			url_base = "http://core.mine-360.com:1337/api/"
			url = f'{url_base}faena-ubicacions?filters[FaenaUbicacion][$eq]={self.location}&populate[sensores][fields][1]=MachineName&fields[0]=id'
			print(url)
			response = requests.get(url, headers=headers)

			if response.status_code == 200:
				data = response.json()
				print(data)
				if data["data"]:
					data = data["data"][0]
					sensores = data["attributes"]["sensores"]["data"]
					print(sensores)
					if len(sensores)==1:
						sensor = sensores[0]["attributes"]["MachineName"]
						print(f"sensor: {sensor}")
						if "EM" in sensor:
							em = sensores[0]["attributes"]["MachineName"]

			if em:
				with open(source_config, 'r') as f:
					config = json.load(f)

				# only if change, update config
				if config["AMBIENT"]["DEVICE"] != em:
					config["AMBIENT"]["DEVICE"] = em
					with open(source_config, "w") as f:
						json.dump(config, f, indent=len(config))

					# Update ambient service
					print("ESTACION METEREOLOGICA ACTUALIZADA")
					self.restart_service("mining-ambient")
			else:
				print("ESTACION METEREOLOGICA YA ESTA ACTUALIZADA")

		except Exception as e:
			print(f"An error occurred: {e}")



if __name__ == "__main__":
	config = Config()
	print("Actualizando configuraciones")
	
	# 1. Check if config files exist
	config.check_exist(source_config= SOURCE_CONFIG)

	# 2. Update mining config
	config.update_mining_config(source_config= SOURCE_CONFIG)

	# 3. Update eye3 config
	config.update_autoupload_eye3_flag(source_config=SOURCE_CONFIG, token= TOKEN)
	config.update_eye3_config(source_urls= SOURCE_URLS, source_config= SOURCE_CONFIG)

	# 4.  Update Estacion Metereologica
	config.update_em(token= TOKEN, source_config= SOURCE_CONFIG)


	
