import sys
import json
import os
import requests
import time

sys.path.append('/srv/datalogger_ecom/')
from lib.utils import Utils

SOURCE_CONFIG = "/srv/datalogger_ecom/config_ecom.json"
SOURCE_GEOFENCE = "/srv/datalogger_ecom/geofence.json"
TOKEN = "ab2399f4d1cb524b4148066d40b5028e4fe6e97a4b5a1c961c1ec6d96c1b479f737418da717d9b8293e554f74551b515b0fddb96251c8876d569f48d39f0751937e26942e0fabcf3bb31a4e5b9be62cd1d3252d3cc44e24230184001e2e1541a0ed2b99bb28d6cdb5d73a5ffa8e227c79ee45e14678a00d706ca917a11eeeddf"

class Config(Utils):
	def __init__(self, log_id = "CONFIG"):
		self.log_id = log_id
		self.machine_id = self.get_product_id()
		self.machine_name = self.get_product_name()
		self.location = self.get_location_assigned()
		self.faena = self.get_faena_assigned()
		self.avalaible_faenas = self.get_avalaible_faenas()
	
	def check_exist(self, source_config):
		self.log("Checking config files...")
		if not os.path.isfile(source_config):
			self.log("Config_ecom.json not found")
			config_ecom = {
				"SERVER":{
					"IP": "127.0.0.1",
					"PORT": 20001,
					"MAX_LEN_PACKET_DATA": 60,
					"SECONDS_MICRODATA": 1.5
				},
				"DUST_SENSOR":{
					"PORT": "nano",
					"MIN_VALUE_PM100": 0,
					"MAX_VALUE_PM100": 40000,
					"EVOS": [],
					"AUTOUPDATE_EVO": 1
				},
				"GPS_SENSOR": {
					"PORT": "gps",
					"MIN_VALUE_SPEED": -1,
					"MODEL": "GPS_MASTER",
				},
				"AUTOUPLOAD": {
					"MINING":{
						"ACTIVATED": 1,
						"DATA": "",
						"LOCATION": "",
					},
				},
				"TEST_MODE":0,
				"GEOFENCE_URL": f'https://{self.faena.replace(" ", "").lower()}.mapa.mine-360.com/api/geofence' if self.faena in self.avalaible_faenas else ""
			}

			with open(source_config, "w") as f:
				json.dump(config_ecom, f, indent=len(config_ecom))
				self.log("Config_ecom.json created")

	def update_mining_config(self, source_config):
		print("UPDATE MINING CONFIG")
		TOPIC_DATA= f"{self.faena}/dataloggers/{self.location}/{self.machine_name}"
		TOPIC_LOCATION = f"{self.faena}/dataloggers/mapa/{self.location}/{self.machine_name}"
		with open(SOURCE_CONFIG, 'r') as f:
			config = json.load(f)
		
		if config["AUTOUPLOAD"]["MINING"]["DATA"] != TOPIC_DATA or config["AUTOUPLOAD"]["MINING"]["LOCATION"] != TOPIC_LOCATION:
			print("TOPICO HA CAMBIADO, SE ACTUALIZARÁ EN EL CONFIG Y SE REINICIARÁ LA BASE DE DATOS")
			config["AUTOUPLOAD"]["MINING"]["DATA"] = TOPIC_DATA
			config["AUTOUPLOAD"]["MINING"]["LOCATION"] = TOPIC_LOCATION

			with open(source_config, "w") as f:
				json.dump(config, f, indent=len(config))
			
			db_restart_cmd = "sudo python3 /srv/datalogger_ecom/database/models.py --reset_db true"
			self.command(db_restart_cmd)
			print("CONFIGURACION MINING ACTUALIZADA")
		
			# Update autoupload services
			self.restart_service("mining-autoupload")
			self.restart_service("mining-autoupload-gps")
		else:
			print("CONFIGURACION MINING YA ESTA ACTUALIZADA")

	
	def update_evo(self, source_config, token):
		print("ACTUALIZANDO EVO ASIGNADO")			
		evos = []
		try:
			with open(source_config, 'r') as f:
					config = json.load(f)
			headers = {
				'accept': 'application/json',
				'Authorization': f'Bearer {token}',
				'Content-Type': 'application/json'
			}
			url_base = "http://core.mine-360.com:1337/api/"
			url = f'{url_base}faena-ubicacions?filters[FaenaUbicacion][$eq]={self.location}&populate[sensores][fields][1]=MachineName&populate[dataloggers][fields][1]=MachineId&fields[0]=id'
			print(url)
			response = requests.get(url, headers=headers)

			if response.status_code == 200:
				data = response.json()
				print(data)
				for data_evo in data["data"]:
					exist = 0
					for datalogger in data_evo['attributes']['dataloggers']['data']:
						if str(self.machine_id) == datalogger['attributes']['MachineId']:
							exist =1
							break
					if exist == 1:
						sensores = data_evo["attributes"]["sensores"]["data"]
						print(sensores)
						for sensor_data in sensores:
							sensor = sensor_data["attributes"]["MachineName"]
							print(f"sensor: {sensor}")
							if "evo" in sensor:
								evo = sensor
								#number = re.findall('\d+', evo)
								evo_c = evo.split('-')
								if evo_c:
									evos.append(evo_c[1])
									evos.append(evo_c[1]+'c')

				if evos:
					# only if change, update config
					if sorted(config["DUST_SENSOR"]["EVOS"]) != sorted(evos):
						config["DUST_SENSOR"]["EVOS"] = evos
						with open(source_config, "w") as f:
							json.dump(config, f, indent=len(config))

						# Update serial service
						print("EVO ACTUALIZADO")
						self.restart_service("mining-serial")
				else:
					print("NO HAY EVO CONFIGURADO EN EL CORE")
			else:
				print("FALLA AL CONECTAR CON EL CORE")

		except Exception as e:
			print(f"An error occurred: {e}")

		
	def update_geofence(self, source_config, source_geofence):
		try:
			print("Check Geofence")
			if self.faena in self.avalaible_faenas:
			# 1. Check if geofence files exist
				if not os.path.isfile(source_geofence):
					print("Geofence.json not found")
					# Download geofence from API
					self.download_geofence(source_config, source_geofence)
					self.restart_service("mining-gps")

				else:
					print("Geofence.json found")
					# checking for updates
					print("Checking for updates")
					last_timestamp_geofence = os.path.getmtime(source_geofence)
					if time.time() - last_timestamp_geofence >= 60*60*24*7: # 7 dias
						print("Geofence.json is older than 7 days, try update")
						# Update geofence from API
						self.download_geofence(source_config, source_geofence)
						self.restart_service("mining-gps")
					else: print("Geofence not cahnge in the last 7 days")
			else:
				print("No hay faena asignada")
		except:
			self.traceback()
			self.log("Error updating geofence")

	def download_geofence(self, source_config, source_geofence):
		try:
			config =json.load(open(source_config))
			api_url = config["GEOFENCE_URL"]
			if api_url:
				source_raw_geofence = "/srv/datalogger_ecom/raw_geofence.json"
				geofence_cmd = f"wget {api_url} -O {source_raw_geofence}"

				print(f"Downloading GEOFENCE geometry from: {api_url}")
				print("[%s] ..." % geofence_cmd)
				self.command(geofence_cmd)

				try:
					raw_geofence =json.load(open(source_raw_geofence))
					if "ok" in raw_geofence:
						print("Geofence tiene la nueva estructura, cambiando ...")
						# Cambiar la estructura
						geofence = raw_geofence["data"][0]["row_to_json"]
						with open(source_geofence, "w") as f:
							json.dump(geofence, f)
						print("Geofence guardada con estructura corregida")

					else:
						print("Estructura geofence correcta!")
						geofence = raw_geofence
						with open(source_geofence, "w") as f:
							json.dump(geofence, f)
						print("Geofence guardada")
					
				except:
					print("Error procesando geofence")
			else:
				print("No existe url para descarga de geofence")
		except:
			self.traceback()
			self.log("Error updating geofence")


if __name__ == "__main__":
	config = Config()
	print("Actualizando configuraciones")
	# 1. Check if config files exist
	config.check_exist(source_config= SOURCE_CONFIG)

	# 2. Update mining config
	config.update_mining_config(source_config= SOURCE_CONFIG)

	# 3. Check EVO
	config.update_evo(source_config= SOURCE_CONFIG, token= TOKEN)

	# 4. Update geofence
	config.update_geofence(source_config= SOURCE_CONFIG, source_geofence= SOURCE_GEOFENCE)










