import sys
import json
import os

sys.path.append('/srv/datalogger_gimp/')
from lib.utils import Utils

SOURCE_CONFIG = "/srv/datalogger_gimp/config_gimp.json"

class Config(Utils):
	def __init__(self, log_id = "CONFIG"):
		self.log_id = log_id
		self.machine_id = self.get_product_id()
		self.machine_name = self.get_product_name()
		self.location = self.get_location_assigned()
		self.faena = self.get_faena_assigned()
	
	def check_exist(self, source_config):
		self.log("Checking config files...")
		if not os.path.isfile(source_config):
			self.log("Config_gimp.json not found")
			config_gimp = {
				"SERVER":{
					"IP": "127.0.0.1",
					"PORT": 20001
				},
				"DUST_SENSOR": {
					"PORT": "ESP32",
					"MIN_VALUE_PM100": 0,
					"MIN_VALUE_PM10": 0,
				},
				"GPS_SENSOR": {
					"PORT": "GPS",
					"MODEL": "GPS_USB",
				},

				"AUTOUPLOAD": {
					"MINING":{
						"ACTIVATED": 1,
						"DATA": "",
						"LOCATION": "",
					},
				},
				"TEST_MODE":0	
			}
			
			with open(source_config, "w") as f:
				json.dump(config_gimp, f, indent=len(config_gimp))
				self.log("Config_gimp.json created")


	def update_mining_config(self, source_config):
		print("UPDATE MINING CONFIG")
		TOPIC_DATA= f"{self.faena}/dataloggers/{self.location}/{self.machine_name}"
		TOPIC_LOCATION = f"{self.faena}/dataloggers/mapa/{self.location}/{self.machine_name}"
		with open(source_config, 'r') as f:
			config = json.load(f)
		
		if config["AUTOUPLOAD"]["MINING"]["DATA"] != TOPIC_DATA or config["AUTOUPLOAD"]["MINING"]["LOCATION"] != TOPIC_LOCATION:
			print("TOPICO CAMBIO SE ACTUALIZARÁ EN EL CONFIG Y SE REINICIARÁ LA BASE DE DATOS")
			config["AUTOUPLOAD"]["MINING"]["DATA"] = TOPIC_DATA
			config["AUTOUPLOAD"]["MINING"]["LOCATION"] = TOPIC_LOCATION

			with open(source_config, "w") as f:
				json.dump(config, f, indent=len(config))

			db_restart_cmd = "sudo python3 /srv/datalogger_gimp/database/models.py --reset_db true"
			self.command(db_restart_cmd)
			print("CONFIGURACION MINING ACTUALIZADA") 

			# Update autoupload services
			self.restart_service("mining-autoupload")
			self.restart_service("mining-autoupload-gps")
		else:
			print("CONFIGURACION MINING YA ESTA ACTUALIZADA")


if __name__ == "__main__":
	config = Config()
	print("Actualizando configuraciones")
	
	# 1. Check if config files exist
	config.check_exist(source_config= SOURCE_CONFIG)

	# 2. Update mining config
	config.update_mining_config(source_config= SOURCE_CONFIG)



	
