import subprocess
import datetime
import json

class Actualizar():
    def __init__(self):
        self.log_id="ACTUALIZADOR"

    def getProductId(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","robot"]).decode()
        tcp = int(data.split(":")[2])
        return (tcp - 10000) # Mother/Jarvis product ID

    def getProductName(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","name"]).decode()
        data = data.split("'")[3].strip()
        return data
    
    # Metodo Lanza linea de comando: None
    def comando(self,orden,modo=1):
        orden_s=orden.split(' ')
        if modo==1:
            res=subprocess.check_output(orden_s)
            if res.decode()!='\n' or res.decode()!='':
                print(res.decode())
        elif modo==0:
            try:
                res=subprocess.check_output(orden_s)
                if res.decode()!='\n' or res.decode()!='':
                    print(res.decode())
            except: pass

    # Metodo entrega tipo de equipo: STRING
    def tipo(self):
        res=subprocess.check_output('machinename')
        nombre=res.decode().split('-')
        return nombre[0].lower() # return en minuscula


    # Metodo entrega el numero del equipo: INT
    # Ejemplo: ecom-500 entrega 500
    def numero(self):
        res=subprocess.check_output('machinename')
        num_equipo=res.decode().split('-')
        try:
            return int(num_equipo[1])
        except:
            return 0
    
    # Metodo entrega ID; INT
    def id(self):
        res=subprocess.check_output('machineid').decode()
        return int(res)

    # Metodo que agrega el output al log: None
    def log(self,message):
        dt = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        print("[%s] %s | %s" % (self.log_id, dt, message))
        with open ("/log.txt", "a") as myfile:
            myfile.write("[%s] %s | %s\n" % (self.log_id, dt, message))

    # Meotod reemplaza string en archivo: None
    def reemplazar(self, ruta_archivo, texto_out, texto_in):
        with open(ruta_archivo,'r') as archivo:
            contenido=archivo.read()
        contenido_2 = contenido.replace(texto_out,texto_in)

        with open(ruta_archivo, 'w') as archivo_nuevo:
            archivo_nuevo.write(contenido_2)
    
    def ver_datalogger(self, opcion= 2):
        lista=[]
        resp=subprocess.check_output(['ls','/srv/']).decode()
        if self.tipo()=='mmr' and 'pruebas-riego' in resp:
            lista.append('MMR EYE3')
        if 'datalogger_mmr' in resp:
            lista.append('MMR MINING')
        if self.tipo()=='ecom' and 'dio' in resp:
            res2 = subprocess.check_output(['ls','/srv/dio/']).decode()
            if 'gps_config.json' in res2:
                lista.append('ECOM EYE3 MASTER')
            else:
                lista.append('ECOM EYE3')
        if 'datalogger_ecom' in resp:
            lista.append('ECOM MINING')
        if self.tipo()=='gimp' and 'dio' in resp:
            lista.append('GIMP EYE3')
        if 'datalogger_gimp' in resp:
            lista.append('GIMP MINING')
        for i in resp.split('\n'):
            if i=='datalogger':
                lista.append('CABINA')
        if len(lista)==0: print('No hay dataloggers instalados')
        #if opcion==1:
        for i in range(len(lista)):
            print(str(i+1)+'. '+lista[i])
        print('')
        if opcion==1:
            return []
        elif opcion==2:
            return lista
            
    def get_faena_assigned(self):
        faena = "TallerStgo"
        try:
            f = open('/srv/live/topic.json')
            config:dict = json.load(f)
            faena = config["topic"].split("/")[0]
        except:
            print("Error obteniendo Faena")
        return faena
    
    # Metodo funcional: None
    def app(self):
        self.nombre = self.tipo()
        try:
            self.log("Actualizando a Mining 3.0.0...")

            if self.nombre!='tablet':
                datalogger = self.ver_datalogger()
                print("[1] Delete Check Datalogger")
                self.comando('sudo sh /etc/mining/check_datalogger/uninstall.sh', 0)
                self.comando('sudo rm -r /etc/mining/check_datalogger', 0)
                print("[2] Check Datalogger deleted")


                if 'GIMP MINING' in datalogger:
                    print("[3] Actualizando Datalogger GIMP")
                    self.comando('sudo sh /srv/datalogger_gimp/ambient/uninstall.sh')
                    self.comando('sudo rm /srv/datalogger_gimp/config/urls.json', 0)
                    self.comando('sudo cp GIMP/install.sh /srv/datalogger_gimp/install.sh')
                    self.comando('sudo cp GIMP/uninstall.sh /srv/datalogger_gimp/uninstall.sh')
                    self.comando('sudo cp GIMP/tables.py /srv/datalogger_gimp/database/tables.py')
                    self.comando('sudo cp GIMP/models.py /srv/datalogger_gimp/database/models.py')
                    self.comando('sudo cp GIMP/utils.py /srv/datalogger_gimp/lib/utils.py')
                    self.comando('sudo cp GIMP/main_config.py /srv/datalogger_gimp/config/__main__.py')
                    self.comando('sudo cp GIMP/main_server.py /srv/datalogger_gimp/server/__main__.py')
                    self.comando('sudo systemctl restart mining-server')
                    self.comando('sudo cp GIMP/main_autoupload.py /srv/datalogger_gimp/autoupload/__main__.py')
                    self.comando('sudo systemctl restart mining-autoupload')
                    print("[4] Datalogger GIMP Actualizados Correctamente")
                
                elif 'ECOM MINING' in datalogger:
                    print("[5] Actualizando Datalogger ECOM")
                    self.comando('sudo rm /srv/datalogger_ecom/config/urls.json', 0)
                    self.comando('sudo cp ECOM/tables.py /srv/datalogger_ecom/database/tables.py')
                    self.comando('sudo cp ECOM/models.py /srv/datalogger_ecom/database/models.py')
                    self.comando('sudo cp ECOM/utils.py /srv/datalogger_ecom/lib/utils.py')
                    self.comando('sudo cp ECOM/main_config.py /srv/datalogger_ecom/config/__main__.py')
                    self.comando('sudo cp ECOM/main_autoupload_gps.py /srv/datalogger_ecom/autoupload-gps/__main__.py')
                    self.comando('sudo systemctl restart mining-autoupload-gps')
                    self.comando('sudo cp ECOM/main_autoupload.py /srv/datalogger_ecom/autoupload/__main__.py')
                    self.comando('sudo systemctl restart mining-autoupload')
                    print("[6] Datalogger ECOM Actualizados Correctamente")
                
                elif 'MMR MINING' in datalogger:
                    print("[7] Actualizando Datalogger MMR")
                    self.comando('sudo rm /srv/datalogger_mmr/config/urls.json', 0)
                    self.comando('sudo cp MMR/tables.py /srv/datalogger_mmr/database/tables.py')
                    self.comando('sudo cp MMR/models.py /srv/datalogger_mmr/database/models.py')
                    self.comando('sudo cp MMR/utils.py /srv/datalogger_mmr/lib/utils.py')
                    self.comando('sudo cp MMR/gps_lib.py /srv/datalogger_mmr/gps/gps_lib.py')
                    self.comando('sudo systemctl restart mining-gps')
                    self.comando('sudo cp MMR/main_config.py /srv/datalogger_mmr/config/__main__.py')
                    self.comando('sudo cp MMR/main_server.py /srv/datalogger_mmr/server/__main__.py')
                    self.comando('sudo systemctl restart mining-server')
                    self.comando('sudo cp MMR/main_autoupload_gps.py /srv/datalogger_mmr/autoupload-gps/__main__.py')
                    self.comando('sudo systemctl restart mining-autoupload-gps')
                    self.comando('sudo cp MMR/main_autoupload.py /srv/datalogger_mmr/autoupload/__main__.py')
                    self.comando('sudo systemctl restart mining-autoupload')
                    print("[8] Datalogger MMR Actualizados Correctamente")
                

                print('[9] Actualizando Checks')
                self.comando('sudo cp check_gimp.py /srv/checks/gimp_mining/check_equipo.py',0)
                self.comando('sudo cp check_ecom.py /srv/checks/ecom_mining/check_equipo.py',0)
                self.comando('sudo cp check_mmr.py /srv/checks/mmr_mining/check_equipo.py',0)
                print('[10] Checks Actualizados')

                print('[11] Eliminando servicio mining-id')
                self.comando('sudo cp mining-id /bin/mining-id')
                self.comando('sudo chmod 777 /bin/mining-id')
                self.comando('sudo systemctl stop mining-id',0)
                self.comando('sudo systemctl disable mining-id',0)
                self.comando('sudo rm /etc/systemd/system/mining-id.service',0)
                print('[12] Mining-id eliminado')

                print('[13] Actualizando mining-health')
                self.comando('sudo cp mining-health /bin/mining-health')
                self.comando('sudo chmod 777 /bin/mining-health')
                self.comando('sudo systemctl restart mining-health')
                print('[14] Mining-health actualizado')

                print('[15] Eliminando sistemas EYE3')
                self.comando('sudo systemctl stop eye3-mother', 0)
                self.comando('sudo systemctl disable eye3-mother', 0)
                self.comando('sudo rm /etc/systemd/system/eye3-mother.service', 0)
                self.comando('sudo rm -r /etc/eye3', 0)
                print('[16] Sistemas EYE3 eliminados')

                print('[17] Actualizando comando mining...')
                self.comando('sudo cp mining /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[18] Comando mining Actualizado')

            else:
                print('[1] Eliminando servicio mining-id')
                self.comando('sudo cp mining-id /bin/mining-id')
                self.comando('sudo chmod 777 /bin/mining-id')
                self.comando('sudo systemctl stop mining-id',0)
                self.comando('sudo systemctl disable mining-id',0)
                self.comando('sudo rm /etc/systemd/system/mining-id.service',0)
                print('[2] Mining-id eliminado')

                print('[3] Actualizando mining-health')
                self.comando('sudo cp mining-health /bin/mining-health')
                self.comando('sudo chmod 777 /bin/mining-health')
                self.comando('sudo systemctl restart mining-health')
                print('[4] Mining-health actualizado')

                print('[5] Eliminando sistemas EYE3')
                self.comando('sudo systemctl stop eye3-mother')
                self.comando('sudo systemctl disable eye3-mother')
                self.comando('sudo rm /etc/systemd/system/eye3-mother.service')
                self.comando('sudo rm -r /etc/eye3')
                print('[6] Sistemas EYE3 eliminados')

                print('[7] Actualizando comando mining...')
                self.comando('sudo cp mining_tablet /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[8] Comando mining Actualizado')

            file = open("/etc/mining/version", "w")
            file.write("39\n")
            file.close()

            self.log("Actualizacion a Mining 3.0.0 Finalizada")

        except:
            self.log("Error actualizando el sistema")

#####RUN########
entorno = Actualizar()
entorno.app()




