import subprocess
import datetime
import json
from time import sleep

class Actualizar():
    def __init__(self):
        self.log_id="ACTUALIZADOR"

    def getProductId(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","robot"]).decode()
        tcp = int(data.split(":")[2])
        return (tcp - 10000) # Mother/Jarvis product ID

    def getProductName(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","name"]).decode()
        data = data.split("'")[3].strip()
        return data
    
    # Metodo Lanza linea de comando: None
    def comando(self,orden,modo=1):
        orden_s=orden.split(' ')
        if modo==1:
            res=subprocess.check_output(orden_s)
            if res.decode()!='\n' or res.decode()!='':
                print(res.decode())
        elif modo==0:
            try:
                res=subprocess.check_output(orden_s)
                if res.decode()!='\n' or res.decode()!='':
                    print(res.decode())
            except: pass

    # Metodo entrega tipo de equipo: STRING
    def tipo(self):
        res=subprocess.check_output('machinename')
        nombre=res.decode().split('-')
        return nombre[0].lower() # return en minuscula


    # Metodo entrega el numero del equipo: INT
    # Ejemplo: ecom-500 entrega 500
    def numero(self):
        res=subprocess.check_output('machinename')
        num_equipo=res.decode().split('-')
        try:
            return int(num_equipo[1])
        except:
            return 0
    
    # Metodo entrega ID; INT
    def id(self):
        res=subprocess.check_output('machineid').decode()
        return int(res)

    # Metodo que agrega el output al log: None
    def log(self,message):
        dt = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        print("[%s] %s | %s" % (self.log_id, dt, message))
        with open ("/log.txt", "a") as myfile:
            myfile.write("[%s] %s | %s\n" % (self.log_id, dt, message))

    # Meotod reemplaza string en archivo: None
    def reemplazar(self, ruta_archivo, texto_out, texto_in):
        with open(ruta_archivo,'r') as archivo:
            contenido=archivo.read()
        contenido_2 = contenido.replace(texto_out,texto_in)

        with open(ruta_archivo, 'w') as archivo_nuevo:
            archivo_nuevo.write(contenido_2)
    
    def ver_datalogger(self, opcion= 2):
        lista=[]
        resp=subprocess.check_output(['ls','/srv/']).decode()
        if self.tipo()=='mmr' and 'pruebas-riego' in resp:
            lista.append('MMR EYE3')
        if 'datalogger_mmr' in resp:
            lista.append('MMR MINING')
        if self.tipo()=='ecom' and 'dio' in resp:
            res2 = subprocess.check_output(['ls','/srv/dio/']).decode()
            if 'gps_config.json' in res2:
                lista.append('ECOM EYE3 MASTER')
            else:
                lista.append('ECOM EYE3')
        if 'datalogger_ecom' in resp:
            lista.append('ECOM MINING')
        if self.tipo()=='gimp' and 'dio' in resp:
            lista.append('GIMP EYE3')
        if 'datalogger_gimp' in resp:
            lista.append('GIMP MINING')
        for i in resp.split('\n'):
            if i=='datalogger':
                lista.append('CABINA')
        if len(lista)==0: print('No hay dataloggers instalados')
        #if opcion==1:
        for i in range(len(lista)):
            print(str(i+1)+'. '+lista[i])
        print('')
        if opcion==1:
            return []
        elif opcion==2:
            return lista
            
    def get_faena_assigned(self):
        faena = "TallerStgo"
        try:
            f = open('/srv/live/topic.json')
            config:dict = json.load(f)
            faena = config["topic"].split("/")[0]
        except:
            print("Error obteniendo Faena")
        return faena
    
    # Metodo funcional: None
    def app(self):
        self.nombre = self.tipo()
        try:
            self.log("Actualizando a Mining 3.1.0...")


        
            print("[1] Actualizando comando ups")
            self.comando('cp ups /bin/ups')
            self.comando('sudo chmod 777 /bin/ups')
            print("[2] comando ups Actualizado")

            if self.nombre!='tablet':

                ## LIVE ##
                import os
                print("[3] Actualizando pw service")
                self.comando('sudo rm -r /etc/pw', 0)
                self.comando('sudo cp -R pw /etc/pw')
                self.comando("sudo chmod 777 /etc/pw/pw")
                self.comando('sh /etc/pw/install.sh')
                sleep(3)
                

                ##SECCION ESPECIAL
                file_path = "/dev/shm/credentials.json"
                if not os.path.exists(file_path):
                    print(f"The path '{file_path}' does not exists.")
                    raise ValueError("El archivo credentials no se creo correctamente, por lo que no se puede continuar con la actualización")
                print("[4] pw service Actualizado")

                print("[5] Actualizando Report")
                self.comando('sudo cp report.py /srv/live/report.py')
                print("[6] Report Actualizado")

                print('[7] Actualizando Live Service...')
                self.comando('sudo cp live.py /srv/live/__main__.py')
                self.comando("systemctl restart mining-live.service")
                print('[8] Live Service Actualizado')

                print('[9] Actualizando mining-topic Service...')
                self.comando('sudo cp mining_topic.py /srv/live/mining-topic/__main__.py')
                self.comando('sudo rm /srv/live/topic.json', 0)
                self.comando('sudo rm /topic.json', 0)
                self.comando("systemctl restart mining-topic.service")
                print('[10] mining-topic Service Actualizado')
                sleep(3)

                ## DATALOGGERS ##
                datalogger = self.ver_datalogger()
                faena = self.get_faena_assigned()
                avalaible_faenas = ["Candelaria", "Ministro Hales", "Centinela"]
                if 'GIMP MINING' in datalogger:
                    print("[11] Actualizando Datalogger GIMP")
                    self.comando('sudo cp mqtt_gimp.py /srv/datalogger_gimp/lib/mqtt.py')
                    self.comando('sudo systemctl restart mining-autoupload')
                    self.comando('sudo systemctl restart mining-autoupload-gps')
                    print("[12] Datalogger GIMP Actualizados Correctamente")
                
                elif 'ECOM MINING' in datalogger:
                    print("[13] Actualizando Datalogger ECOM")
                    self.comando('sudo cp mqtt_ecom.py /srv/datalogger_ecom/lib/mqtt.py')
                    self.comando('sudo cp config_ecom.py /srv/datalogger_ecom/config/__main__.py')
                    self.comando('sudo systemctl restart mining-config')
                    self.comando('sudo systemctl restart mining-autoupload')
                    self.comando('sudo systemctl restart mining-autoupload-gps')
                    print("[14] Datalogger ECOM Actualizados Correctamente")
                
                elif 'MMR MINING' in datalogger:
                    print("[15] Actualizando Datalogger MMR")
                    self.comando('sudo cp mqtt_mmr.py /srv/datalogger_mmr/lib/mqtt.py')
                    self.comando('sudo cp config_mmr.py /srv/datalogger_mmr/config/__main__.py')
                    self.comando('sudo cp gps_lib_mmr.py /srv/datalogger_mmr/gps/gps_lib.py')
                    self.comando('sudo cp serial_lib_mmr.py /srv/datalogger_mmr/serial/serial_lib.py')
                    self.comando('sudo cp serial_main_mmr.py /srv/datalogger_mmr/serial/__main__.py')
                    self.comando('sudo cp server_mmr.py /srv/datalogger_mmr/server/__main__.py')
                    self.comando('sudo cp autoupload_mmr.py /srv/datalogger_mmr/autoupload/__main__.py')
                    

                    ##SECCION ESPECIAL
                    import json
                    with open('/srv/datalogger_mmr/config_mmr.json','r') as file:
                        data = json.load(file)
                    valve_sensor = data["VALVE_SENSOR"]
                    if not "LEVEL_CURVE" in valve_sensor:
                        data["VALVE_SENSOR"]["LEVEL_CURVE"]=[0,0]
                        with open('/srv/datalogger_mmr/config_mmr.json','w') as file_w:
                            json.dump(data, file_w, indent=len(data))

                    self.comando('sudo systemctl restart mining-config')
                    self.comando('sudo systemctl restart mining-gps')
                    self.comando('sudo systemctl restart mining-serial')
                    self.comando('sudo systemctl restart mining-server')
                    self.comando('sudo systemctl restart mining-autoupload')
                    self.comando('sudo systemctl restart mining-autoupload-gps')
                    print("[16] Datalogger MMR Actualizados Correctamente")

                    print("[17] Actualizando Mapas")
                    self.comando('sudo cp Centinela.html /srv/datalogger_mmr/tablet/htmls/Centinela.html')
                    self.comando('sudo cp Candelaria.html /srv/datalogger_mmr/tablet/htmls/Candelaria.html')
                    self.comando('sudo cp MinistroHales.html /srv/datalogger_mmr/tablet/htmls/MinistroHales.html')
                    if faena in avalaible_faenas:
                        path_index = "/var/www/html/index.html"
                        command = f'cp {faena.replace(" ", "")}.html {path_index}'
                        self.comando(orden = command)
                        self.comando("systemctl restart apache2.service")
                    print("[18] Mapas Actualizados Correctamente")
                


                print('[19] Actualizando comando mining...')
                self.comando('sudo cp mining /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[20] Comando mining Actualizado')

            else:
                print('[3] Actualizando comando mining...')
                self.comando('sudo cp mining_tablet /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[4] Comando mining Actualizado')

            file = open("/etc/mining/version", "w")
            file.write("40\n")
            file.close()

            self.log("Actualizacion a Mining 3.1.0 Finalizada")

        except Exception as ex:
            self.log(f"Error actualizando el sistema")
            self.log(ex)

#####RUN########
entorno = Actualizar()
entorno.app()




