import subprocess
import datetime
import json
from time import sleep

class Actualizar():
    def __init__(self):
        self.log_id="ACTUALIZADOR"

    def getProductId(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","robot"]).decode()
        tcp = int(data.split(":")[2])
        return (tcp - 10000) # Mother/Jarvis product ID

    def getProductName(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","name"]).decode()
        data = data.split("'")[3].strip()
        return data
    
    # Metodo Lanza linea de comando: None
    def comando(self,orden,modo=1):
        orden_s=orden.split(' ')
        if modo==1:
            res=subprocess.check_output(orden_s)
            if res.decode()!='\n' or res.decode()!='':
                print(res.decode())
        elif modo==0:
            try:
                res=subprocess.check_output(orden_s)
                if res.decode()!='\n' or res.decode()!='':
                    print(res.decode())
            except: pass

    # Metodo entrega tipo de equipo: STRING
    def tipo(self):
        res=subprocess.check_output('machinename')
        nombre=res.decode().split('-')
        return nombre[0].lower() # return en minuscula


    # Metodo entrega el numero del equipo: INT
    # Ejemplo: ecom-500 entrega 500
    def numero(self):
        res=subprocess.check_output('machinename')
        num_equipo=res.decode().split('-')
        try:
            return int(num_equipo[1])
        except:
            return 0
    
    # Metodo entrega ID; INT
    def id(self):
        res=subprocess.check_output('machineid').decode()
        return int(res)

    # Metodo que agrega el output al log: None
    def log(self,message):
        dt = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        print("[%s] %s | %s" % (self.log_id, dt, message))
        with open ("/log.txt", "a") as myfile:
            myfile.write("[%s] %s | %s\n" % (self.log_id, dt, message))

    # Meotod reemplaza string en archivo: None
    def reemplazar(self, ruta_archivo, texto_out, texto_in):
        with open(ruta_archivo,'r') as archivo:
            contenido=archivo.read()
        contenido_2 = contenido.replace(texto_out,texto_in)

        with open(ruta_archivo, 'w') as archivo_nuevo:
            archivo_nuevo.write(contenido_2)
    
    def ver_datalogger(self, opcion= 2):
        lista=[]
        resp=subprocess.check_output(['ls','/srv/']).decode()
        if self.tipo()=='mmr' and 'pruebas-riego' in resp:
            lista.append('MMR EYE3')
        if 'datalogger_mmr' in resp:
            lista.append('MMR MINING')
        if self.tipo()=='ecom' and 'dio' in resp:
            res2 = subprocess.check_output(['ls','/srv/dio/']).decode()
            if 'gps_config.json' in res2:
                lista.append('ECOM EYE3 MASTER')
            else:
                lista.append('ECOM EYE3')
        if 'datalogger_ecom' in resp:
            lista.append('ECOM MINING')
        if self.tipo()=='gimp' and 'dio' in resp:
            lista.append('GIMP EYE3')
        if 'datalogger_gimp' in resp:
            lista.append('GIMP MINING')
        for i in resp.split('\n'):
            if i=='datalogger':
                lista.append('CABINA')
        if len(lista)==0: print('No hay dataloggers instalados')
        #if opcion==1:
        for i in range(len(lista)):
            print(str(i+1)+'. '+lista[i])
        print('')
        if opcion==1:
            return []
        elif opcion==2:
            return lista
            
    def get_faena_assigned(self):
        faena = "TallerStgo"
        try:
            f = open('/srv/live/topic.json')
            config:dict = json.load(f)
            faena = config["topic"].split("/")[0]
        except:
            print("Error obteniendo Faena")
        return faena
    
    # Metodo funcional: None
    def app(self):
        self.nombre = self.tipo()
        faena = self.get_faena_assigned()
        avalaible_faenas = ["Candelaria"]
        try:
            self.log("Actualizando a Mining 3.2.0...")

            print("[1] Actualizando comando topic")
            self.comando('cp topic /bin/topic')
            self.comando('sudo chmod 777 /bin/topic')
            print("[2] Comando topic actualizado")

            if self.nombre!='tablet':
                ## INSTALAR LIBRERIAS ##
                print("[3] Instalando Librerias Flask")
                self.comando('pip install flask', 0)
                self.comando('pip install flask_cors', 0)
                self.comando('pip install filelock', 0)
                print("[4] Librerias Instaladas")

                ## DATALOGGERS ##
                datalogger = self.ver_datalogger()
                if 'MMR MINING' in datalogger:
                    print("[5] Actualizando Datalogger MMR")
                    self.comando('sudo cp default.css /srv/datalogger_mmr/tablet/css/default.css')
                    self.comando('sudo cp default.css /var/www/html/css/default.css')
                    self.comando('sudo cp Candelaria.html /srv/datalogger_mmr/tablet/htmls/Candelaria.html')
                    self.comando('sudo cp install_tablet.sh /srv/datalogger_mmr/tablet/install.sh')
                    self.comando('sudo cp flow_lib.py /srv/datalogger_mmr/flow/flow_lib.py')
                    self.comando('sudo cp main_flow.py /srv/datalogger_mmr/flow/__main__.py')
                    self.comando('sudo cp serial_lib.py /srv/datalogger_mmr/serial/serial_lib.py')
                    self.comando('sudo cp main_serial.py /srv/datalogger_mmr/serial/__main__.py')
                    self.comando('sudo cp server.py /srv/datalogger_mmr/server/__main__.py')
                    self.comando('sudo cp tables.py /srv/datalogger_mmr/database/tables.py')
                    self.comando('sudo cp models.py /srv/datalogger_mmr/database/models.py')
                    self.comando('sudo cp main_config_mmr.py /srv/datalogger_mmr/config/__main__.py')
                    self.comando('sudo cp actualizar_mapa /srv/datalogger_mmr/commands/actualizar_mapa')


                    ## SECCION ESPECIAL UPDATE CONFIG PARA EQUIPOS ANTIGUOS Y UPDATE DATABASE ##
                    # 1. Update columns database
                    self.comando('python3 create_column.py')

                    # 2. Change max len packet to 60 and Update section tablet config
                    import json
                    with open('/srv/datalogger_mmr/config_mmr.json','r') as file:
                        data = json.load(file)
                    data["SERVER"]["MAX_LEN_PACKET_DATA"] = 60
                    if not "TABLET" in data:
                        data["TABLET"] = {
                            "MAX_CISTERN_LEVEL": 70,	# Max nivel de estanque del aljibe: default 70m3
                            "MODEL_SENSOR_LEVEL": "", #TUF - SATEL - ""
                            "SHOW_LEVEL": False,
                            "SHOW_VOLUME": False
                        }	
                    # 3. save config
                    with open('/srv/datalogger_mmr/config_mmr.json','w') as file_w:
                        json.dump(data, file_w, indent=len(data))
                    ## =========================================================================== ##

                    self.comando("sh /srv/datalogger_mmr/commands/install.sh")
                    self.comando("systemctl restart mining-config")
                    self.comando("systemctl restart mining-serial")
                    self.comando("systemctl restart mining-flow")
                    self.comando("systemctl restart mining-server")
                    self.comando("systemctl restart mining-autoupload")

                    # 4. Actualizar Mapas
                    if faena in avalaible_faenas:
                        path_index = "/var/www/html/index.html"
                        command = f'cp {faena.replace(" ", "")}.html {path_index}'
                        self.comando(orden = command)
                    self.comando("systemctl restart apache2.service")
                    print("[6] Datalogger MMR Actualizado")
                
                elif 'ECOM MINING' in datalogger:
                    print("[7] Actualizando Config Datalogger ECOM")
                    self.comando('sudo cp main_config_ecom.py /srv/datalogger_ecom/config/__main__.py')
                    self.comando("systemctl restart mining-config")
                    print("[8] Config Datalogger ECOM Actualizado")
                    
                
                print('[9] Actualizando comando mining...')
                self.comando('sudo cp mining /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[10] Comando mining Actualizado')

            else:
                print('[3] Actualizando comando mining...')
                self.comando('sudo cp mining_tablet /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[4] Comando mining Actualizado')

            file = open("/etc/mining/version", "w")
            file.write("43\n")
            file.close()

            self.log("Actualizacion a Mining 3.2.0 Finalizada")

        except Exception as ex:
            self.log(f"Error actualizando el sistema")
            self.log(ex)

#####RUN########
entorno = Actualizar()
entorno.app()




