import requests
import json
import time
from keys import API_TOKEN # Recordar añadir keys.py en la actualización ecom

token = API_TOKEN
# =========== FAENAS ============ #
def get_faenas_data(token):
    base_url = 'http://core.mine-360.com:1337/api/faena-ubicacions?fields=FaenaUbicacion&populate[faena][fields][1]=Faena&pagination[limit]=1000&'

    headers = {
        'accept': 'application/json',
        'Authorization': f'Bearer {token}',
        'Content-Type': 'application/json'
    }

    source_config = "/srv/datalogger_ecom/web-server/FAENAS_DATA.json"
    FAENAS_DATA = {}

    response = requests.get(base_url, headers=headers)

    if response.status_code == 200:
        data = response.json()
        
        for x in data["data"]:
            faena = x["attributes"]["faena"]["data"]["attributes"]["Faena"]
            faena_ubicacion = x["attributes"]["FaenaUbicacion"]
            faena_ubicacion_id = x["id"]  
            
            if faena_ubicacion.startswith(("CAEX", "PER")):
                if faena not in FAENAS_DATA:
                    FAENAS_DATA[faena] = []
                FAENAS_DATA[faena].append({
                    "id": faena_ubicacion_id,
                    "faenaubicacion": faena_ubicacion
                })

    with open(source_config, "w") as f:
        json.dump(FAENAS_DATA, f, indent=4)

    return FAENAS_DATA


# =========== CABINA ============ #
def get_cabinas_data(token):
    base_url = 'http://core.mine-360.com:1337/api/sensores?&fields[0]=MachineName&populate[faena_ubicacion][fields][1]=FaenaUbicacion&populate[sensor_estado]=Estado&pagination[limit]=1000'

    headers = {
                'accept': 'application/json',
                'Authorization': f'Bearer {token}',
                'Content-Type': 'application/json'
            }

    source_config = "/srv/datalogger_ecom/web-server/CABINAS_DATA.json"
    CABINA_DATA = {}

    response = requests.get(base_url, headers=headers)
    if response.status_code == 200:
        data = response.json()
        #print(data["data"][0])
        for x in data["data"]:
            #print(x)
            sub_data = x["attributes"]["faena_ubicacion"]["data"]
            state_data = x["attributes"]["sensor_estado"]["data"]
            #print(sub_data)
            if "cab" in x["attributes"]["MachineName"]:
                if sub_data == None:
                    faena_ubicacion = "unknown"
                    #print("None")
                else:
                    faena_ubicacion = sub_data["attributes"]["FaenaUbicacion"]
                if state_data == None:
                    estado = "unknown"
                else:
                    estado = state_data["attributes"]["Estado"]
                    
                CABINA_DATA[x["attributes"]["MachineName"]] = {"id": x["id"], "faena": faena_ubicacion, "state": estado}
                #print(CABINA_DATA[x["attributes"]["MachineName"]])

    with open(source_config, "w") as f:
        json.dump(CABINA_DATA, f, indent=1)

# =========== EVOS ============ #
def get_evos_data(token):
    base_url = 'http://core.mine-360.com:1337/api/sensores?fields[0]=MachineName&populate[faena_ubicacion][fields][0]=FaenaUbicacion&populate[sensor_estado]=Estado&pagination[limit]=1000'

    headers = {
                'accept': 'application/json',
                'Authorization': f'Bearer {token}',
                'Content-Type': 'application/json'
            }

    source_config = "/srv/datalogger_ecom/web-server/EVOS_DATA.json" 
    EVOS_DATA = {}

    response = requests.get(base_url, headers=headers)

    if response.status_code == 200:
        data = response.json()
        for x in data["data"]:
            sub_data = x["attributes"]["faena_ubicacion"]["data"]
            state_data = x["attributes"]["sensor_estado"]["data"]
            #print(sub_data)
            if "evo" in x["attributes"]["MachineName"].lower():
                #print(sub_data)
                if sub_data == None:
                    faena_ubicacion = "unknown"
                    #print("None")
                else:
                    faena_ubicacion = sub_data["attributes"]["FaenaUbicacion"]
                if state_data == None:
                    estado = "unknown"
                else:
                    estado = state_data["attributes"]["Estado"]
                    
                EVOS_DATA[x["attributes"]["MachineName"]] = {"id": x["id"], "faena": faena_ubicacion, "state": estado}
                #print(EVOS_DATA[x["attributes"]["MachineName"]])
                    
    with open(source_config, "w") as f:
        json.dump(EVOS_DATA, f, indent=1)
        
    
# =========== USERS ============ #
def get_users_data(token):
    base_url = 'http://core.mine-360.com:1337/api/users?&pagination[limit]=1000'

    headers = {
                'accept': 'application/json',
                'Authorization': f'Bearer {token}',
                'Content-Type': 'application/json'
            }

    source_config = "/srv/datalogger_ecom/web-server/USERS_DATA.json"
    USERS_DATA = {}

    response = requests.get(base_url, headers=headers)

    if response.status_code == 200:
        data = response.json()  
        for x in data:  
            username = x.get("username", "unknown")
            #print(username)
            nombre_completo = x.get("NombreCompleto", "unknown")
            #print(nombre_completo)
            USERS_DATA[username] = {"id": x.get("id"),"nombre_completo": nombre_completo}
            
    with open(source_config, "w") as f:
        json.dump(USERS_DATA, f, indent=1)
        
# =========== FAENA UBICACION DATA ============ #
        
def get_loc_data(token):
    base_url = 'http://core.mine-360.com:1337/api/faena-ubicacions?fields[0]=FaenaUbicacion&populate[faena][fields][0]=Faena&populate[dataloggers][fields][0]=MachineName&populate[sensores][fields][0]=MachineName&pagination[limit]=1000'

    headers = {
        'accept': 'application/json',
        'Authorization': f'Bearer {token}',
        'Content-Type': 'application/json'
    }

    source_config = "/srv/datalogger_ecom/web-server/LOC_DATA.json"
    LOC_DATA = {}

    response = requests.get(base_url, headers=headers)

    if response.status_code == 200:
        data = response.json()

        for item in data.get("data", []):
            attrs = item.get("attributes", {})

            faena = None
            faena_data = attrs.get("faena", {}).get("data")
            if faena_data:
                faena = faena_data.get("attributes", {}).get("Faena")

            LOC_DATA[item["id"]] = {
                "id": item["id"],
                "Faena": faena, 
                "FaenaUbicacion": attrs.get("FaenaUbicacion"),
                "dataloggers": [
                    dl["attributes"]["MachineName"]
                    for dl in attrs.get("dataloggers", {}).get("data", [])
                ],
                "sensores": [
                    s["attributes"]["MachineName"]
                    for s in attrs.get("sensores", {}).get("data", [])
                ]
            }

    with open(source_config, "w") as f:
        json.dump(LOC_DATA, f, indent=2)

# ============= DATALOGGERS ================= #
def get_datalogger_data(token):
    base_url = 'http://core.mine-360.com:1337/api/dataloggers?fields[0]=MachineName&pagination[limit]=1000&'
    
    headers = {
                'accept': 'application/json',
                'Authorization': f'Bearer {token}',
                'Content-Type': 'application/json'
            }
    source_config = "/srv/datalogger_ecom/web-server/DATALOGGER_DATA.json"
    DATALOGGER_DATA = {}
    
    response = requests.get(base_url, headers=headers)
    
    if response.status_code == 200:
        data = response.json()

        for item in data.get("data", []):
            machine_name = item["attributes"]["MachineName"]
            datalogger_id = item["id"]

            DATALOGGER_DATA[machine_name] = datalogger_id

    with open(source_config, "w", encoding="utf-8") as f:
        json.dump(DATALOGGER_DATA, f, indent=4, ensure_ascii=False)

while True:
    print("Updating data...")
    get_faenas_data(token)
    get_cabinas_data(token)
    get_evos_data(token)
    get_users_data(token)
    get_loc_data(token)
    get_datalogger_data(token)
    print("Data updated. Waiting 10 minutes for next update...")
    time.sleep(600)  