import subprocess
import datetime
import json
from time import sleep

class Actualizar():
    def __init__(self):
        self.log_id="ACTUALIZADOR"

    def getProductId(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","robot"]).decode()
        tcp = int(data.split(":")[2])
        return (tcp - 10000) # Mother/Jarvis product ID

    def getProductName(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","name"]).decode()
        data = data.split("'")[3].strip()
        return data
    
    # Metodo Lanza linea de comando: None
    def comando(self,orden,modo=1):
        orden_s=orden.split(' ')
        if modo==1:
            res=subprocess.check_output(orden_s)
            if res.decode()!='\n' or res.decode()!='':
                print(res.decode())
        elif modo==0:
            try:
                res=subprocess.check_output(orden_s)
                if res.decode()!='\n' or res.decode()!='':
                    print(res.decode())
            except: pass

    # Metodo entrega tipo de equipo: STRING
    def tipo(self):
        res=subprocess.check_output('machinename')
        nombre=res.decode().split('-')
        return nombre[0].lower() # return en minuscula


    # Metodo entrega el numero del equipo: INT
    # Ejemplo: ecom-500 entrega 500
    def numero(self):
        res=subprocess.check_output('machinename')
        num_equipo=res.decode().split('-')
        try:
            return int(num_equipo[1])
        except:
            return 0
    
    # Metodo entrega ID; INT
    def id(self):
        res=subprocess.check_output('machineid').decode()
        return int(res)

    # Metodo que agrega el output al log: None
    def log(self,message):
        dt = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        print("[%s] %s | %s" % (self.log_id, dt, message))
        with open ("/log.txt", "a") as myfile:
            myfile.write("[%s] %s | %s\n" % (self.log_id, dt, message))

    # Meotod reemplaza string en archivo: None
    def reemplazar(self, ruta_archivo, texto_out, texto_in):
        with open(ruta_archivo,'r') as archivo:
            contenido=archivo.read()
        contenido_2 = contenido.replace(texto_out,texto_in)

        with open(ruta_archivo, 'w') as archivo_nuevo:
            archivo_nuevo.write(contenido_2)
    
    def ver_datalogger(self, opcion= 2):
        lista=[]
        resp=subprocess.check_output(['ls','/srv/']).decode()
        if self.tipo()=='mmr' and 'pruebas-riego' in resp:
            lista.append('MMR EYE3')
        if 'datalogger_mmr' in resp:
            lista.append('MMR MINING')
        if self.tipo()=='ecom' and 'dio' in resp:
            res2 = subprocess.check_output(['ls','/srv/dio/']).decode()
            if 'gps_config.json' in res2:
                lista.append('ECOM EYE3 MASTER')
            else:
                lista.append('ECOM EYE3')
        if 'datalogger_ecom' in resp:
            lista.append('ECOM MINING')
        if self.tipo()=='gimp' and 'dio' in resp:
            lista.append('GIMP EYE3')
        if 'datalogger_gimp' in resp:
            lista.append('GIMP MINING')
        for i in resp.split('\n'):
            if i=='datalogger':
                lista.append('CABINA')
        if len(lista)==0: print('No hay dataloggers instalados')
        #if opcion==1:
        for i in range(len(lista)):
            print(str(i+1)+'. '+lista[i])
        print('')
        if opcion==1:
            return []
        elif opcion==2:
            return lista
            
    def get_faena_assigned(self):
        faena = "TallerStgo"
        try:
            f = open('/srv/live/topic.json')
            config:dict = json.load(f)
            faena = config["topic"].split("/")[0]
        except:
            print("Error obteniendo Faena")
        return faena
    
    # Metodo funcional: None
    def app(self):
        self.nombre = self.tipo()
        try:
            self.faena = self.get_faena_assigned()
            self.log("Actualizando a Mining 3.4.15...")
            if self.nombre!='tablet':
                ###PARA MMR
                if self.nombre=='mmr':
                    print('[1] Actualizando server_html...')
                    self.comando('systemctl stop mining-server-html.service')
                    self.comando('sudo cp main_server_html.py /srv/datalogger_mmr/server_html/__main__.py')
                    self.comando('sudo cp index.html /srv/datalogger_mmr/server_html/templates/')
                    self.comando('sudo cp map.js /srv/datalogger_mmr/server_html/static/js/')
                    self.comando('sudo cp cards.js /srv/datalogger_mmr/server_html/static/js/')
                    self.comando('sudo cp logo.svg /srv/datalogger_mmr/server_html/static/img/')
                    self.comando('systemctl start mining-server-html.service')
                    print('[2] server_html Actualizado')
                    
                    print('[3] Actualizando config...')
                    self.comando('systemctl stop mining-config.service')
                    self.comando('systemctl stop mining-server.service')
                    self.comando('sudo cp main_config_mmr.py /srv/datalogger_mmr/config/__main__.py')
                    self.comando('systemctl start mining-config.service')
                    self.comando('systemctl start mining-server.service')
                    print('[4] Config Actualizado')
                    
                    print('[5] Actualizando comando actualizar_mapa...')
                    self.comando('sudo cp actualizar_mapa /srv/datalogger_mmr/commands/')
                    self.comando('sudo cp actualizar_mapa /bin/actualizar_mapa')
                    self.comando('sudo chmod 777 /bin/actualizar_mapa')
                    print('[6] Comando actualizar_mapa Actualizado')

                    print('[7] Actualizando comando mining...')
                    self.comando('sudo cp mining /bin/mining')
                    self.comando('sudo chmod 777 /bin/mining')
                    print('[8] Comando mining Actualizado')
                    
                ##PARA ECOM
                if self.nombre=='ecom':                        
                        print('[1] Actualizando config...')
                        self.comando('systemctl stop mining-config.service')
                        self.comando('systemctl stop mining-server.service')
                        self.comando('sudo cp main_config_ecom.py /srv/datalogger_ecom/config/__main__.py')
                        self.comando('systemctl start mining-config.service')
                        self.comando('systemctl start mining-server.service')
                        print('[2] Config Actualizado')

                        print('[3] Actualizando comando mining...')
                        self.comando('sudo cp mining /bin/mining')
                        self.comando('sudo chmod 777 /bin/mining')
                        print('[4] Comando mining Actualizado')

                else:
                    print('[1] Actualizando comando mining...')
                    self.comando('sudo cp mining /bin/mining')
                    self.comando('sudo chmod 777 /bin/mining')
                    print('[2] Comando mining Actualizado')

            else:
                print('[1] Actualizando comando mining...')
                self.comando('sudo cp mining_tablet /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[2] Comando mining Actualizado')

            file = open("/etc/mining/version", "w")
            file.write("62\n")
            file.close()

            self.log("Actualizacion a Mining 3.4.15 Finalizada")

        except Exception as ex:
            self.log(f"Error actualizando el sistema")
            self.log(ex)

#####RUN########
entorno = Actualizar()
entorno.app()




