from flask import Flask, jsonify
import json

FILES = {
    "config_mmr": "/srv/datalogger_mmr/config_mmr.json",
    "nivel": "/var/www/html/nivel.json",
    "data": "/var/www/html/data.json",
    "estado_boton": "/var/www/html/estado_boton.json",
    "volumen_acumulado": "/var/www/html/volumen_acumulado.json"
}

app = Flask(__name__)

def read_json(path):
    try:
        with open(path) as f:
            return json.load(f)
    except Exception:
        return {}

@app.route("/config")
def config():
    data = {}
    for k, f in FILES.items():
        data[k] = read_json(f)
    return jsonify(data)

app.run(host="0.0.0.0", port=5001, threaded=True)
