import requests
import json 
import time 
from keys import GEO_TOKEN

token = GEO_TOKEN

def get_location_assigned():
    caex = "STGO"
    try:
        f = open('/srv/live/topic.json')
        config:dict = json.load(f)
        caex = config["topic"].split("/")[2]
    except:
        print(f"[ERROR] Fallo al obtener la faena ubicación asignada")
    return caex

def get_faena_assigned():
    faena = "TallerStgo"
    try:
        f = open('/srv/live/topic.json')
        config:dict = json.load(f)
        faena = config["topic"].split("/")[0]
    except:
        print(f"[ERROR] Fallo al obtener la faena asignada")
    return faena

def get_geofence(faena):
    if faena == "TallerStgo":
        return
    base_url = f"https://{faena.lower()}.mapa.mine-360.com/api/geofence"

    headers = {
            'accept': 'application/json',
            'X-Device-Key': token,
            'Content-Type': 'application/json'
        }

    source_config = "/srv/datalogger_tablet/geofence.json"
    GEOFENCE_DATA = {}

    response = requests.get(base_url, headers=headers)

    if response.status_code == 200:
        data = response.json()
        GEOFENCE_DATA = data
        
        
    with open(source_config, "w") as f:
        json.dump(GEOFENCE_DATA, f)

def json_faena():
    faena = get_faena_assigned()
    ubicacion = get_location_assigned()

    source_config = "/srv/datalogger_tablet/data_faena.json"
    dict_data = {
        "faena": faena,
        "ubicacion": ubicacion
    }

    with open(source_config, "w") as f:
        json.dump(dict_data, f)

while True: 
    faena = get_faena_assigned()
    get_geofence(faena)
    json_faena()
    print(f"[INFO] Geofence y faena actualizada para {faena}")
    time.sleep(3600*24) 
