import os
import json
import requests
import time
import subprocess
from keys import API_TOKEN

URLS = [
    "http://raspberrypi.local:5001/config",
    "http://raspberrypi:5001/config"
]

token = API_TOKEN

path = "/srv/datalogger_tablet/"

faena = json.load(open('/srv/datalogger_tablet/data_faena.json')).get("faena")

ubicacion = json.load(open('/srv/datalogger_tablet/data_faena.json')).get("ubicacion")

if ubicacion.startswith("REG"):
    ubicacion_num = ubicacion[4:]
else: 
    ubicacion_num = "XXX"

config_dict = {
    "API_TOKEN": '8b52dd9bd5f0ae78c502a2b5f332b25d7449af29500f619689ed82cb016f14be',
    "TABLET": {
        "MAX_CISTERN_LEVEL": 0,
        "MODEL_SENSOR_LEVEL": "",
        "SHOW_LEVEL": True,
        "SHOW_VOLUME": True,
        "API_URL_REG": f"https://{faena.lower()}.mapa.mine-360.com/api/vehicles/reg",
        "API_PM100_FILTRADO": f"https://{faena.lower()}.mapa.mine-360.com/api/tablets/pm100_filtrado",
        "API_RIEGO": f"https://{faena.lower()}.mapa.mine-360.com/api/riego",
        "GEOFENCE_PATH": "/srv/datalogger_tablet/geofence.json",  
        "TITLE": faena,
        "X_COORD": 0,
        "Y_COORD": 0
    }
}

nivel_dict = {}

volumen_dict = {}

def write_json(path, data):
    tmp = path + ".tmp"
    with open(tmp, "w") as f:
        json.dump(data, f, indent=4)
    os.replace(tmp, path)

def get_data():
    for url in URLS:
        try:
            r = requests.get(url, timeout=1)
            r.raise_for_status()
            print(f"[INFO] Conectado a {url}")
            return r.json()
        except Exception as e:
            print(f"[WARN] No se pudo conectar a {url}: {e}")
    raise ConnectionError("No se pudo conectar a ninguna Raspberry")

while True:
    try:
        data = get_data()

        if "config_mmr" in data and "TABLET" in data["config_mmr"]:
            tablet_config = data["config_mmr"]["TABLET"]
            if "GEOFENCE_PATH" in tablet_config:
                 data["config_mmr"]["TABLET"]["GEOFENCE_PATH"] = "/srv/datalogger_tablet/geofence.json"

        for name, content in data.items():
            file_path = os.path.join(path, f"{name}.json")
            write_json(file_path, content)
            print(f"[INFO] Actualizado {file_path}")

    except Exception as e:
        print(f"[ERROR] {e}")
        url = config_dict["TABLET"]["API_URL_REG"]
        
        headers = {
            'accept': 'application/json',
            'Authorization': f'Bearer {token}',
            'Content-Type': 'application/json'
        }
        
        response = requests.get(url, headers=headers)
        
        if response.status_code == 200:
            data = response.json()
            latitud = None
            longitud = None

            for item in data:
                if item["vehiculo"] == ubicacion:
                    latitud = item["latitude"]
                    longitud = item["longitude"]
                    
        data_dict = {
            "name": ubicacion_num,
            "vehicle": subprocess.check_output(["machineid"]).decode("utf-8").replace("\n", ""),
            "lat": latitud, 
            "lon": longitud
        }
        file_path = os.path.join(path, "config_mmr.json")
        write_json(file_path, config_dict)
        data_path = os.path.join(path, "data.json")
        write_json(data_path, data_dict)
        nivel_path = os.path.join(path, "nivel.json")
        write_json(nivel_path, nivel_dict)
        volumen_path = os.path.join(path, "volumen_acumulado.json")
        write_json(volumen_path, volumen_dict)
        print(f"[INFO] Restaurados archivos de configuración predeterminados en {file_path}, {data_path}, {nivel_path} y {volumen_path}")

    time.sleep(1)
