import RPi.GPIO as GPIO
from time import sleep
import datetime
import subprocess
import os
import serial

print("Delay de inicio de 15 segundos")
sleep(15)
# GPIO INIT 
GPIO.setwarnings(False)			#disable warnings
GPIO.setmode(GPIO.BOARD)		#set pin numbering system
GPIO.cleanup()


### SECCION PANTALLA 11 PULGADAS
# BUTTONS
control_button_down = 38
control_button_up = 37
control_button_backlight = 40
timer = serial.serialutil.Timeout(0.01)
current_backlight_state =0

# GPIO SETUPS
GPIO.setup(control_button_down,GPIO.IN)
GPIO.setup(control_button_up,GPIO.IN)
GPIO.setup(control_button_backlight,GPIO.IN)

### SECCION DE SETEO PIN PWM
ledpin = 35				# PWM pin connected to LED
GPIO.setup(ledpin,GPIO.OUT)
pi_pwm = GPIO.PWM(ledpin,10000)		#create PWM instance with frequency
pi_pwm.start(100)				#start PWM of required Duty Cycle 

### Seteo BOTON ABAJO
pin_boton_bajar=36
GPIO.setup(pin_boton_bajar, GPIO.IN, pull_up_down=GPIO.PUD_UP)

### Seteo BOTON ARRIBA
pin_boton_subir=32
GPIO.setup(pin_boton_subir, GPIO.IN, pull_up_down=GPIO.PUD_UP)

### VARIABLE DE ESTADO MANUAL/AUTOMATICO
modo_actual='AUTOMATICO'
valor_boton=1 #Comenzamos en 0 y varia en uno hasta llegar a 4
direccion='up'
modo_error=0





#DETECTAR ARDUINO
def detectar_ino():
	ino=['1a86','7523']
	lista_usb=subprocess.check_output('ls /sys/bus/usb-serial/devices', shell=True).decode('utf-8').split('\n')[:-1]
	for usb in lista_usb:
		if os.system('grep PRODUCT=  /sys/bus/usb-serial/devices/' + usb + '/../uevent > /dev/null 2>&1')==0:
			product=subprocess.check_output('grep PRODUCT=  /sys/bus/usb-serial/devices/' + usb + '/../uevent', shell=True).decode('utf-8')[:-1]
			idVendor,idProduct=product.split('=')[1].split('/')[0],product.split('=')[1].split('/')[1]
			if ino[0]==idVendor and ino[1]==idProduct:
				return usb
	print('Error encontrando INO')
	

#DETECTAR TIPO DE PANTALLA
def detectar_pantalla():
	lista_touch={'Pantalla2':['1a86','e5e3'],'Pantalla1':['0eef','0005'], 'Pantalla3':['0484','5750']}
	lista_usb=subprocess.check_output('ls /sys/bus/usb/devices', shell=True).decode('utf-8').split('\n')[:-1]
	for usb in lista_usb:
		if os.system('cat /sys/bus/usb/devices/' + usb + '/idVendor > /dev/null 2>&1')==0:
			idVendor=subprocess.check_output('cat /sys/bus/usb/devices/' + usb + '/idVendor', shell=True).decode('utf-8')[:-1]
			idProduct=subprocess.check_output('cat /sys/bus/usb/devices/' + usb + '/idProduct', shell=True).decode('utf-8')[:-1]
			for touch in lista_touch:
				if lista_touch[touch][0]==idVendor and lista_touch[touch][1]==idProduct:
					return touch

#ENVIAR DATO POR SERIAL
def enviar_serial(mensaje, port):
	port.write(str(mensaje).encode())
	sleep(1)

#CON PWM
def seteo_pantalla1(modo, estado_actual, pi_pwm, estado_manual):
	estados = {'diurno':0, 'nocturno':100}
	estados_manual=[100,80,70,50,40,20,0]
	if modo=='AUTOMATICO':
		pi_pwm.ChangeDutyCycle(estados[estado_actual])
	elif modo=='MANUAL':
		pi_pwm.ChangeDutyCycle(estados_manual[estado_manual])

#VERSION PWM
def seteo_pantalla2(modo, estado_actual, pi_pwm, estado_manual, port):
	estados = {'diurno':200, 'nocturno':8}
	estados_manual=[1,8,40,80,150,200,255]
	if modo=='AUTOMATICO':
		enviar_serial(str(estados[estado_actual]), port)
	elif modo=='MANUAL':
		enviar_serial(str(estados_manual[estado_manual]), port)
		
#VERSION 11 PULGADAS
def seteo_pantalla3(modo, estado_automatico, estado_manual):
	global valor_boton
	# Los valores diurno y nocturno debe er si o si un valor que este en la lista de estados manual
	estados_automaticos = {'diurno':100, 'nocturno':10} 
	estados_manual = [5, 10, 15, 35, 60, 80, 100]
	if modo=='AUTOMATICO':
		set_brigthness_display_H(new_state= estados_automaticos[estado_automatico])
		valor_boton = estados_manual.index(estados_automaticos[estado_automatico])
	elif modo=='MANUAL':
		set_brigthness_display_H(new_state= estados_manual[estado_manual])

def set_brigthness_display_H(new_state=None, edge_state = None):
	global current_backlight_state
	if new_state == current_backlight_state:
		print("Brillo ya esta configurado en el valor solicitado")
		return
	
	# CHANGE VOLUME TO BACKLIGHT
	flag =0
	if timer.expired():
		print("Cambiando modo de volume a backlight")
#		timer.restart(6)
		GPIO.setup(control_button_backlight,GPIO.IN)
		GPIO.setup(control_button_backlight,GPIO.OUT)
		GPIO.output(control_button_backlight, 0)
		sleep(0.5)
		GPIO.output(control_button_backlight, 1)
		GPIO.setup(control_button_backlight, GPIO.IN) # Dejar pin en flotante
		#timer.restart(6)
		flag=1

	if edge_state:
		print(f"cambiando brillo al limite segun pin {edge_state}")
		GPIO.setup(edge_state,GPIO.OUT)
		GPIO.output(edge_state, 0)
		sleep(7) # wait for 7 seconds
		GPIO.setup(edge_state, GPIO.IN) # Dejar pin en flotante		
		timer.restart(5)


	if new_state:
		print(f"cambiando brillo al {new_state}%")
		pin_signal = control_button_down if current_backlight_state>new_state else control_button_up
		GPIO.setup(pin_signal,GPIO.OUT)
		range_brillo = abs(current_backlight_state-new_state)+flag
		current_backlight_state = new_state
		print(f"range brillo {range_brillo}")
		for i in range(range_brillo):
			GPIO.output(pin_signal, 0)
			sleep(0.1)
			GPIO.output(pin_signal, 1)
			sleep(0.1)
		GPIO.setup(pin_signal,GPIO.IN)
		timer.restart(5)
	sleep(0.5)

#DETECCIOND DE HORARIO, cambiar horas en caso de cambio de horario, actuales valores 10 y 19 horas
def detectar_horario():
	x= datetime.datetime.now()
	hour=x.hour
	if 10<=hour<19:
		estado_actual = 'diurno'
	else:
		estado_actual = 'nocturno'
	return estado_actual

def cambio_de_estado(modo, pi_pwm, estado_manual, port, pantalla):
	estado_actual=detectar_horario()
	#pantalla=detectar_pantalla()
	if pantalla=='Pantalla1':
		seteo_pantalla1(modo, estado_actual, pi_pwm, estado_manual)
	if pantalla=='Pantalla2':
		seteo_pantalla2(modo, estado_actual, pi_pwm, estado_manual, port)
	if pantalla=='Pantalla3':
		seteo_pantalla3(modo, estado_actual, estado_manual)

def cambio_valor(anterior, direccion):
	if direccion == 'up':
		if anterior==6:
			return 6
		else:
			return anterior+1
	else:
		if anterior == 0:
			return 0
		else:
			return anterior-1
		
try:
	#INICIAR INO
	usb=detectar_ino()
	port=serial.Serial('/dev/'+usb, baudrate=9600)
	sleep(10)
except:
	print('No hay arduino presente')
	port=''

#CONDICION INICIAL
# Estado inicial pantalla 11 pulgadas
pantalla = detectar_pantalla()
print(f"Version pantalla detectada {pantalla}")
if pantalla == "Pantalla3": valor_boton=6
set_brigthness_display_H(edge_state=control_button_up) #SET BRIGHTNESS TO 100%, ONLY DISPLAY 11 PULGADAS
current_backlight_state = 100

cambio_de_estado(modo_actual, pi_pwm, valor_boton, port, pantalla)

#SETEO TIEMPO INICIAL
tiempo_anterior = datetime.datetime.now()
delta=datetime.timedelta(seconds=150)


while True:
	hora_actual= datetime.datetime.now()

	#CAMBIO POR BOTON PONER ACA
	if GPIO.input(pin_boton_bajar)==0:
		modo_actual='MANUAL'
		direccion='down'
		valor_boton=cambio_valor(valor_boton, direccion)
		cambio_de_estado(modo_actual, pi_pwm, valor_boton, port, pantalla)
		#sleep(1)
		tiempo_anterior=hora_actual

	if GPIO.input(pin_boton_subir)==0:
		modo_actual='MANUAL'
		direccion='up'
		valor_boton=cambio_valor(valor_boton, direccion)
		cambio_de_estado(modo_actual, pi_pwm, valor_boton, port, pantalla)
		#sleep(1)
		tiempo_anterior=hora_actual

	if (hora_actual-tiempo_anterior)>=delta:
		cambio_de_estado(modo_actual, pi_pwm, valor_boton, port, pantalla)
		tiempo_anterior=hora_actual
	
	sleep(0.1)