import subprocess
import socket
import time
import urllib.request
import os

import json

## AUTOSTART RUN IN /etc/xdg/openbox/autostart
# xset s off
# xset s noblank
# xset -dpms
# python /srv/datalogger_tablet/display

# Identificacion del equipo
ID = subprocess.check_output(['machineid'])[:-1].decode('utf-8')
NAME = subprocess.check_output(['machinename'])[:-1].decode('utf-8')
print(ID)
print(NAME)
 
# Data to be written
dictionary ={
    "status":""
}

def get_faena_assigned():
    faena = "TallerStgo"
    try:
        f = open('/srv/live/topic.json')
        config:dict = json.load(f)
        faena = config["topic"].split("/")[0]
    except:
        print(f"[ERROR] Fallo al obtener la faena asignada")
    return faena

def addJson(data):
    dictionary['status'] = data
    
    # Serializing json
    json_object = json.dumps(dictionary, indent=4)
 
    # Writing to sample.json
    with open("/srv/datalogger_tablet/display/data.json", "w") as outfile:
        outfile.write(json_object)
    time.sleep(2)


def cleanCache():
    try:
        process = subprocess.Popen(['rm','-rf','/home/pi/.cache/chromium/Default'])
        process = subprocess.Popen(['rm','-rf','/home/pi/.config/chromium/Default/Login\ Data'])
        process = subprocess.Popen(['rm','-rf','/home/pi/.config/chromium//Default/Cookies'])
        process = subprocess.Popen(['rm','-rf','/home/pi/.config/chromium//Default/History'])
        process = subprocess.Popen(['rm','-rf','/home/pi/.config/chromium//Default/Web\ Data'])

        print("Cache borrado")
    except:
        print("Error al eliminar el cache")

def getMyIp():
    try:
        s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        s.connect(("8.8.8.8", 80))
        mi_ip = s.getsockname()[0]
        #print("mi ip es: " + str(mi_ip) )
        s.close()
        #ip_s=[]
        return mi_ip

    except:
        print("error")

def initLogo(file, delay):
    if get_faena_assigned() == "Antucoya":
        process = subprocess.Popen(['flatpak', 'run','org.mozilla.firefox', '--kiosk',file], stderr=subprocess.DEVNULL)
    else:
        process = subprocess.Popen(['chromium-browser','--no-sandbox','--disable-infobars','--kiosk',file],stderr=subprocess.DEVNULL)
    #process = subprocess.Popen(['chromium-browser','main.html'])
    print("sleep {} segundos".format(delay))
    time.sleep(delay)

def initLogoServer(file, delay):
    process = subprocess.Popen(['/usr/bin/python','/srv/datalogger_tablet/display/server.py'])
    print('hola222222')
    file = "http://127.0.0.1:8000/srv/datalogger_tablet/display/index.html"
    time.sleep(10)
    if get_faena_assigned() == "Antucoya":
        process = subprocess.Popen(['flatpak', 'run','org.mozilla.firefox', '--kiosk',file], stderr=subprocess.DEVNULL)
    else:
        process = subprocess.Popen(['chromium-browser','--no-sandbox','--disable-infobars','--kiosk',file],stderr=subprocess.DEVNULL)
    #process = subprocess.Popen(['chromium-browser','main.html'])
    print("sleep {} segundos".format(delay))
    time.sleep(delay)


def statusNet(host='http://google.com'):
    try:
        urllib.request.urlopen(host) #Python 3.x
        return True
    except:
        return False

def inicializador_server(name, id, delay=10):
    try:
        cleanCache()
        initLogoServer('main.html', 10)
        addJson(name +" ID: " + id )
        time.sleep(5)
        return
    except:
        print('No se puede cargar el server')
        inicializador_server(name,id)


if __name__ == "__main__":
    
    inicializador_server(NAME,ID)
    
    lastStatus = 0
    primero=0
    while True:
   
        status = statusNet()
        if status:
            miIp = getMyIp()
            if primero==0:
                print("Mi ip es: " + str(miIp))
                addJson("Equipo conectado")
                primero=1
                time.sleep(2)
            addJson("Mi IP: "+ str(miIp))
            time.sleep(2)
            if get_faena_assigned() == "Antucoya":
                process = subprocess.Popen(['flatpak', 'run','org.mozilla.firefox', '--kiosk', 'http://127.0.0.1:5000/'], stderr=subprocess.DEVNULL)
                #process = subprocess.Popen(['flatpak', 'run','org.mozilla.firefox', '--kiosk', 'http://raspberrypi:5000/'], stderr=subprocess.DEVNULL)
            else:
                process = subprocess.Popen(['chromium-browser','--disable-infobars','--kiosk', 'http://127.0.0.1:5000/'], stderr=subprocess.DEVNULL)
            lastStatus =1
            break


        else:
            addJson(NAME +" ID: " + ID )
            primero=0
            print("no internet!" )
    
    while True:
        checkNet =statusNet()

        if  not checkNet:
            print("no internet!" )
            lastStatus=0

        elif checkNet and lastStatus==0:
            print("Haremos un refresh de la pagina")
            #xdotool key "ctrl+F5" &
            process = subprocess.Popen(['xdotool', 'key', 'ctrl+F5'])
            lastStatus = 1

        else:
            print("Todo esta ok!!!")

        print("sleep 60 segundos")
        time.sleep(60)


