import http.server
import socketserver
import os

PORT = 8000
WEB_ROOT = "/"

class ReusableTCPServer(socketserver.TCPServer):
    allow_reuse_address = True

Handler = http.server.SimpleHTTPRequestHandler

os.chdir(WEB_ROOT)

with ReusableTCPServer(("0.0.0.0", PORT), Handler) as httpd:
    print(f"Serving {WEB_ROOT} on port {PORT}")
    httpd.serve_forever()
