import os
import subprocess
from PIL import Image
import time
import json
import threading

class Pantalla():
    def __init__(self):
        self.FAENA = "TALLER"
        self.REG = "REG-XXX"
        

        self.hilo_topic = threading.Thread(target=self.topic)
        self.hilo_topic.start()

        self.hilo_app = threading.Thread(target=self.app)
        self.hilo_app.start()


    def topic(self):
        while True:
            try:
                out_topic_b = subprocess.check_output(['topic'])
                out_topic = out_topic_b.decode()
                self.dict_topic = json.loads(out_topic)
                self.FAENA = self.dict_topic['topic'].split('/')[0]
                self.REG = self.dict_topic['topic'].split('/')[2]
                time.sleep(300)
            except:
                print("Error al decodificar la faena")
                time.sleep(300)


    def app(self):
        time.sleep(10)
        while True:
            try:
                # Ruta del archivo de captura de pantalla (PNG)
                png_file_path = f'/srv/datalogger_tablet/screenshot/{self.REG}.png'
                # Ruta del archivo de captura de pantalla (JPG)
                jpg_file_path = f'/srv/datalogger_tablet/screenshot/{self.REG}.jpg'

                #Delete old images
                command_del = f'sudo rm -r /srv/datalogger_tablet/screenshot/{self.REG}*'
                os.system(command_del)
                time.sleep(2)

                #Screenshoot
                captura_cmd = f'export DISPLAY=:0 && export XAUTHORITY=/home/pi/.Xauthority && scrot -bu {png_file_path}'
                os.system(captura_cmd)
                time.sleep(14)

                if not os.path.exists(png_file_path):
                    print('Error: No se pudo crear la captura de pantalla.')
                else:
                    # Convertir la imagen PNG a JPG y redimensionarla para reducir el tamaño
                    with Image.open(png_file_path) as img:
                        img = img.convert('RGB')  # Convertir a RGB (JPG no soporta transparencia)
                        img = img.resize((1024, 600), Image.ANTIALIAS)  # Redimensionar a 800x600 píxeles
                        img.save(jpg_file_path, 'JPEG', quality=85)  # Guardar como JPG con calidad 85

                    #Verificar si el archivo de captura de pantalla JPG fue creado
                    if not os.path.exists(jpg_file_path):
                        print('Error: No se pudo crear la imagen JPG.')
                    else:
                        time.sleep(14)
                        out_command=f'scp -i /etc/mining/tunel {jpg_file_path} tunel@tunel.mine-360.com:/home/tunel/{self.FAENA}/'
                        os.system(out_command)

                time.sleep(270)

            except:
                print('Error al instentar crear o subir la imagen')

screen = Pantalla()
