import subprocess
import json
import traceback
import sys


def get_product_id():
    data = subprocess.check_output(["machineid"]).decode("utf-8").replace("\n", "")
    return int(data)

def get_product_name():
    data = subprocess.check_output(["machinename"]).decode("utf-8").replace("\n", "")
    return data

def get_location_assigned():
    caex = "STGO"
    try:
        f = open('/srv/live/topic.json')
        config:dict = json.load(f)
        caex = config["topic"].split("/")[2]
    except:
        traceback_exception()
    return caex

def get_faena_assigned():
    faena = "TallerStgo"
    try:
        f = open('/srv/live/topic.json')
        config:dict = json.load(f)
        faena = config["topic"].split("/")[0]
    except:
        traceback_exception()
    return faena

def get_avalaible_faenas(datalogger_type):
    faenas = []
    try:
        f = open(f'/srv/datalogger_{datalogger_type}/config/urls.json')
        config:dict = json.load(f)
        faenas = config.keys()
    except:
        traceback_exception()
    return faenas

def traceback_exception():
    try:
        e = sys.exc_info()
        print("dumping traceback for [%s: %s]" % (str(e[0].__name__), str(e[1])))
        traceback.print_tb(e[2])
    except:
        foo = "bar"

def comand(orden,modo=1):
    orden_s=orden.split(' ')
    if modo==1:
        res=subprocess.check_output(orden_s)
        if res.decode()!='\n' or res.decode()!='':
            print(res.decode())
    elif modo==0:
        try:
            res=subprocess.check_output(orden_s)
            if res.decode()!='\n' or res.decode()!='':
                print(res.decode())
        except: pass