// === Estado botones (solo lectura desde backend) ===
let estadoBotones = { cargar_agua: false, cargar_sulf: false, detener: true, time: 0 };
let estadoPollId = null;
estadoNoIniciado = true

async function syncEstadoAguaSurf() {
  try {
    const r = await fetch('/estadoAguaSurf', { cache: 'no-store' });
    const e = await r.json();
    console.log('[syncEstadoAguaSurf] estado actual:', e);
    aplicarEstadoAguaSurf(e);
  } catch (err) {
    console.error('[syncEstadoAguaSurf]', err);
  }
}

function aplicarEstadoAguaSurf(e) {
  
  estadoBotones = e;
  // Actualiza “llenando” SOLO desde el backend (no lo resetees en reload)
  mostrarBotones(e);

  // Mensaje inferior (solo UI)
  if (e.cargar_agua && estadoNoIniciado)       {
    actualizarEstadoOperacion('🚰 Llenando agua…');
    estadoNoIniciado = false;
  }

  else if (e.cargar_sulf && estadoNoIniciado)  {
    actualizarEstadoOperacion('🧪 Llenando surfactante…');
    estadoNoIniciado = false;
  }
  else if (e.detener)      actualizarEstadoOperacion('⏸️ Detenido');
}

function setBtnToggle(id, on) {
  const el = document.getElementById(id);
  if (!el) return;
  el.classList.toggle('active', !!on);
  el.setAttribute('aria-pressed', String(!!on));
}

// Arrancar polling al cargar
document.addEventListener('DOMContentLoaded', () => {
  // Configurar primero identificador y modo
  configurarIdentificador().then(() => configurarModoOperacion());
  // Traer estado actual y mantenerlo sincronizado
  syncEstadoAguaSurf();
  estadoPollId = setInterval(syncEstadoAguaSurf, 1500);
});

let modoOperacion = null; //default

async function configurarModoOperacion() {
  detenerPorEstado();
  // Extrae el número y convierte a entero para eliminar ceros a la izquierda
  let numero = parseInt(identificador.split("-")[1], 10); // "001" → 1
  let clave = `modo_reg${numero}`; // Construye la clave en minúsculas

  const modo = await consultarServidorPorKey(clave);
  console.log(modo)

  if (modo === null) {
    console.warn("No se pudo obtener el modo de operación. Cambiando a modo operación manual");
    modoOperacion = 1; // Cambia a modo manual
    return;
  }

  console.log("Modo de operación por defecto:", modoOperacion);
  console.log("Modo desde servidor:", modo);

  // Solo actualiza si cambió
  if (modo !== modoOperacion) {
    modoOperacion = modo;
    console.log("Modo ACTUALIZADO:", modoOperacion);

    let texto = "";
    switch (modoOperacion) {
      case 1:
        texto = "1 — 100% Manual";
        break;
      case 2:
        texto = "2 — Manual + IA de centrado";
        break;
      case 3:
        texto = "3 — 100% IA";
        break;
      default:
        texto = `Modo desconocido (${modoOperacion})`;
    }

    const indicador = document.getElementById("modo-operacion-indicador");
    if (indicador) {
      indicador.textContent = `Modo de operación: ${texto}`;
    }

    console.log("Modo de operación actualizado:", texto);
  }
}

function mostrarBotones(e) {
  console.log("Modo de operación:", modoOperacion);
  if (modoOperacion === 1) {

    document.getElementById("btn-agua").style.display = "block";
    document.getElementById("btn-sulf").style.display = "block";
    document.getElementById("btn-llenado-ia").style.display = "none";
    document.getElementById("btn-llenado-agua-ia").style.display = "none";
    document.getElementById("btn-llenado-sulf-ia").style.display = "none";

    document.getElementById("btn-agua").disabled = false;
    document.getElementById("btn-sulf").disabled = false;

    if (e.cargar_agua) {
      document.getElementById("btn-agua").disabled = true;
      document.getElementById("btn-sulf").disabled = true;
    }
    if (e.cargar_sulf) {
      document.getElementById("btn-sulf").disabled = true;
      document.getElementById("btn-agua").disabled = true;
    }

  } else if (modoOperacion === 2) {
    document.getElementById("btn-agua").style.display = "none";
    document.getElementById("btn-sulf").style.display = "none";
    document.getElementById("btn-llenado-ia").style.display = "none";
    document.getElementById("btn-llenado-agua-ia").style.display = "block";
    document.getElementById("btn-llenado-sulf-ia").style.display = "block";

    if(centrado){
      document.getElementById("btn-llenado-agua-ia").disabled = false;
      document.getElementById("btn-llenado-sulf-ia").disabled = false;
    } else {
      document.getElementById("btn-llenado-agua-ia").disabled = true;
      document.getElementById("btn-llenado-sulf-ia").disabled = true;
    }

    if (e.cargar_agua) {
      document.getElementById("btn-llenado-agua-ia").disabled = true; 
      document.getElementById("btn-llenado-sulf-ia").disabled = true;
    }
    if (e.cargar_sulf) {
      document.getElementById("btn-llenado-agua-ia").disabled = true; 
      document.getElementById("btn-llenado-sulf-ia").disabled = true;
    }


  } else if (modoOperacion === 3) {
    document.getElementById("btn-agua").style.display = "none";
    document.getElementById("btn-sulf").style.display = "none";
    document.getElementById("btn-llenado-agua-ia").style.display = "block";
    document.getElementById("btn-llenado-ia").style.display = "block";
    document.getElementById("btn-llenado-sulf-ia").style.display = "none";


    if (e.cargar_agua) {
      document.getElementById("btn-llenado-agua-ia").disabled = true; 
      document.getElementById("btn-llenado-ia").disabled = true;
    }
    if (e.cargar_sulf) {
      console.log("Deshabilitando botones de llenado de sulfato");
      document.getElementById("btn-llenado-agua-ia").disabled = true; 
      document.getElementById("btn-llenado-ia").disabled = true;
    }
    if (e.detener && !llenando) {
      actualizarEstadoOperacion('Listo para cargar');
    }
    if (!e.detener){
      document.getElementById("btn-llenado-agua-ia").disabled = true;
      document.getElementById("btn-llenado-ia").disabled = true;
    }

  }
}



setInterval(() => {
  configurarModoOperacion();
}, 1000);

/**
 * Verifica si el camión está centrado y muestra u oculta botones dependiendo de eso.
 * 
 * Si el camión está centrado y no se está llenando, se muestra el botón de
 * llenado automático. Si no se está centrado, se ocultan los botones de llenado
 * automático y se muestra un mensaje de espera.
 * 
 * @returns {Promise<void>}
 */

let centradoTemp = null;
function mostrarBotonesSiCentrado() {
  consultarServidorPorKey("centrado")
    .then((centradoTemp) => {
      console.log("Estado llenando:", llenando);
      console.log("Centrado desde servidor:", centradoTemp);

      // Caso 1: ❌ No centrado y ❌ No llenando → Deshabilita botones
      if (!centradoTemp && !llenando) {
        centrado = false;
        modificarLabel("centrado-camion", "No centrado ❌");
        //actualizarEstadoOperacion("📡 Esperando centrado del camión...");
        document.getElementById("btn-llenado-agua-ia").disabled = true;
        document.getElementById("btn-llenado-sulf-ia").disabled = true;
        document.getElementById("btn-llenado-ia").disabled = true;
      }

      // Caso 2: ✅ Centrado y ❌ No llenando → Habilita botones
      else if (centradoTemp && !llenando) {
        console.log("Centrado detectado y no llenando");
        centrado = true;
        modificarLabel("centrado-camion", "Centrado ✅");
        //actualizarEstadoOperacion("Centrado ✅");
        document.getElementById("btn-llenado-agua-ia").disabled = false;
        document.getElementById("btn-llenado-sulf-ia").disabled = false;
        document.getElementById("btn-llenado-ia").disabled = false;
      }

      // Caso 3: ✅ Centrado y ✅ Llenando → Deshabilita botones
      else if (centradoTemp && llenando) {
        centrado = true;
        modificarLabel("centrado-camion", "Centrado ✅");
        document.getElementById("btn-llenado-agua-ia").disabled = true;
        document.getElementById("btn-llenado-sulf-ia").disabled = true;
        document.getElementById("btn-llenado-ia").disabled = true;
      }

      // Caso 4: ❌ No centrado pero ✅ Llenando → Habilita botones y mantiene centrado en true
      else if (!centradoTemp && llenando) {
        centrado = true;  // se fuerza centrado = true mientras se llena
        modificarLabel("centrado-camion", "Centrado ✅");
        console.log("Centrado forzado mientras se llena");
        document.getElementById("btn-llenado-agua-ia").disabled = true;
        document.getElementById("btn-llenado-sulf-ia").disabled = true;
        document.getElementById("btn-llenado-ia").disabled = true;
      }

    })
    .catch((error) => {
      console.error("Error al consultar centrado:", error);
    });
    }



setInterval(() => {
  mostrarBotonesSiCentrado();
}, 1000);

async function configurarIdentificador() {
  try {
    const resp = await fetch('/id_mmr', { cache: 'no-store' });
    if (!resp.ok) throw new Error(`HTTP ${resp.status}`);
    const id = (await resp.text()).trim(); // p.ej. "REG-002"

    if (id) {
      identificador = id;
      modificarLabel("numero-camion", identificador);
      return;
    }

    throw new Error('id_mmr vacío');
  } catch (error) {
    console.error("Error al configurar identificador desde /id_mmr:", error);
    identificador = null;
    modificarLabel("numero-camion", "REG-");
  }
}


setInterval(() => {
  configurarIdentificador();
}, 4000); // 1000 ms = 1 segundo


async function configurarEstadoAgua() {
  const estadoAgua = await consultarServidorPorKey("estado");
  if (estadoAgua === "LLENO") {
    modificarLabel("estado-agua", "Tanque lleno ✅");
  } else if (estadoAgua === "VACIO") {
    modificarLabel("estado-agua", "Tanque vacío 🟡");
  } else if (estadoAgua === "DESBORDADO") {
    modificarLabel("estado-agua", "Agua desbordada 🚨");
  } else {
    modificarLabel("estado-agua", "Estado desconocido ❓");
  }
}

setInterval(() => {
  configurarEstadoAgua();
}, 1000); // 1000 ms = 1 segundo


async function verificarCamara() {
  //activar = true;
  const activar = await debeActivarCamara();
  console.log("Estado de activar_camara:", activar);

  if (!activar) {
    cerrarCamara();               // Cierra el modal si está abierto
    document.getElementById("btn-ver-camara").style.display = "none";  // btn-ver-camara
  } else {
    document.getElementById("btn-ver-camara").style.display = "block";  // btn-ver-camara
  }
}

// Ejecutar cada 1 segundo
setInterval(() => {
  verificarCamara();
}, 1000); // 1000 ms = 1 segundo


function actualizarEstadoOperacion(texto) {
  const estadoEl = document.getElementById("estado-operacion-inferior");
  if (estadoEl) {
    estadoEl.textContent = texto;
  }
}


/**
 * Abre la c mara en el modal y comienza a reproducir el video HLS.
 */
function abrirCamara() {
  document.getElementById("modalCamara").style.display = "block";

  const video = document.getElementById("videoHLS");
  const videoSrcTunel =
    "http://tunel.mine-360.com:8888/cam_cachimba2/index.m3u8";
  const videoSrcLocal =
    "http://tunel.mine-360.com:8888/cam_cachimba2/index.m3u8";
  //const videoSrcLocal = "http://raspberrypi:8888/local_cachimba/index.m3u8";

  fetch("/msg_nano")
    .then((res) => res.json())
    .then((data) => {
      const source = data.videoSrc === 2 ? videoSrcTunel : videoSrcLocal;

      if (Hls.isSupported()) {
        const hls = new Hls();
        hls.loadSource(source);
        hls.attachMedia(video);
        hls.on(Hls.Events.MANIFEST_PARSED, function () {
          video.play();
        });
        window.hlsInstance = hls;
      } else if (video.canPlayType("application/vnd.apple.mpegurl")) {
        video.src = source;
        video.addEventListener("loadedmetadata", function () {
          video.play();
        });
      }
    })
    .catch((err) => {
      console.error("Error al obtener fuente de video desde /msg_nano", err);
    });
}

/**
 * Cierra el modal de la c mara y detiene la reproducci n del video HLS.
 *
 * Destruye la instancia de Hls.js si fue creada.
 */
function cerrarCamara() {
  const modal = document.getElementById("modalCamara");
  const video = document.getElementById("videoHLS");
  video.pause();
  video.currentTime = 0;
  modal.style.display = "none";

  // Destruir hls.js si fue usado
  if (window.hlsInstance) {
    window.hlsInstance.destroy();
    window.hlsInstance = null;
  }
}



let CONS_SEGUNDOS_ESPERA = 60; // segundos de espera para iniciar surfactante
let CONS_SEGUNDOS_LLENADO_SURF = 300;

let llenando = false;
let detenidoAguaPorIA = false;
let cargadoAguaPorIA = false;
let inicializadoSurfPorIA = false;
let verificarTiempoSurf = null;
let tiempoSurfIniciado = false;
let procesoIAActivo = false;
let intervaloContadorSurf = null;
let intervaloEstadoAgua = null;
let intervaloContadorEspera = null;
let identificador = null;


let intervaloContador = null;
let timeoutSurfInicio = null;
let intervaloSurfContador = null;
let timeoutFinalizarSurf = null;

////////////////////////////////////////////////////////////////////////////
