/**
 * Función para manejar la carga de agua o surfactante en modo manual.
 *
 * @param {string} key - Clave para cargar agua o surfactante.
 *
 * Se llama a la función enviarAccionMultiple() con la
 * clave correspondiente y se deshabilita el botón correspondiente.
 * Si la clave no es válida, se muestra un mensaje de advertencia en la consola.
 *
 * @throws Error - Si se produce un error en la ejecución de la función, se
 * lanza un error con un mensaje que indica el error.
 */
function cargar(key) {
  const botones = {
    cargar_agua: "btn-agua",
    cargar_sulf: "btn-sulf",
  };

  if (modoOperacion === 1) {
    if (botones.hasOwnProperty(key)) {
      try {
        if (key === "cargar_sulf") {
          enviarAccionMultiple({
            cargar_agua: false,
            cargar_sulf: true,
            detener: false,
          });
          llenando = true;
          actualizarEstadoOperacion("🧪 Cargando surfactante...");

          let segundosRestantes = CONS_SEGUNDOS_LLENADO_SURF;

          intervaloContadorSurf = setInterval(() => {
            segundosRestantes--;
            const minutos = Math.floor(segundosRestantes / 60);
            const segundos = segundosRestantes % 60;
            actualizarEstadoOperacion(
              `⌚Cargando surfactante: ${minutos}min:${segundos}s`
            );

            if (segundosRestantes <= 0) {
              clearInterval(intervaloContadorSurf);
              intervaloContadorSurf = null;
              detenerTodo();
              mostrarMensaje("⏱️ Surfactante finalizado.");
            }
          }, 1000); // Cada segundo
        }
        if (key === "cargar_agua") {
          enviarAccionMultiple({
            cargar_agua: true,
            cargar_sulf: false,
            detener: false,
          });
          llenando = true;
          actualizarEstadoOperacion("💧 Cargando agua...");
        }
        document.getElementById("btn-agua").disabled = true;
        document.getElementById("btn-sulf").disabled = true;
        document.getElementById("btn-detener").disabled = false;
      } catch (error) {
        console.error(`Error al cargar ${key}:`, error);
      }
    } else {
      console.warn(`Clave no válida en cargar(): ${key}`);
    }
  }
}

async function cargarIA(key) {
  try {
    // Verificar si el embudo está centrado
    console.log("Centrado del embudo:", centrado);
    if (!centrado) {
      document.getElementById("btn-llenado-agua-ia").disabled = true;
      document.getElementById("btn-llenado-sulf-ia").disabled = true;
      console.log("Esperando centrado del embudo...");
      return;
    }
    document.getElementById("btn-llenado-agua-ia").disabled = false;
    document.getElementById("btn-llenado-sulf-ia").disabled = false;
    procesoIAActivo = true;
    if (key === "cargar_sulf") {
      enviarAccionMultiple({
        cargar_agua: false,
        cargar_sulf: true,
        detener: false,
      });
      llenando = true;
      actualizarEstadoOperacion("🧪 Cargando surfactante...");

      let segundosRestantes = CONS_SEGUNDOS_LLENADO_SURF;

      intervaloContadorSurf = setInterval(() => {
        segundosRestantes--;

        if (!procesoIAActivo) {
          clearInterval(intervaloContadorSurf);
          intervaloContadorSurf = null;
          actualizarEstadoOperacion("⏱️ Cancelado");
          return;
        }

        const minutos = Math.floor(segundosRestantes / 60);
        const segundos = segundosRestantes % 60;
        actualizarEstadoOperacion(
          `⌚Cargando surfactante: ${minutos}min:${segundos}s`
        );

        if (segundosRestantes <= 0) {
          clearInterval(intervaloContadorSurf);
          intervaloContadorSurf = null;
          detenerTodo();
          mostrarMensaje("⏱️ Surfactante finalizado.");
        }
      }, 1000); // Cada segundo
    }

    if (key === "cargar_agua") {
      enviarAccionMultiple({
        cargar_agua: true,
        cargar_sulf: false,
        detener: false,
      });
      actualizarEstadoOperacion("💧 Llenando agua...");
      llenando = true;
    }

    if (modoOperacion === 3) {
      cargadoAguaPorIA = true;
      procesoIAActivo = true;
      console.log(
        "cargadoAguaPorIA:",
        cargadoAguaPorIA,
        "procesoIAActivo:",
        procesoIAActivo
      );
      document.getElementById("btn-detener").disabled = false;

      // Monitorear estado hasta que el agua esté llena o desbordada
      intervaloEstadoAgua = setInterval(async () => {
        if (!procesoIAActivo) return;

        const estado = await consultarServidorPorKey("estado");
        console.log("Estado actual dentro de IA:", estado);

        if (estado === "DESBORDADO") {
          clearInterval(intervaloEstadoAgua);
          intervaloEstadoAgua = null;
          detenerPorEstado();
          mostrarMensaje("Agua completada - Detenida por IA.");
          document.getElementById("btn-llenado-ia").disabled = true;
          detenidoAguaPorIA = false;
        }
      }, 3000);
    }

    document.getElementById("btn-llenado-agua-ia").disabled = true;
    document.getElementById("btn-llenado-sulf-ia").disabled = true;

    document.getElementById("btn-detener").disabled = false;

    console.log("Iniciando llenado de agua...");
  } catch (error) {
    console.error("Error al iniciar agua con IA:", error);
    console.log("Error del sistema al iniciar llenado con IA.");
  }
}

async function cargarTodoIA() {
  if (modoOperacion !== 3) return;

  try {
    if (!centrado) {
      mostrarMensaje("Esperando centrado...");
      return;
    }
    document.getElementById("btn-llenado-ia").disabled = true;

    mostrarMensaje("Iniciando llenado de agua...");
    enviarAccionMultiple({
      cargar_agua: true,
      cargar_sulf: false,
      detener: false,
    });
    actualizarEstadoOperacion("💧 Llenando agua...");
    llenando = true;

    cargadoAguaPorIA = true;
    procesoIAActivo = true;

    document.getElementById("btn-detener").disabled = false;

    // Monitorear estado hasta que el agua esté llena o desbordada
    intervaloEstadoAgua = setInterval(async () => {
      if (!procesoIAActivo) return;

      const estado = await consultarServidorPorKey("estado");
      console.log("Estado actual:", estado);

      if (estado === "DESBORDADO") {
        clearInterval(intervaloEstadoAgua);
        intervaloEstadoAgua = null;
        detenerPorEstado();

        llenando = true;
        mostrarMensaje(
          "Agua completada. Esperando 1 minuto antes del surfactante..."
        );
        document.getElementById("btn-llenado-ia").disabled = true;

        // Contador visual durante espera
        let segundosEspera = 0;
        intervaloContadorEspera = setInterval(() => {
          if (!procesoIAActivo) {
            clearInterval(intervaloContadorEspera);
            intervaloContadorEspera = null;
            console.log("Contador de espera interrumpido.");
            return;
          }

          segundosEspera++;
          restante = CONS_SEGUNDOS_ESPERA - segundosEspera;
          actualizarEstadoOperacion(
            `⏱️ Esperando para iniciar surfactante: ${restante}s`
          );
          llenando = true;
          console.log(`Esperando: ${segundosEspera}s`);
          enviarAccionMultiple({
            cargar_agua: false,
            cargar_sulf: false,
            detener: true,
          });

          if (segundosEspera >= CONS_SEGUNDOS_ESPERA) {
            clearInterval(intervaloContadorEspera);
            intervaloContadorEspera = null;

            mostrarMensaje("Iniciando llenado de surfactante...");
            enviarAccionMultiple({
              cargar_agua: false,
              cargar_sulf: true,
              detener: false,
            });
            actualizarEstadoOperacion("🧪 Cargando surfactante...");
            llenando = true;

            inicializadoSurfPorIA = true;

            // Contador visual durante surfactante
            let segundosSurf = 0;
            intervaloContadorSurf = setInterval(() => {
              if (!procesoIAActivo) {
                clearInterval(intervaloContadorSurf);
                intervaloContadorSurf = null;
                console.log("Contador de surfactante interrumpido.");
                actualizarEstadoOperacion(`⏱️⚠️ Contador interrumpido`);
                return;
              }

              segundosSurf++;
              restante = CONS_SEGUNDOS_LLENADO_SURF - segundosSurf;
              const minutos = Math.floor(restante / 60);
              const segundos = restante % 60;
              actualizarEstadoOperacion(
                `⌚Cargando surfactante: ${minutos}min:${segundos}s`
              );

              console.log(`Cargando surfactante: ${segundosSurf}s`);

              if (segundosSurf >= CONS_SEGUNDOS_LLENADO_SURF) {
                clearInterval(intervaloContadorSurf);
                intervaloContadorSurf = null;
                detenerTodo();

                mostrarMensaje(
                  "Proceso IA completo. Agua + Surfactante finalizados."
                );
                document.getElementById("btn-llenado-ia").disabled = false;
              }
            }, 1000);
          }
        }, 1000);
      }
    }, 3000);
  } catch (error) {
    console.error("Error en secuencia IA:", error);
    mostrarMensaje("Error durante la ejecución IA.");
  }
}
