
/**
 * Env a la accion del key al json.
 * Se utiliza para cargar solo agua o surfactante.
 */
function cargarSolo(key_json, valor) {
  enviarAccion(key_json, valor);
  return;
}

/**
 * Env a la acci n "accion" al servidor. La respuesta del servidor se
 * mostrar  en la consola. Modifica el archivo button_State.json
 * @param {string} accion - La accion es la key del json.
 */
function enviarAccion(clave, valor) {
  const payload = {};
  payload[clave] = valor;
  console.log("Enviando acción:", payload)

  fetch("/accion", {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
    body: JSON.stringify(payload),
  })
    .then((response) => response.json())
    .then((data) => console.log("Respuesta enviarAccion:", data))
    .catch((error) => console.error("Error al enviar acción:", error));
}

function enviarAccionMultiple(objetoAcciones) {
  fetch("/accion", {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
    body: JSON.stringify(objetoAcciones),
  })
    .then((response) => response.json())
    .then((data) => console.log("Respuesta:", data))
    .catch((error) => console.error("Error al enviar acción:", error));
}



/**
 * Consulta los datos del archivo msg_nano.json.
 */

function consultarServidor() {
  fetch("/msg_nano")
    .then((res) => res.json())
    .then((data) => {
      return data
    })
    .catch(() => console.log("[ERROR] No se puede consultar los datos del archivo msg_nano."));
}

function consultarServidor() {
  fetch("/msg_nano")
    .then((res) => res.json())
    .then((data) => {
      return data
    })
    .catch(() => console.log("[ERROR] No se puede consultar los datos del archivo msg_nano."));
}

async function debeActivarCamara() {
  try {
    const response = await fetch('/estadoBotonesActivos');
    if (!response.ok) {
      console.error('[ERROR] No se pudo obtener el estado:', response.status);
      return true;
    }

    const data = await response.json();
    console.log('[INFO] Estado de activar_camara:', data.activar_camara);
    return data.activar_camara === true;
  } catch (error) {
    console.error('[ERROR] Al consultar /estadoBotonesActivos:', error);
    return true;
  }
}


/**
 * Consulta los datos del archivo msg_nano.json mediante una key.
 */

async function consultarServidorPorKey(key_consulta) {
  try {
    const res = await fetch("/msg_nano");
    const data = await res.json();
    return data[key_consulta];
  } catch (error) {
    console.log("[ERROR] No se puede consultar los datos del archivo msg_nano con esa llave.");
    console.error("Error consultando msg_nano:", error);
    return null;
  }
}

function funcionContador(minutos) {
  let tiempoRestante = minutos * 60; // en segundos
  let isFinished = false;

  const intervalo = setInterval(() => {
    tiempoRestante--;
    if (tiempoRestante <= 0) {
      clearInterval(intervalo);
      isFinished = true;
    }
  }, 1000);

  return () => ({
    isFinished,
    tiempoRestante: Math.max(0, tiempoRestante),
  });
}

function esperarConContador(segundos, mensajeInicio, mensajeFin, callback) {
  let segundosPasados = 0;
  console.log(mensajeInicio);

  intervaloContador = setInterval(() => {
    segundosPasados++;
    console.log(`${mensajeInicio}: ${segundosPasados}s`);

    if (segundosPasados >= segundos) {
      clearInterval(intervaloContador);
      intervaloContador = null;
      console.log(mensajeFin);
      if (callback) callback();
    }
  }, 1000);
}

function mostrarMensaje(mensaje) {
  console.log(mensaje);
}

function modificarLabel(idLabel, texto) {
  document.getElementById(idLabel).innerHTML = texto;
}
