animacion = function () {
  document.getElementById("infoPanel").classList.toggle("fade");
};

setInterval(animacion, 500);

const START_ZOOM = 15;
const MAX_AUTO_ZOOM = 22;



var mymap = L.map("mapid", {
  zoomControl: false,
  minZoom: 11,
  maxZoom: MAX_AUTO_ZOOM,
}).setView([-22.633667, -69.877167], START_ZOOM);

L.control.zoom({ position: "topright" }).addTo(mymap);

mymap.on('zoomend moveend', () => console.log('zoom:', mymap.getZoom()));

$(".leaflet-control-attribution").hide();

var fechaActual = new Date();
let hora = fechaActual.getHours();

console.log("HORA: " + hora);

const MAPBOX_STYLE_DAY = "mapbox/satellite-v9"; 
const MAPBOX_STYLE_NIGHT = "mapbox/dark-v11";

hora = 9;
const mapaEstilo =
  hora >= 8 && hora < 20 ? MAPBOX_STYLE_DAY : MAPBOX_STYLE_NIGHT;
console.log("Estilo del mapa: " + mapaEstilo);

const MAPBOX_TOKEN =
  "pk.eyJ1IjoiZ2plcmV6IiwiYSI6ImNtYWViemQ5bDA1cHMycnB6NnliZnhrdjgifQ.J3NFy110e2pHvO5tN4KA3w";
L.tileLayer(
  `https://api.mapbox.com/styles/v1/${mapaEstilo}/tiles/{z}/{x}/{y}?access_token=${MAPBOX_TOKEN}`,
  {
    maxZoom: 22,
    tileSize: 512,
    zoomOffset: -1,
    attribution: "© OpenStreetMap · © Mapbox",
    detectRetina: false,   // ← sin @2x
    className: "sat-base"  // ← para aplicar filtro por CSS
  }
).addTo(mymap);

console.log("Usando estilo:", mapaEstilo);
mymap.on("tileerror", e => console.error("Tile error:", e));


// Si el contenedor cambia de tamaño (sidebar/modal), recalcula:
setTimeout(() => mymap.invalidateSize(), 300);

var popup = L.popup();

// Marcadores hardcodeados
function addMarker(name, latlon) {
  var marker = new L.Marker(latlon, {
    title: name,
    clickable: false,
    draggable: false,
    icon: L.divIcon({
      className: "",
      iconSize: [100, 40],
      iconAnchor: [50, 40],
      html: `<p align="center" style="align:center;font-family:Helvetica; font-weight:bold; font-size:20px; color:#ffffff; text-shadow: -2px -2px 0 #000, 2px -2px 0 #000, -2px 2px 0 #000, 2px 2px 0 #000, 0px -2px 0 #000, 0px 2px 0 #000, 2px 0px 0 #000, -2px 0px 0 #000;">${name}<p>`,
    }),
  });
  marker.addTo(mymap);
}

//addMarker("MARKER", [-22.7859, -69.2616]);

eye3 = {
  map_center_update_interval_ms: 5000,
  last_gps_timestamp: 0,
  configurations: {},
  CustomIcon: L.Icon.extend({
    options: {
      iconSize: [50, 50],
      shadowSize: [0, 0],
      iconAnchor: [25, 25],
      shadowAnchor: [4, 0],
      popupAnchor: [0, 0],
    },
  }),
  CustomWaterTruckIcon: L.Icon.extend({
    options: {
      iconSize: [200, 200],
      shadowSize: [0, 0],
      iconAnchor: [34, 120], // Adjusted for bigger icon
      shadowAnchor: [4, 0],
      popupAnchor: [0, 0],
    },
  }),
  HaulTruckIcon: function (angle) {
    var svgicon_url = encodeURI(
      "data:image/svg+xml," + haulTruckSVG(angle)
    ).replace("#", "%23");
    var icon = new eye3.CustomIcon({ iconUrl: svgicon_url });
    return icon;
  },
  WaterTruckIcon: function (name, color) {
    var svgicon_url = encodeURI(ColorSVGMarker(name, color)); //.replace('#','%23');
    var icon = new eye3.CustomWaterTruckIcon({ iconUrl: svgicon_url });
    return icon;
  },
  map: mymap,
  vehicle: null,
  waterPolylines: [],
  dustMarks: [],
  microClusters: [],
  macroClusters: [],
  macroClusterBounds: [],
};

// Source: https://spence2-dot-project-spence.uc.r.appspot.com/api/getAllConfigurations
configurations = [
  {
    name: "position_max_hours",
    value: "12",
  },
  {
    name: "polvo_dia_tablet",
    value: "90",
  },
  {
    name: "polvo_noche_tablet",
    value: "120",
  },
  {
    name: "riego_dia_tablet",
    value: "30",
  },
  {
    name: "riego_noche_tablet",
    value: "30",
  },
  {
    name: "ecom_scale_factor",
    value: "1",
  },
  {
    name: "mapa_inicial_min",
    value: "1700",
  },
  {
    name: "mapa_inicial_max",
    value: "4000",
  },
  {
    name: "rango_pm_alto",
    value: "3500",
  },
  {
    name: "rango_pm_medio_alto",
    value: "1500",
  },
  {
    name: "rango_pm_medio_bajo",
    value: "600",
  },
  {
    name: "rango_pm_bajo",
    value: "599",
  },
  {
    name: "sanidad_switch",
    value: "1",
  },
  {
    name: "horas_muestra_camino",
    value: "12",
  },
  {
    name: "minimo_corte_camino",
    value: "200",
  },
  {
    name: "responsable_geofence_produccion",
    value: "Evelyn Celis",
  },
  {
    name: "responsable_geofence_produccion_unificado",
    value: "Evelyn Celis",
  },
  {
    name: "factorgimppm100",
    value: "10",
  },
];

configurations.forEach((configuration) => {
  console.log(configuration.name);
  console.log(configuration.value);
  eye3.configurations[configuration.name] = configuration.value;
});

function onMapClick(e) {
  oldlat = -22.622343;
  oldlon = -68.842637;
  newlat = e.latlng.lat;
  newlon = e.latlng.lng;

  angle = (Math.atan2(newlon - oldlon, newlat - oldlat) * 180) / 3.141592;
}

mymap.on("click", onMapClick);

/* JAVASCRIPT CONSOLE */

// CAMINOS
eye3.layer = [];
eye3.polygon = [];
let colorLayer = "";

if (hora >= 8 && hora < 20) {
  colorLayer = "#000000";
} else {
  colorLayer = "#f5f6fa";
}

eye3.layer["waterLineStrings"] = L.geoJson(null, {
  style: function (feature) {
    return {
      color: "#0000ff",
      weight: 5,
      opacity: 0.8,
      strokeWeight: 1,
    };
  },
});
mymap.addLayer(eye3.layer["waterLineStrings"]);

eye3.layer["caminos"] = L.geoJson(null, {
  style: function (feature) {
    //console.log('COLOR: '+ feature.properties.strokeColor)
    return {
      color: colorLayer,
      fill: true,
      opacity: 0.8,
      clickable: false,
      strokeWeight: 0.5,
    };
  },
  onEachFeature: function (feature, layer) {
    //console.log("onEachFeature:"+ JSON.stringify(feature.properties));
    if (feature.properties.polygon_id == null) {
    }
    eye3.polygon[feature.properties.polygon_id] = layer;
    layer.options.polygon_id = feature.properties.polygon_id;
  },
});

$.getJSON("/static/img/caminos.geojson", function (data) {
  eye3.layer["caminos"].addData(data);
});
mymap.addLayer(eye3.layer["caminos"]);

// AREAS
var construcciones_left = L.geoJson(null, {
  style: function (feature) {
    console.log(feature);
    // Tipificacion:
    if (feature.properties.Area == "Caminos") {
      return {
        color: "#4d4d4d",
        strokeColor: "#4d4d4d",
        fillOpacity: 0.7,
        strokeOpacity: 0.3,
        weight: 0.1,
      };
    }

    return {
      color: feature.properties.strokeColor,
      fill: true,
      opacity: 1,
      clickable: false,
    };
  },
}); 




// Get status updates every 15 seconds
var d = new Date();
eye3.lastMapEvent =
  d.getYear() + 1900 + "-" + (d.getMonth() + 1) + "-" + d.getDate();


eye3.markers = [];

function renderMacroClusterBounds(result) {
  // Clean up microclusters, then repopulate
  for (i in eye3.macroClusterBounds) {
    eye3.map.removeLayer(eye3.macroClusterBounds[i]);
  }
  eye3.macroClusterBounds = [];
  for (i in result.geojson_bounds.features) {
    let feature = result.geojson_bounds.features[i];
    let props = feature.properties;
    let coords = feature.geometry.coordinates[0];
    let newcoords = coords.map(function (latlon) {
      return [latlon[1], latlon[0]];
    });
    //console.log(`--- procesando macroClusterBound ${i} de ${result.geojson_bounds.features.length}`);
    //console.log(newcoords);

    let boundsColor = "#00ff00";
    if (props.avg_pm100 >= 200 && props.avg_pm100 < 600) {
      boundsColor = "#ff0000";
    }
    if (props.avg_pm100 >= 600 && props.avg_pm100 < 2500) {
      boundsColor = "#990033";
    }
    if (props.avg_pm100 >= 2500 && props.avg_pm100 < 4000) {
      boundsColor = "#990099";
    }

    let p = L.polygon(newcoords, {
      fillColor: boundsColor,
      stroke: false,
      opacity: 0.15,
      fillOpacity: 0.15,
    }).addTo(eye3.map);
    eye3.macroClusterBounds.push(p);
  }
}

function renderMicroClusters(result) {
  // Clean up microclusters, then repopulate
  for (i in eye3.microClusters) {
    eye3.map.removeLayer(eye3.microClusters[i]);
  }
  eye3.microClusters = [];
  for (i in result.geojson_clusterbase.features) {
    let feature = result.geojson_clusterbase.features[i];
    let props = feature.properties;
    let coords = feature.geometry.coordinates[0];
    let newcoords = coords;
    if (feature.geometry.type == "MultiPolygon") {
      newcoords = coords.map(function (x) {
        return x.map(function (y) {
          return y.map(function (z) {
            //console.log(`inverting (${z[0]}, ${z[1]}) to (${z[1]}, ${z[0]})`);
            return [z[1], z[0]];
          });
        });
      });
    } else {
      newcoords = coords.map(function (latlon) {
        return [latlon[1], latlon[0]];
      });
    }
    console.log(
      `--- procesando cluster ${i} de ${result.geojson_clusterbase.features.length}`
    );
    console.log(newcoords);

    let clusterColor = "#FF0000";

    /*if ((props.pm100_avg >= eye3.configurations["mapa_inicial_min"])) {
         clusterColor = "#ff0000";
      }
      if ((props.pm100_avg >= 500) && (props.pm100_avg < 1700)){
         clusterColor = '#ff0000';
      }
      if ((props.pm100_avg >= 1700) && (props.pm100_avg < 3500)){
         clusterColor = '#990033';
      }
      if ((props.pm100_avg >= 3500) && (props.pm100_avg < 4000)){
         clusterColor = '#990099';
      }*/

    let p = L.polygon(newcoords, {
      fillColor: clusterColor,
      stroke: false,
      opacity: 0.75,
      fillOpacity: 0.75,
    }).addTo(eye3.map);
    eye3.microClusters.push(p);
  }
}

function renderMacroClusters(result) {
  // Clean up microclusters, then repopulate
  for (i in eye3.macroClusters) {
    eye3.map.removeLayer(eye3.macroClusters[i]);
  }
  eye3.macroClusters = [];
  for (i in result.geojson_clusters.features) {
    let feature = result.geojson_clusters.features[i];
    let props = feature.properties;
    let coords = feature.geometry.coordinates;
    let newcoords = coords;
    if (feature.geometry.type == "MultiPolygon") {
      newcoords = coords.map(function (x) {
        return x.map(function (y) {
          return y.map(function (z) {
            //console.log(`inverting (${z[0]}, ${z[1]}) to (${z[1]}, ${z[0]})`);
            return [z[1], z[0]];
          });
        });
      });
    } else {
      newcoords = coords.map(function (latlon) {
        return [latlon[1], latlon[0]];
      });
    }
    //console.log(`--- Procesando macrocluster ${i} de ${result.geojson_clusters.features.length}`);
    //console.log(newcoords);
    //console.log(feature.geometry);

    let clusterColor = "#ff0000";

    /*
      if ((props.avg_pm100 >= 500) && (props.avg_pm100 < 1700)){
         clusterColor = '#ff0000';
      }
      if ((props.avg_pm100 >= 1700) && (props.avg_pm100 < 3500)){
         clusterColor = '#990033';
      }
      if ((props.avg_pm100 >= 3500) && (props.avg_pm100 < 4000)){
         clusterColor = '#990099';
      }
      */

    newcoords.map(function (c) {
      polygon_coords = c[0];
      let p = L.polygon(polygon_coords, {
        fillColor: clusterColor,
        stroke: false,
        opacity: 0.65,
        fillOpacity: 0.65,
      }).addTo(eye3.map);
      eye3.macroClusters.push(p);
    });
  }
}

function horaHorario() {
  let fecha = new Date();
  let gmt = 0;
  let year = fecha.getFullYear();
  let mes = parseInt(fecha.getMonth() + 1);
  let dia = fecha.getDate();
  let inicio_invierno = year + "-04-03";
  let termino_invierno = year + "-09-04";

  if (mes < 10) {
    mes = `0${mes}`;
  } else {
    mes = `${mes}`;
  }
  if (dia < 10) {
    dia = `0${dia}`;
  } else {
    dia = `${dia}`;
  }
  let fecha_actual = `${year}-${mes}-${dia}`;

  // console.log(fecha_actual);
  // console.log(inicio_invierno);
  // console.log(termino_invierno);
  if (fecha_actual > inicio_invierno && fecha_actual < termino_invierno) {
    console.log("INVIERNO");
    gmt = "GMT-4";
  } else {
    console.log("VERANO");
    gmt = "GMT-3";
  }
  return gmt;
  // console.log(`http://localhost:8000/api/pm100DustRank2/2021-04-10%2015:00:00/2021-04-10%2017:00:00/${gmt}/0.00025/0.0008/10/2/5000/15000/0.00015`);
}
function updateClusters() {
  if (typeof eye3.waiting_for_clusterdata === "undefined") {
    eye3.waiting_for_clusterdata = false;
  }
  if (eye3.waiting_for_clusterdata === true) {
    return;
  }

  eye3.waiting_for_clusterdata = true;

  $.getJSON(
    "https://antucoya.mapa.mine-360.com/api/tablets/pm100_filtrado",
    function (data) {
      console.log("DATA JSON (highPM100): ", data);
      data = data.data;

      // Limpia las capas anteriores de los clusters
      for (let layer of eye3.macroClusters) {
        eye3.map.removeLayer(layer);
      }
      eye3.macroClusters = [];

      if (!data || data.length === 0) {
        eye3.waiting_for_clusterdata = false;
        return;
      }

      let points = data.map((p) => ({
        lat: p.latitude,
        lng: p.longitude,
        pm100: p.pm100,
        visited: false,
      }));

      let route = [];
      let current = points[0];
      current.visited = true;
      route.push(current);

      while (route.length < points.length) {
        let currentLatLng = L.latLng(current.lat, current.lng);
        let nearestPoint = null;
        let minDistance = Infinity;

        points.forEach((p) => {
          if (!p.visited) {
            let candidateLatLng = L.latLng(p.lat, p.lng);
            let d = currentLatLng.distanceTo(candidateLatLng);
            if (d < minDistance) {
              minDistance = d;
              nearestPoint = p;
            }
          }
        });

        if (nearestPoint) {
          nearestPoint.visited = true;
          route.push(nearestPoint);
          current = nearestPoint;
        } else {
          break;
        }
      }

      const maxSegmentDistance = 200;

      // Crear las líneas (polylines) para los puntos
      for (let i = 0; i < route.length - 1; i++) {
        let startPoint = route[i];
        let endPoint = route[i + 1];
        let startLatLng = L.latLng(startPoint.lat, startPoint.lng);
        let endLatLng = L.latLng(endPoint.lat, endPoint.lng);
        let distance = startLatLng.distanceTo(endLatLng);

        if (distance <= maxSegmentDistance) {
          // Determinamos el color y la opacidad basados en PM100
          let color, opacity;
          if (startPoint.pm100 >= 10000) {
            color = "#8B0000"; // Rojo oscuro para alta contaminación
            opacity = 0.2; // Aumentar la transparencia
          } else if (startPoint.pm100 >= 1000) {
            color = "#FF6347"; // Rojo suave para contaminación media
            opacity = 0.1;
          }  

          let latlngs = [
            [startPoint.lat, startPoint.lng],
            [endPoint.lat, endPoint.lng],
          ];

          // Creamos la línea poligonal con un estilo difuso
          let segment = L.polyline(latlngs, {
            color: color,
            opacity: opacity,
            dashArray: "5, 15", // Líneas discontinuas para el efecto de niebla
            lineJoin: "round", // Bordes redondeados para suavizar la apariencia
            lineCap: "round",  // Bordes redondeados para suavizar los extremos
            weight: 15, // Mayor grosor para hacer las líneas más grandes
          }).addTo(eye3.map);

          // Añadir la línea al arreglo de macroClusters para su gestión
          eye3.macroClusters.push(segment);
        }
      }

      eye3.waiting_for_clusterdata = false;
    }
  );
}

// Llamar a la función para actualizar los clusters cada 15 segundos
setInterval(function () {
  updateClusters();
}, 7000);

// Llamar a la función una vez al cargar la página
updateClusters();



function updateMarkers() {
  if (typeof eye3.waiting_for_positiondata == "undefined") {
    eye3.waiting_for_positiondata = false;
  }
  // Este if con (false) se puede quitar o ajustar según convenga.
  if (false) {
    return;
  }
  eye3.waiting_for_positiondata = true;

  $.getJSON(
    "https://antucoya.mapa.mine-360.com/api/vehicles/reg",
    {},
    function (result) {
      // POBLAR MARCADORES EN EL MAPA
      for (var x = 0; x < result.length; x++) {
        if (result[x].vehiculo && result[x].vehiculo.indexOf("REG-") === 0) {
          var regador = result[x];
          if (regador.latitude == null) {
            regador.latitude = 0;
          }
          if (regador.longitude == null) {
            regador.longitude = 0;
          }
          let splitname = regador.vehiculo.split("-")[1];

          if (
            regador.vehiculo != null &&
            regador.latitude != null &&
            regador.longitude != null &&
            typeof eye3.markers[regador.vehiculo] == "undefined"
          ) {
            eye3.markers[regador.vehiculo] = L.marker([
              regador.latitude,
              regador.longitude,
            ]).addTo(eye3.map);
            eye3.markers[regador.vehiculo].setIcon(
              eye3.WaterTruckIcon(splitname, "rgba(75,71,147,0.8)")
            );
          } else {
            if (regador.vehiculo != eye3.vehiculo) {
              eye3.markers[regador.vehiculo].setIcon(
                eye3.WaterTruckIcon(splitname, "rgba(75,71,147,0.8)")
              );
              eye3.markers[regador.vehiculo].setLatLng([
                regador.latitude,
                regador.longitude,
              ]);
            } else {
            }
          }
        }
      }
      eye3.waiting_for_positiondata = false;
    }
  );
}

// Get vehicle position updates every 10 seconds
setInterval(function () {
  updateMarkers();
}, 5000);
updateMarkers();

function updatePolygon(data) {
  //console.log(data);
  layer = eye3.polygon[data.idpoligono];
  if (typeof layer == "undefined") {
    //console.log("updatePolygon(): Cannot find polygon "+ data.idpoligono);
    return;
  }
  eye3.dustMarks.push(layer);
  if (data.tipoevento == 0 || data.tipoevento == 1) {
    if (data.tasaideal == 0) {
      texto = "No regar";
      strokeColor = "#00aa00";
      fillColor = strokeColor;
    }
    if (data.tasaideal == 1) {
      texto = "Riego baja concentración";
      strokeColor = "#ff8c00";
      fillColor = strokeColor;
    }
    if (data.tasaideal == 2) {
      texto = "Riego alta concentración";
      strokeColor = "#ff0000";
      fillColor = strokeColor;
    }
  }

  if (data.tipoevento == 2 || data.tipoevento == 3) {
    strokeColor = "#0000ff";
    fillColor = strokeColor;
  }

  console.log("setting polygon " + data.idpoligono + " to " + fillColor);
  layer.setStyle({
    color: strokeColor,
    fillColor: fillColor,
    fillOpacity: 0.4,
  });
}


function areEndpointsClose(latlngs, tolMeters = 30) {
  if (latlngs.length < 2) return false;
  const a = L.latLng(latlngs[0][0], latlngs[0][1]);
  const b = L.latLng(
    latlngs[latlngs.length - 1][0],
    latlngs[latlngs.length - 1][1]
  );
  return a.distanceTo(b) <= tolMeters;
}

function segmentByDistanceAndTime(
  latlngs,
  times = null,
  maxGapMeters = 200,
  maxGapMs = 10 * 60 * 1000
) {
  const segs = [];
  let cur = [];
  for (let i = 0; i < latlngs.length; i++) {
    const pt = latlngs[i];
    if (!cur.length) {
      cur.push(pt);
      continue;
    }
    const prev = cur[cur.length - 1];
    const d = L.latLng(prev[0], prev[1]).distanceTo(L.latLng(pt[0], pt[1]));
    const tOk =
      !times ||
      (i > 0 && Date.parse(times[i]) - Date.parse(times[i - 1]) <= maxGapMs);
    if (d > maxGapMeters || !tOk) {
      if (cur.length > 1) segs.push(cur);
      cur = [pt];
    } else {
      cur.push(pt);
    }
  }
  if (cur.length > 1) segs.push(cur);
  return segs;
}

// agregando marcadores de riego 20190325
function buscarRiego() {
  if (typeof window.eye3.waiting_for_riego === "undefined") {
    window.eye3.waiting_for_riego = false;
  }
  if (window.eye3.waiting_for_riego) return;
  window.eye3.waiting_for_riego = true;

  $.getJSON("https://antucoya.mapa.mine-360.com/api/riego")
    .done(function (data) {
      eye3.layer["waterLineStrings"].clearLayers();
      if (!Array.isArray(data) || data.length === 0) return;

      // Crear los puntos para riego (círculos)
      const cleaned = data
        .map((d) => ({
          lat: parseFloat(d.latitude),
          lng: parseFloat(d.longitude),
          time: d.time,
        }))
        .filter(
          (d) => Number.isFinite(d.lat) && Number.isFinite(d.lng) && d.time
        );

      cleaned.forEach((d) => {
        L.circleMarker([d.lat, d.lng], {
          radius: 3,
          color: "#0066ff", // Azul para riego
          fillOpacity: 0.5,
          opacity: 0.7,
        }).addTo(eye3.layer["waterLineStrings"]);
      });
    })
    .fail(function (jqxhr, textStatus, error) {
      console.error("Error al cargar riego:", textStatus, error);
    })
    .always(function () {
      window.eye3.waiting_for_riego = false;
    });
}


setInterval(function () {
  buscarRiego();
}, 4000);
buscarRiego();

let socketio_server_url = `http://${window.location.href.split("/")[2]}:8080`;
console.log(
  `WENASHORO: socketio_server_url resolves to [${socketio_server_url}]`
);
var socket = io.connect(socketio_server_url, {
  transports: ["websocket"],
});

socket.on("connect", () => {
  console.log("connected!");
  let connection_status = socket.connected;
  let user_id = socket.id;
  console.log("socket.io connected, user_id: " + user_id);
});

setInterval(function () {
  var present = new Date(Date.now());
  if (typeof window.last_message_timestamp == "undefined") {
    window.last_message_timestamp = new Date(Date.now());
  }
  var last = window.last_message_timestamp;
  var count = (present - last) / 1000;
  if (count > 20) {
    console.log("Reiniciando App luego de " + count);
    AndroidFunction.killToast("Reiniciando App luego de " + count);
  } else {
    console.log("Tiempo incomunicado: " + count);
    //AndroidFunction.showToast("Tiempo incomunicado: " + count);
  }
}, 1000);

// socket.on("regador", data => {
//    window.last_message_timestamp = new Date(Date.now());
//    data = JSON.parse(data);
//    eye3.vehicle = data.vehicle;
//    console.log(JSON.stringify(data));
//    $("#svg-dashboard").html(dashboardSVG(data.manual,data.segmented,data.ltr,data.ltc,data.rtc,data.rtr, data.danger, data.infraccion_segmentado, data.infraccion_velocidad_max, data.m_reg, data.m_seco, data.zona_no_regar, data.infraccion_no_regar, data.zona_riego_continuo, data.zona_str, data.limite_velocidad_max, data.limite_velocidad_min, data.infraccion_velocidad_min, data.tratamiento, data.infraccion_aspersores_centrales, data.infraccion_aspersores_laterales, data.aspersores_laterales_str, data.aspersores_centrales_str));

//    let new_gps_timestamp = new Date();
//    if ((new_gps_timestamp.getTime() - eye3.last_gps_timestamp) > eye3.map_center_update_interval_ms){
//       eye3.last_gps_timestamp = new_gps_timestamp.getTime();

//       console.log("moving map to "+ data.lat +","+ data.lon);
//       eye3.map.setView([parseFloat(data.lat),parseFloat(data.lon)], eye3.map.getZoom(), {animation: true});
//    } else {
//       console.log("Too soon for map re-centering");
//    }

//    // Update truck marker
//    if (typeof(eye3.markers[data.vehicle]) == "undefined"){
//       console.log("No existe marcador para "+ data.vehicle +". Creando ahora en ["+ data.lat +", "+ data.lon +"]");
//       eye3.markers[data.vehicle] = L.marker([data.lat, data.lon]).addTo(eye3.map);
//       eye3.markers[data.vehicle].setIcon(eye3.WaterTruckIcon(data.name, "rgba(75,71,147,0.8)"));
//       //eye3.markers[regador.id].setIcon(eye3.HaulTruckIcon(10));
//    } else {
//          eye3.markers[data.vehicle].setIcon(eye3.WaterTruckIcon(data.name, "rgba(75,71,147,0.8)"));
//          eye3.markers[data.vehicle].setLatLng([data.lat, data.lon]);
//    }
// });

setInterval(function () {
  $.getJSON("/estado", function (data) {
    console.log(data);
    eye3.vehicle = data.vehicle;
    console.log(JSON.stringify(data));
    // $("#svg-dashboard").html(dashboardSVG(data.manual,data.segmented,data.ltr,data.ltc,data.rtc,data.rtr, data.danger, data.infraccion_segmentado, data.infraccion_velocidad_max, data.m_reg, data.m_seco, data.zona_no_regar, data.infraccion_no_regar, data.zona_riego_continuo, data.zona_str, data.limite_velocidad_max, data.limite_velocidad_min, data.infraccion_velocidad_min, data.tratamiento, data.infraccion_aspersores_centrales, data.infraccion_aspersores_laterales, data.aspersores_laterales_str, data.aspersores_centrales_str));

    let new_gps_timestamp = new Date();
    if (
      new_gps_timestamp.getTime() - eye3.last_gps_timestamp >
      eye3.map_center_update_interval_ms
    ) {
      eye3.last_gps_timestamp = new_gps_timestamp.getTime();

      console.log("moving map to " + data.lat + "," + data.lon);
      eye3.map.setView(
        [parseFloat(data.lat), parseFloat(data.lon)],
        eye3.map.getZoom(),
        { animation: true }
      );
    } else {
      console.log("Too soon for map re-centering");
    }

    // Update truck marker
    if (typeof eye3.markers[data.vehicle] == "undefined") {
      console.log(
        "No existe marcador para " +
          data.vehicle +
          ". Creando ahora en [" +
          data.lat +
          ", " +
          data.lon +
          "]"
      );
      eye3.markers[data.vehicle] = L.marker([data.lat, data.lon]).addTo(
        eye3.map
      );
      eye3.markers[data.vehicle].setIcon(
        eye3.WaterTruckIcon(data.name, "rgba(75,71,147,0.8)")
      );
      //eye3.markers[regador.id].setIcon(eye3.HaulTruckIcon(10));
    } else {
      eye3.markers[data.vehicle].setIcon(
        eye3.WaterTruckIcon(data.name, "rgba(75,71,147,0.8)")
      );
      eye3.markers[data.vehicle].setLatLng([data.lat, data.lon]);
    }
  });
}, 3000); // every 3 seconds

// Quitando los controles de zoom en el mapa
$(".leaflet-control-zoom").hide();
