import paho.mqtt.client as mqtt_client
import json
from time import sleep, time
from utils import Utils
utils = Utils(log_id= "CLIENT_MQTT")

# MQTT
username = "SkyMine"
password = "SkyMining2025*"
broker = "mqtt.produccion.mine-360.com"
port = 1883

# MACHINE NAME, ID, FAENA, FAENA-UBICACION
MACHINENAME = utils.get_product_name()
MACHINEID = utils.get_product_id()
#FAENA = utils.get_faena_assigned()
FAENA = "Antucoya"
FAENA_UBICACION = utils.get_location_assigned()

BUTTON_STATE_PATH = "/srv/datalogger_tablet/server_cachimba/Antucoya_html/button_state.json"

# TOPIC
PUB_TOPIC = f"{FAENA}/dataloggers/cachimba/{FAENA_UBICACION}/{MACHINENAME}"
SUB_TOPIC = f"{FAENA}/dataloggers/cachimba/{FAENA_UBICACION}/{MACHINENAME}/response"
RECV_MSG = ""

# data = {
# "cargar_agua": False,
# "cargar_sulf": False,
# "time": 12334434
# }

# Metodo para conectarse al broker
def connect():
    # Inicializar cliente MQTT
    client = mqtt_client.Client()
    client.username_pw_set(username, password)
    client.on_connect = on_connect
    client.on_message = on_message

    # Conectar al broker MQTT
    client.connect(broker, port, 60)

    # Bucle de espera de mensajes
    client.loop_start()
    sleep(1)

    return client



# Metodo para puclicar al topico
def publish(client, topic, dict_data):
    success = False
    try:
        (rc, mid) = client.publish(topic, json.dumps(dict_data), qos=1)
        if rc != 0:
            print(f"Error al enviar mensaje con codigo de error {rc}")
        else:
            print("Mensaje enviado")
            success = True
            
    except Exception as Ex:
        print(Ex)
    
    return success


# Metodo de callback cuando se recibe un mensaje MQTT
def on_message(client, userdata, msg):
    global RECV_MSG
    try:
        topic = msg.topic
        payload = msg.payload.decode()
        print(f"Mensaje recibido en {topic}: {payload}")
        RECV_MSG = payload
    except Exception as e:
        print(f"Error en el procesamiento del mensaje MQTT: {e}")


# Metodo de conexión MQTT
def on_connect(client, userdata, flags, rc):
    if rc == 0:
        print("Conexión exitosa al broker MQTT")
    else:
        print(f"Error al conectar, código de error: {rc}")


# Metodo para obtener la respuesta del server al publicar un dato    
def get_response(wait = 5):
    global RECV_MSG
    try:
        ts = time()
        while time()-ts<wait:
            if RECV_MSG:
                msg = json.loads(RECV_MSG)
                RECV_MSG = ""
                return msg
    except Exception as e:
        print(f"Error al obtener la respuesta: {e}")
    return RECV_MSG

# Metodo para hacer un check si mqtt aun sigue conectado         
def is_alive(client):
    if client:
        if client.is_connected(): return True
    return False


def send_data(dict_data, client):
    success = False
    try:
        client.subscribe(SUB_TOPIC)
        result = publish(client= client, topic=PUB_TOPIC, dict_data=dict_data)
        if result:
            res = get_response(wait=5)
            if res["time"] == dict_data["time"]: 
                print("Mensaje enviado con exito")
                success = True
            else: 
                print("No hay respuesta del server")

    except Exception as e:
        print(f"Error al obtener la respuesta: {e}")

    return success


def run():
    client = connect()
    f = open(BUTTON_STATE_PATH)
    previous_data = json.load(f)
    while True:
        try:
            # 1. Check file
            #print("Check data")
            f = open(BUTTON_STATE_PATH)
            current_data:dict = json.load(f)
            
            # 2. If file change, send data
            if current_data and previous_data!= current_data:
                utils.log(f"Intentando enviar data {current_data}")
                if client.is_connected():
                    if send_data(current_data, client):
                        # Solo si se envió con exito actualizar previous data.
                        previous_data = current_data 
                else:
                    # Conectar client si no esta conectado y esperar 3 segundos para no saturar el server
                    client = connect()
                    sleep(3)
                
        except Exception as e:
            print(f"Error al obtener la respuesta: {e}")
        sleep(0.3)


if __name__ == '__main__':
    run()
