#!/bin/bash

SERVICE_NAME="mining-local-mqtt-client"
SERVICE_FILE="${SERVICE_NAME}.service"
SERVICE_SRC="/srv/datalogger_tablet/server_cachimba/local_client_mqtt_data/$SERVICE_FILE"
SERVICE_DST="/etc/systemd/system/$SERVICE_FILE"

echo "== Instalando servicio $SERVICE_NAME =="

# Detener y deshabilitar el servicio si existe
echo "→ Deteniendo y deshabilitando servicio anterior (si existe)..."
systemctl stop $SERVICE_NAME 2>/dev/null
systemctl disable $SERVICE_NAME 2>/dev/null

# Eliminar servicio anterior
echo "→ Eliminando servicio anterior..."
rm -f $SERVICE_DST

# Copiar nuevo archivo de servicio
echo "→ Copiando archivo de servicio..."
cp "$SERVICE_SRC" "$SERVICE_DST"

# Recargar systemd y habilitar servicio
echo "→ Recargando systemd, habilitando y reiniciando servicio..."
systemctl daemon-reexec
systemctl daemon-reload
systemctl enable $SERVICE_NAME
systemctl restart $SERVICE_NAME

echo "Servicio '$SERVICE_NAME' instalado y ejecutándose."
