#!/bin/bash

SERVICE_NAME="mining-local-mqtt-client"
SERVICE_FILE="${SERVICE_NAME}.service"
SERVICE_DST="/etc/systemd/system/$SERVICE_FILE"

echo "== Desinstalando servicio $SERVICE_NAME =="

# Detener y deshabilitar el servicio si existe
echo "→ Deteniendo y deshabilitando servicio..."
systemctl stop $SERVICE_NAME 2>/dev/null
systemctl disable $SERVICE_NAME 2>/dev/null

# Eliminar archivo de servicio
echo "→ Eliminando archivo de servicio..."
rm -f "$SERVICE_DST"

# Recargar systemd
echo "→ Recargando systemd..."
systemctl daemon-reload

echo "Servicio '$SERVICE_NAME' desinstalado."
