#!/bin/bash

set -e  # Detener si hay error

# Variables
ARCHIVO_TAR="mediamtx_v1.12.3_linux_armv7.tar.gz"
URL="https://github.com/bluenviron/mediamtx/releases/download/v1.12.3/$ARCHIVO_TAR"
BASE_DIR="/srv/datalogger_tablet/server_cachimba"
DEST_DIR="$BASE_DIR/mediamtx"
SERVICE_NAME="mediamtx_local.service"
SERVICE_SRC="$(dirname "$0")/$SERVICE_NAME"
SERVICE_DEST="/etc/systemd/system/$SERVICE_NAME"

echo "[INFO] Preparando directorio destino: $DEST_DIR"
mkdir -p "$DEST_DIR"

echo "[INFO] Eliminando binarios anteriores (pero conservando scripts y servicios)..."
find "$DEST_DIR" -type f \( -name "mediamtx" -o -name "*.tar.gz" \) -delete

echo "[INFO] Descargando MediaMTX..."
wget -O "$DEST_DIR/$ARCHIVO_TAR" "$URL"

echo "[INFO] Descomprimiendo en $DEST_DIR..."
tar -xvzf "$DEST_DIR/$ARCHIVO_TAR" -C "$DEST_DIR"
rm "$DEST_DIR/$ARCHIVO_TAR"
chmod +x "$DEST_DIR/mediamtx"

echo "[INFO] Verificando si ya existe la entrada 'local_cachimba' en mediamtx.yml..."
if ! grep -q "^  local_cachimba:" "$DEST_DIR/mediamtx.yml"; then
  echo "[INFO] Insertando configuración de 'local_cachimba' en mediamtx.yml..."
  sed -i '/^[[:space:]]*all_others:/i\
  local_cachimba:\
     source: rtsp://admin:mining2015@192.168.2.120:554/Streaming/Channels/201\
' "$DEST_DIR/mediamtx.yml"
else
  echo "[INFO] La entrada 'local_cachimba' ya existe. No se modifica."
fi

echo "[INFO] Instalando servicio systemd..."
if [ ! -f "$SERVICE_SRC" ]; then
  echo "[ERROR] No se encontró el archivo de servicio: $SERVICE_SRC"
  exit 1
fi

cp "$SERVICE_SRC" "$SERVICE_DEST"

echo "[INFO] Recargando systemd y activando el servicio..."
systemctl daemon-reexec
systemctl daemon-reload
systemctl enable "$SERVICE_NAME"
systemctl restart "$SERVICE_NAME"

echo "[OK] Instalación completa. Estado del servicio:"
systemctl status "$SERVICE_NAME" --no-pager
