#!/bin/bash

set -e  # Detener si hay error

# Variables
SERVICE_NAME="mediamtx_local.service"
SERVICE_PATH="/etc/systemd/system/$SERVICE_NAME"
INSTALL_DIR="/srv/mmr_cachimba/mediamtx"

echo "[INFO] Deteniendo servicio si está activo..."
if systemctl is-active --quiet "$SERVICE_NAME"; then
  systemctl stop "$SERVICE_NAME"
  echo "[INFO] Servicio detenido."
else
  echo "[INFO] El servicio no estaba activo."
fi

echo "[INFO] Deshabilitando servicio..."
if systemctl is-enabled --quiet "$SERVICE_NAME"; then
  systemctl disable "$SERVICE_NAME"
  echo "[INFO] Servicio deshabilitado."
else
  echo "[INFO] El servicio ya estaba deshabilitado."
fi

if [ -f "$SERVICE_PATH" ]; then
  echo "[INFO] Eliminando archivo del servicio: $SERVICE_PATH"
  rm "$SERVICE_PATH"
else
  echo "[INFO] El archivo del servicio ya no existe."
fi

echo "[INFO] Recargando systemd para aplicar cambios..."
systemctl daemon-reexec
systemctl daemon-reload

if [ -d "$INSTALL_DIR" ]; then
  echo "[INFO] Eliminando carpeta de instalación: $INSTALL_DIR"
  rm -rf "$INSTALL_DIR"
else
  echo "[INFO] La carpeta ya no existe."
fi

echo "[OK] Desinstalación completa. Verificación:"
if systemctl status "$SERVICE_NAME" > /dev/null 2>&1; then
  echo "[WARN] El servicio aún aparece registrado."
else
  echo "[OK] El servicio fue eliminado correctamente."
fi
