import json
from time import sleep, time
from utils import Utils
import subprocess
import threading
utils = Utils(log_id= "NETWORK")
class App:
    def __init__(self):
        utils.log('Iniciando monitoreo de conexion a cachimba')
        try:
            with open("/srv/mmr_cachimba/network/network.json", "r") as archivo_json:
                self.dict = json.load(archivo_json)
            try:
                a = self.dict['id_mmr']
            except: self.dict['id_mmr'] = 'REG-XXX'
        except:
            self.dict = {'network': False, 'id_mmr': 'REG-XXX'}

        self.hilo_rf = threading.Thread(target=self.run_rf)
        self.hilo_rf.start()

        sleep(1)

        self.hilo_net = threading.Thread(target=self.run_net)
        self.hilo_net.start()

        self.run_save()

    def run_save(self):
        while True:
            try:
                with open("/srv/datalogger_tablet/server_cachimba/network/network.json", "w") as archivo_json:
                    json.dump(self.dict, archivo_json, indent=4)
                with open("/srv/datalogger_tablet/server_cachimba/Antucoya_html/network.json", "w") as archivo_json:
                    json.dump(self.dict, archivo_json, indent=4)
            except: pass
            sleep(1)

    def run_net(self):
        while True:
            try:
                # 1. Check Network
                out = subprocess.check_output(['ping','-c','3','192.168.2.1'])
                if self.dict['network'] == False:
                    utils.log('Conectado a Cachimba por WIFI')
                    self.dict['network'] = True
                sleep(1)
            except:
                if self.dict['network'] == True:
                    utils.log('Desconectado de Cachimba por WIFI')
                    self.dict['network'] = False
                sleep(1)

    def run_rf(self):
        while True:
            try:
                out = subprocess.check_output(['topic'])
                out_dec = out.decode().replace('\n','')
                out_dict = json.loads(out_dec)
                reg = out_dict['topic'].split('/')[-2]
                if reg=='REG-01':
                    self.dict['id_mmr']='REG-001'
                if reg=='REG-02':
                    self.dict['id_mmr']='REG-002'
                if reg=='REG-03':
                    self.dict['id_mmr']='REG-003'
                if reg=='STGO':
                    self.dict['id_mmr']='REG-XXX'
                utils.log('Este es el aljibe: '+self.dict['id_mmr'])
            except: pass
            sleep(10)

if __name__ == '__main__':
    mining = App()
