# Documentación de Actualización del Sistema MMR – Backend Flask + Tablet

## 1. Información General

Este documento describe la nueva arquitectura del servicio Flask utilizado en las tablets MMR para mostrar información del regador en tiempo real (nivel, volumen, velocidad, título dinámico y geofence).  
Incluye:

- Descripción del funcionamiento
- Detalle de archivos utilizados por la tablet
- Explicación del nuevo sistema `load_config_hot()` (recarga dinámica del JSON)
- Instalación del nuevo backend
- Cambios que deben hacerse en la tablet
- Comandos git recomendados
- Librerías necesarias

Los cambios realizados en esta iteración incluyen: 
- Estandarizar etiquetas: Tamaño de fuente y centrado.
- Pasar configuraciones a script de python para que se cree el json.
- Agregar configuración de lat y lon inicial, segun faena. 
- Agregar lectura de geofence segun el path:  "/srv/datalogger_mmr/geofence.json"
- Agregar que se muestre en regador y faena en la pestaña del navegador.
- Mostrar etiquetas según la configuración: show_volume y show_level

---

## 2. Funcionamiento del Sistema

La tablet utiliza un backend en Flask que expone varias rutas API:

| Ruta | Descripción |
|------|-------------|
| `/config` | Configuración de tablet desde `Config_mmr.json` |
| `/nivel` | Nivel del estanque del regador actual |
| `/volumen` | Volumen acumulado del regador actual |
| `/data` | Data general del regador (ID, nombre, timestamp, etc.) |
| `/reiniciar_contador` | Reinicia el contador de volumen (botón) |
| `/` | Página principal del visor HTML |

### 2.1 Archivos involucrados

Todos se leen desde el directorio raìz:

- **`data.json`** → Información del regador actual  
```bash
{
    "name": '016', 
    "vehicle": 1091, 
    "lat": -27.503644, 
    "lon": -70.282146, 
    "timestamp": 1760922689
}
```

- **`nivel.json`** → Nivel del estanque  
```bash
{
    "porcentaje": 49,
    "volumen_estanque": 35,
    "timestamp": 728738738273,
    "button": true
}
```

- **`volumen_acumulado.json`** → Volumen acumulado  
```bash
{
    "volumen": 9534,
    "timestamp": 728738738273
}
```

- **`Config_mmr.json`** → Configuración actual del MMR generada por `/srv/datalogger_mmr/config.py`
```bash
Ejemplo en la sección 4.1
```

### 2.2 Sistema de Recarga Dinámica (`load_config_hot()`)

El backend cuenta con un método inteligente:

```python
def load_config_hot():
    # Carga Config_mmr.json solo si el archivo cambió en disco
```

Beneficios:

- La tablet **no necesita reiniciarse**
- Los valores `SHOW_LEVEL`, `SHOW_VOLUME`, `TITLE`, APIs, etc. se toman **en tiempo real**
- Evita cacheos en memoria
- Detecta cambios por comparación del `mtime` del archivo

---

## 3. Instalación del Nuevo Backend en la Tablet

### 3.1 Requisitos

Instalar las librerías necesarias:

```bash
pip install flask flask-cors
```

Para asegurar compatibilidad:

```bash
pip install --upgrade pip setuptools
```
### 3.2 Github

Hasta el desarrollo de este documento, el código actualizado se encuentra en el repo __dataloger_mmr__ dentro de la rama __feature/one_config_mmr_json__ 

- https://github.com/desarrollomining/datalogger_mmr/tree/feature/one_config_mmr_json


### Actualizar el Proyecto

Dependiendo de la funcionalidad actualizada:  
- index.html (Para el mapa front)
- main.py (server, para cualquier actualización del lado del server)
- cards.js, button.js, map.js (Para actualizaciones de los botones, del mapa o de las cartas de velocidad, volumen, etc)
- __main_.py en la configuracion del mmr (/srv/datalogger_mmr/)


### 3.3 Verificar estructura de carpetas

Debe existir:

```
    static/
        css/
        img/
        js/
            cards.js
            map.js
            buttons.js
    templates/
        index.html
    main.py
    nivel.json
    data.json
    volumen_acumulado.json
```
Y a su vez, en la ruta __/srv/datalogger_mmr/__:

```
    geofence.json
    config_mmr.json
```

### 3.4 Ejecutar el servidor Flask manualmente para pruebas

```bash
python3 main.py
```

## 4. Cambios en el MMR (Backend /srv/datalogger_mmr/)

### 4.1 Script de configuración

El archivo:

```
/srv/datalogger_mmr/config.py
```

Genera y actualiza automáticamente:

- `Config_mmr.json`
- `geofence.json`

La nueva clave dentro de config es `"TABLET"`: Ejemplo (Deberá  configurarse automáticamente por Faena) 

```json
"TABLET": {
                "MAX_CISTERN_LEVEL": 70,
                "MODEL_SENSOR_LEVEL": "",
                "SHOW_LEVEL": false,
                "SHOW_VOLUME": false,
                "X_COORD":-27.519101,
                "Y_COORD":-70.289366,
                "API_URL_REG": "https://candelaria.mapa.mine-360.com/api/vehicles/reg",
                "API_PM100_FILTRADO": "https://candelaria.mapa.mine-360.com/api/tablets/pm100_filtrado",
                "API_RIEGO": "https://candelaria.mapa.mine-360.com/api/riego",
                "GEOFENCE_PATH": "/srv/datalogger_mmr/geofence.json",
                "TITLE": "Candelaria"
                
        }
```

---


## Resumen

El nuevo backend permite:

- Actualización en caliente del archivo `Config_mmr.json`
- HUD dinámico sin reinicios
- Soporte completo para APIs, geofence y parámetros del MMR
- Código más robusto, escalable y mantenible

Este documento recoge tanto la descripción técnica como las instrucciones operativas para asegurar la correcta ejecución del sistema en todas las tablets.
