//////////// Reinicio contador boton
      function reiniciarContador() {
        console.log("Contador de nivel reiniciado");

        const timestamp = new Date().toISOString();
        console.log("Timestamp actual:", timestamp);

        fetch("/reiniciar_contador", {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify({ timestamp }),
        })
          .then((response) => {
            if (!response.ok) {
              throw new Error(
                "Error en la respuesta del servidor: " + response.status
              );
            }
            return response.json();
          })
          .then((data) => {
            console.log("Estado actualizado en el servidor:", data);
             mostrarPopup("✅ Contador reiniciado correctamente");
          })
          .catch((error) => {
            console.error("Error al actualizar el estado:", error);
            mostrarPopup("❌ Error al reiniciar el contador", true);
          });
      }
      /* -------- Popup bonito -------- */
      function mostrarPopup(mensaje, esError = false) {
        // Crear elemento popup
        const popup = document.createElement("div");
        popup.className = "popup-mensaje " + (esError ? "error" : "exito");
        popup.textContent = mensaje;
        document.body.appendChild(popup);

        // Mostrar con animación
        setTimeout(() => popup.classList.add("visible"), 100);

        // Ocultar automáticamente después de 3 segundos
        setTimeout(() => {
          popup.classList.remove("visible");
          setTimeout(() => popup.remove(), 500);
        }, 3000);
      }