// Prototyped at https://jsfiddle.net/kthxbyte/2a17qL85/2/
function ColorSVGMarker(name,color){
	return encodeURI('data:image/svg+xml;base64,'+window.btoa('<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" \
xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" \
width="105px" height="60px" viewBox="0 0 105 60" enable-background="new 0 0 200 100" xml:space="preserve"> \
<rect x="32" y="30" fill="'+ color +'" width="40" height="20" transform="translate(-10 -30)"/> \
<path x="-10" fill="none" stroke="'+ color +'" stroke-width="2" d="M 14.86969785011496 25.904610688211378 A 15 15 0 1 0 20 25"> \
<animateTransform  type="rotate" fill="remove" dur="2s" additive="replace" calcMode="linear" restart="always" from="0 20 40" \
attributeName="transform" to="360 20 40" attributeType="xml" repeatCount="indefinite"></animateTransform></path> \
// <line fill="none" stroke="'+ color +'" x1="45" y1="55" x2="60" y2="40" transform="translate(-10 -30)"/> \
<line fill="none" stroke="'+ color +'" x1="60" y1="40" x2="67" y2="40" transform="translate(-10 -30)"/> \
<text transform="matrix(1 0 0 1 29 15)" fill="#FFFFFF" font-family="Arial,Open Sans, Sans" font-weight="bold" font-size="14">'+ name +'</text> \
<circle fill="'+ color +'" cx="0" cy="0" r="7.468" transform="translate(20 40)"> \
<animateTransform attributeType="xml" attributeName="transform" type="scale" from="1 1" \
to="0.6 0.6" additive="sum" repeatCount="indefinite" dur="0.5s" fill="freeze"/> \
</circle></svg>'));
}
        
       
//[-22.89050213578712,-69.318655712085629]
function dashboardSVG(manual, segmented, ltr, ltc, rtc, rtr, danger, infraccion_segmentado, infraccion_velocidad, m_reg, m_seco, zona_no_regar, infraccion_no_regar, zona_riego_continuo, zona_str, limite_velocidad, limite_velocidad_min, infraccion_velocidad_min, tratamiento, infraccion_aspersores_centrales, infraccion_aspersores_laterales, aspersores_laterales_str, aspersores_centrales_str){
   color_water = "#0082ff";
   color_gray  = "#cccccc";
   color_white = "#ffffff";
   color_black = "#000000";
   transparent = "transparent";
   ltr_color = color_gray;
   ltc_color = color_gray;
   rtr_color = color_gray;
   rtc_color = color_gray;

   opacity_manual = 0;
   opacity_auto = 1;
   opacity_segmented = 0;
   opacity_continuous = 1;
   opacity_background = 0.75;

   if (manual == true) {
      text_type = "MANUAL";
   } else {
      text_type = "AUTO";
      opacity_manual = 0;
      opacity_auto = 1;
      if (segmented == true){
         opacity_segmented = 1;
         opacity_continuous = 0;
      } else {
         opacity_segmented = 0;
         opacity_continuous = 1;
      }  
   }

   if (infraccion_aspersores_centrales){ max_color_central = "red" }else{ max_color_central = color_gray}
   if (infraccion_aspersores_laterales){ max_color_lateral = "red" }else{ max_color_lateral = color_gray}
   
   if (infraccion_segmentado){ color_arrow = "red" }else{ color_arrow = color_gray}
   if (infraccion_velocidad){color_speed = "red"}else{color_speed = color_gray}
   if (infraccion_velocidad_min){color_speed_min = "red"}else{color_speed_min = color_gray}
   if (danger){ identify = "infoPanel"; }else{ identify = "none"; }
   if (infraccion_no_regar) {color_no_regar = "red";}else{color_no_regar = color_gray;}
   if (zona_no_regar) { opacity_segmentado = 0; opacity_no_regar =1; opacity_riego_continuo = 0;}else{opacity_segmentado = 1; opacity_no_regar = 0; opacity_riego_continuo = 0;}
   if (zona_riego_continuo) { opacity_riego_continuo = 1;  opacity_segmentado = 0; opacity_no_regar = 0;  }

   // if (ltr == true){ ltr_color = color_water; }else{ ltr_color = color_gray}
   // if (ltc == true){ ltc_color = color_water; }else{ ltc_color = color_gray}
   // if (rtr == true){ rtr_color = color_water; }else{ rtr_color = color_gray}
   // if (rtc == true){ rtc_color = color_water; }else{ rtc_color = color_gray}

   if (ltr == 0){ ltr_color = transparent; }else if(ltr == 1){ ltr_color = color_gray}else if(ltr == 2){ ltr_color = color_water }else if(ltr == 3){ltr_color = "red"}
   if (ltc == 0){ ltc_color = transparent; }else if(ltc == 1){ ltc_color = color_gray}else if(ltc == 2){ ltc_color = color_water }else if(ltc == 3){ltc_color = "red"}
   if (rtr == 0){ rtr_color = transparent; }else if(rtr == 1){ rtr_color = color_gray}else if(rtr == 2){ rtr_color = color_water }else if(rtr == 3){rtr_color = "red"}
   if (rtc == 0){ rtc_color = transparent; }else if(rtc == 1){ rtc_color = color_gray}else if(rtc == 2){ rtc_color = color_water }else if(rtc == 3){rtc_color = "red"}

   let max_asp_centrales = 0;
   let max_asp_laterales = 0;
   if (ltr == 1 | ltr == 2) { max_asp_laterales = max_asp_laterales + 1; }
   if (rtr == 1 | rtr == 2) { max_asp_laterales = max_asp_laterales + 1; }
   if (ltc == 1 | ltc == 2) { max_asp_centrales = max_asp_centrales + 1; }
   if (rtc == 1 | rtc == 2) { max_asp_centrales = max_asp_centrales + 1; }

   return [
      '<div class="contenedor" id='+identify+'>'+
      
      '<div class="contenedor1" id="contenedorAspersor"> '+
        '<div class="contenedorTitulo"> '+
            '<span class="styleTitulo">Aspersor</span></div> '+
        '<div class=""> '+
            '<div class="contenedor-Aspersor" id="marginTopAsp"> '+
                '<div class="styleTituloAspe" > '+
                    '<small >CENTRALES</small> '+
                    '<span class="styleMax" style="color:'+max_color_central+';"> '+aspersores_centrales_str+'</span> '+
                '</div> '+
                '<div class="aspContenido"> '+
                    '<div class="aspersorVacio" > '+
                    '</div> '+
                    '<div class="aspersor" style="background-color:'+rtc_color+';"> '+
                        '<div class="img-asp"> '+
                            '<img src="img/asp.png" alt="Smiley face" height="30" width="40"> '+
                        '</div> '+
                        '<div class="nombre-asp">RTC</div> '+
                    '</div> '+
                    '<div class="aspersor" style="background-color:'+ltc_color+';"> '+
                        '<div class="img-asp"> '+
                            '<img src="img/asp.png" alt="Smiley face" height="30" width="40"> '+
                        '</div> '+
                        '<div class="nombre-asp">LTC</div> '+
                    '</div> '+
                '</div> '+
            '</div> '+

            '<div class="contenedor-Aspersor" id="marginTopAsp"> '+
                '<div class="styleTituloAspe"  > '+
                    '<small >LATERALES</small> '+
                    '<span class="styleMax" style="color:'+max_color_lateral+';"> '+aspersores_laterales_str+'</span> '+
                '</div> '+
                '<div class="aspContenido"> '+
                    '<div class="aspersor" style="background-color:'+rtr_color+';"> '+
                        '<div class="img-asp"> '+
                            '<img src="img/asp.png" alt="Smiley face"  height="30" width="40"> '+
                        '</div> '+
                        '<div class="nombre-asp">RTR</div> '+
                    '</div> '+
                   '<div class="aspersorVacio" > '+

                    '</div> '+
                    '<div class="aspersorVacio" > '+

                    '</div> '+
                    '<div class="aspersor" style="background-color:'+ltr_color+';"> '+
                        '<div class="img-asp"> '+
                            '<img src="img/asp.png" alt="Smiley face"  height="30" width="40"> '+
                        '</div> '+
                        '<div class="nombre-asp">LTR '+
                        '</div> '+
                    '</div> '+
               '</div> '+
            '</div> '+
        '</div> '+
    '</div> '+


			'<div class="contenedor1" id="heightTipoRiego">'+
					'<div class="contenedorTitulo" >'+
							'<span class="styleTitulo">Tipo Riego</span></div>'+
		'<div class="" >'+
         '<div class="colDiv">'+
                '<div class="contenedorTitulo">'+
                    '<div class="styleZona">'+text_type+'</div>'+
               '</div>'+
            '</div>'+
			'<div class="contenedor-Aspersor" id="contenedorTipoRiegoSeg">'+
               '<div class="contenedor-flecha" style="opacity: '+opacity_segmentado+'">'+
                  
							'<div class="img-asp" id="marginTipoRiego">'+
                        
                        '<svg version="1.0" xmlns="http://www.w3.org/2000/svg"'+
                             'width="90px" height="120px" viewBox="0 0 1280.000000 1280.000000"'+
                             'preserveAspectRatio="xMidYMid meet">'+
                            '<metadata>'+
                              '  Created by potrace 1.15, written by Peter Selinger 2001-2017 '+
                            '</metadata>'+

                            '<g transform="translate(0.000000,1280.000000) scale(0.100000,-0.100000)" '+
                              'fill='+color_arrow+' stroke="none"> '+
                              '<path d="M7318 10295 l-3 -1090 -2817 -3 -2818 -2 0 -2430 0 -2430 2820 0 '+
                              ' 2820 0 2 -1088 3 -1088 2175 2303 c1196 1266 2174 2305 2173 2308 -1 4 -107 '+
                              ' 117 -235 253 -129 136 -1081 1145 -2117 2242 -1036 1097 -1910 2022 -1942 '+
                              ' 2055 l-59 60 -2 -1090z"/>'+
                            '</g>'+
                            '<text x="300" y="750" font-family="Verdana" font-size="350px" fill="#ffffff">'+m_reg+'</text>'+
                        '</svg>'+
                        
							'</div>'+
					'</div>'+
			'<div class="contenedor-flecha" style="opacity: '+opacity_segmentado+'">'+
					'<div class="style-reg">'+
						m_seco+
					'</div>'+
			'</div>'+
			'<div class="contenedor-flecha" style="opacity: '+opacity_segmentado+'">'+
					'<div class="img-asp">'+
                  '<svg version="1.0" xmlns="http://www.w3.org/2000/svg"'+
                        'width="90px"  height="120px" viewBox="0 0 1280.000000 1280.000000"'+
                        'preserveAspectRatio="xMidYMid meet">'+
                        '<metadata>'+
                        'Created by potrace 1.15, written by Peter Selinger 2001-2017 '+
                        '</metadata>'+
                        
                        '<g transform="translate(0.000000,1280.000000) scale(0.100000,-0.100000)" '+
                        'fill='+color_arrow+' stroke="none"> '+
                        '<path d="M7318 10295 l-3 -1090 -2817 -3 -2818 -2 0 -2430 0 -2430 2820 0 '+
                        '2820 0 2 -1088 3 -1088 2175 2303 c1196 1266 2174 2305 2173 2308 -1 4 -107 '+
                        '117 -235 253 -129 136 -1081 1145 -2117 2242 -1036 1097 -1910 2022 -1942 '+
                        '2055 l-59 60 -2 -1090z"/> '+
                        '</g>'+
                        '<text x="300" y="750" font-family="Verdana" font-size="350px" fill="#ffffff">'+m_reg+'</text>'+
                        '</svg>'+

					'</div>'+
			'</div>'+
			'<div class="contenedor-flecha" style="opacity: '+opacity_segmentado+'">'+
					'<div class="style-reg">'+
                  m_seco+
					'</div>'+
			'</div>'+
			'<div class="contenedor-flecha" style="opacity: '+opacity_segmentado+'">'+
					'<div class="img-asp">'+
                        '<svg version="1.0" xmlns="http://www.w3.org/2000/svg"'+
                        'width="90px"  height="120px" viewBox="0 0 1280.000000 1280.000000"'+
                        'preserveAspectRatio="xMidYMid meet">'+
                        '<metadata>'+
                        'Created by potrace 1.15, written by Peter Selinger 2001-2017 '+
                        '</metadata>'+
                        
                        '<g transform="translate(0.000000,1280.000000) scale(0.100000,-0.100000)" '+
                        'fill='+color_arrow+' stroke="none"> '+
                        '<path d="M7318 10295 l-3 -1090 -2817 -3 -2818 -2 0 -2430 0 -2430 2820 0 '+
                        '2820 0 2 -1088 3 -1088 2175 2303 c1196 1266 2174 2305 2173 2308 -1 4 -107 '+
                        '117 -235 253 -129 136 -1081 1145 -2117 2242 -1036 1097 -1910 2022 -1942 '+
                        '2055 l-59 60 -2 -1090z"/> '+
                        '</g>'+
                        '<text x="300" y="750" font-family="Verdana" font-size="350px" fill="#ffffff">'+m_reg+'</text>'+
                        '</svg>'+

					'</div>'+
			'</div>'+
         
         // '<div class="contenedor-Aspersor">'+
            '<div class="contenedorTitulo"  style="opacity: '+opacity_no_regar+'; text-align: center; position: absolute; margin-left: -80px; margin-top: 10px">'+
					'<div class="styleZona" style="color:'+color_no_regar+'; font-size: 50px; text-align: center;">'+
                  'NO REGAR'+
					'</div>'+
			   // '</div>'+
         '</div>'+

         '<div class="contenedor-flecha" style="opacity: '+opacity_riego_continuo+'; text-align: center; position: absolute; margin-left: 40px; padding-top: 30px;">'+
					'<div class="img-asp">'+
                        '<svg version="1.0" xmlns="http://www.w3.org/2000/svg" '+
                             'width="400px" height="70px" viewBox="0 0 1280.000000 1280.000000" '+
                             'preserveAspectRatio="xMidYMid meet"> '+
                            '<metadata> '+
                                'Created by potrace 1.15, written by Peter Selinger 2001-2017 '+
                            '</metadata> '+

                            '<g '+
                              'transform="matrix(0.13962095,0,0,-0.1,-397.41065,1301.6949)" '+
                              'id="g4049" '+
                              'style="fill:'+color_gray+';stroke:none"> '+
                              '<path '+
                                 'd="m 11526.048,11968.909 -3.473,-1314.395 -3261.0957,-3.618 -27591.0933,128.394 -44.97,-6004.1984 24373.8096,12.8763 h 3264.569 3264.5694 l 2.315,-1311.984 3.473,-1311.9839 2517.886,2777.1131 c 1384.547,1526.6283 2516.728,2779.5248 2515.57,2783.1424 -1.158,4.8234 -123.868,141.0865 -272.047,305.0845 -149.337,163.998 -1251.419,1380.7184 -2450.743,2703.555 -1199.323,1322.837 -2211.108,2438.264 -2248.153,2478.058 l -68.301,72.352 z"  '+
                                 'id="path4047" '+
                                 'inkscape:connector-curvature="0" '+
                                 'sodipodi:nodetypes="cccccccccccccsccc" '+
                                 'style="stroke-width:1.18151212"/> '+
                            '</g> '+
                            '<text '+
                                 'x="-2100.1356" '+
                                 'y="717.45764" '+
                                 'font-size="600px" '+
                                 'id="text4051" '+
                                 'style="font-size:600px;font-family:Verdana;fill:#ffffff">Continuo '+
                            '</text> '+
                        '</svg> '+

					'</div>'+
			'</div>'+
		
			'</div>'+
      '</div>'+
         '</div>'+
     
        '<div class="contenedor1"> '+
        '<div class="contenedorTitulo"> '+
            '<span class="styleTitulo">VELOCIDAD</span></div> '+

        '<div class="contenedor-Aspersor" id="contenedorVelMax"> '+
            '<div class="colDiv"> '+

                '<div class="contenedorTitulo"> '+
                    '<div class="contenedor-Aspersor2"> '+
                       '<svg width="111px" height="134px" xmlns="http://www.w3.org/2000/svg"  version="1.1" x="0px" y="0px" viewBox="0 0 1000 1000" enable-background="new 0 0 1000 1000" xml:space="preserve"> '+
                        '<metadata> Svg Vector Icons : http://www.onlinewebfonts.com/icon </metadata> '+

                        '<text x="300" y="450" font-family="Verdana" font-size="330" fill='+color_speed+'>'+
                        limite_velocidad+' </text> '+
                        '<text x="226" y="760" font-family="Verdana" font-size="260" fill='+color_speed+'> '+
                        'MAX </text> '+

                        '<g fill='+color_speed+' stroke="none"><g transform="translate(0.000000,511.000000) scale(0.100000,-0.100000)"> '+
                           ' <path d="M3558.8,4556c-757.6-250-1400.4-466.8-1428.4-484.6c-58.7-38.3-1716.7-2313.5-1765.1-2420.7c-43.3-99.5-43.3-2971.6,0-3071.1c17.9-38.3,410.7-591.8,872.4-1229.5c719.3-989.7,857.1-1168.3,943.8-1211.6c56.1-28.1,714.2-247.4,1461.6-489.7L5000-4790l1359.5,438.7c744.8,242.3,1402.9,464.2,1459,489.7c86.7,43.4,224.5,219.4,943.8,1211.6c464.3,637.7,854.5,1191.2,872.4,1229.5c43.4,99.5,43.4,2971.6,0,3071.1c-56.1,127.5-1714.1,2385-1777.9,2425.8c-81.6,48.5-2816,936.1-2874.7,933.6C4956.6,5007.4,4316.4,4803.4,3558.8,4556z M6344.2,4158c862.1-278,1300.9-433.6,1321.3-464.2c17.9-25.5,385.2-528,813.7-1117.2l780.5-1071.3V115.1v-1390.2l-780.5-1071.3c-428.5-589.2-795.8-1091.7-813.7-1117.2c-20.4-30.6-477-191.3-1349.3-474.5L5000-4366.6l-1316.2,428.5c-869.8,283.2-1329,443.8-1349.4,474.5c-20.4,25.5-385.2,528-813.7,1117.2l-778,1071.3V115.1v1390.2l778,1071.3c428.5,589.2,793.3,1091.7,813.7,1117.2c35.7,51,2624.7,913.2,2688.5,895.3C5040.8,4581.5,5637.7,4390.2,6344.2,4158z"/></g></g> '+
                        '</svg> '+

                    '</div> '+
                '</div> '+
            '</div> '+
            '<div class="colDiv"> '+

                '<div class="contenedorTitulo"> '+

                    '<div class="contenedor-Aspersor2"> '+
                        '<svg width="111px" height="134px" xmlns="http://www.w3.org/2000/svg"  version="1.1" x="0px" y="0px" viewBox="0 0 1000 1000" enable-background="new 0 0 1000 1000" xml:space="preserve"> '+
                        '<metadata> Svg Vector Icons : http://www.onlinewebfonts.com/icon </metadata> '+

                        '<text x="300" y="450" font-family="Verdana" font-size="330" fill='+color_speed_min+'> '+
                        +limite_velocidad_min+' </text> '+
                        '<text x="216" y="750" font-family="Verdana" font-size="260" fill='+color_speed_min+'> '+
                        'MIN </text> '+

                        '<g fill='+color_speed_min+' stroke="none"><g transform="translate(0.000000,511.000000) scale(0.100000,-0.100000)"> '+
                            '<path d="M3558.8,4556c-757.6-250-1400.4-466.8-1428.4-484.6c-58.7-38.3-1716.7-2313.5-1765.1-2420.7c-43.3-99.5-43.3-2971.6,0-3071.1c17.9-38.3,410.7-591.8,872.4-1229.5c719.3-989.7,857.1-1168.3,943.8-1211.6c56.1-28.1,714.2-247.4,1461.6-489.7L5000-4790l1359.5,438.7c744.8,242.3,1402.9,464.2,1459,489.7c86.7,43.4,224.5,219.4,943.8,1211.6c464.3,637.7,854.5,1191.2,872.4,1229.5c43.4,99.5,43.4,2971.6,0,3071.1c-56.1,127.5-1714.1,2385-1777.9,2425.8c-81.6,48.5-2816,936.1-2874.7,933.6C4956.6,5007.4,4316.4,4803.4,3558.8,4556z M6344.2,4158c862.1-278,1300.9-433.6,1321.3-464.2c17.9-25.5,385.2-528,813.7-1117.2l780.5-1071.3V115.1v-1390.2l-780.5-1071.3c-428.5-589.2-795.8-1091.7-813.7-1117.2c-20.4-30.6-477-191.3-1349.3-474.5L5000-4366.6l-1316.2,428.5c-869.8,283.2-1329,443.8-1349.4,474.5c-20.4,25.5-385.2,528-813.7,1117.2l-778,1071.3V115.1v1390.2l778,1071.3c428.5,589.2,793.3,1091.7,813.7,1117.2c35.7,51,2624.7,913.2,2688.5,895.3C5040.8,4581.5,5637.7,4390.2,6344.2,4158z"/></g></g> '+
                        '</svg> '+


                    '</div> '+
                '</div> '+
            '</div> '+
        '</div> '+


        '<div class="contenedor1"> '+
            '<div class="contenedor-Aspersor" id="heightZona"> '+
                '<div class="colDiv"> '+

                    '<div class="contenedorTitulo"> '+
                        '<span class="styleTitulo">ZONA</span> '+
                        '<div class="styleFila">'+zona_str+'</div> '+
                        '<div class="contenedor-Aspersor2"> '+

                        '</div> '+
                    '</div> '+
                '</div> '+
                '<div class="colDiv"> '+

                    '<div class="contenedorTitulo"> '+
                        '<span class="styleTitulo">TRATAMIENTO</span> '+
                        '<div class="styleFila"> '+tratamiento+'</div> '+
                        '<div class="contenedor-Aspersor2"> '+

                        '</div> '+
                    '</div> '+
                '</div> '+


            '</div> '+
        '</div> '+

    '</div> '+



			
			'</div>'+
		'</div>'+
 '</div>'
  ].join("\n");  
}

function compassSVG(angle){
	return [
'<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" ',
'	 viewBox="0 0 307.432 307.432" style="enable-background:new 0 0 307.432 307.432;" xml:space="preserve"> ',
'<g>',
'	<g>',
'		<g>',
'			<path style="fill:#010002;" d="M153.708,0C68.951,0,0,68.951,0,153.708c0,84.762,68.951,153.724,153.708,153.724 ',
'				c84.762,0,153.724-68.962,153.724-153.724C307.432,68.951,238.47,0,153.708,0z M153.708,289.244 ',
'				c-74.727,0-135.531-60.798-135.531-135.536c0-74.727,60.803-135.531,135.531-135.531c74.738,0,135.536,60.803,135.536,135.531 ',
'				C289.244,228.446,228.446,289.244,153.708,289.244z"/> ',
'		</g>',
'		<g>',
'			<g>',
'				<g>',
'					<path style="fill:#010002;" d="M151.445,61.276l-43.806,171.967c-0.283,1.12,0.277,2.268,1.343,2.73 ',
'						c1.055,0.457,2.29,0.092,2.921-0.892l42.349-66.019l41.283,66.008c0.441,0.702,1.213,1.099,1.991,1.099 ',
'						c0.305,0,0.609-0.06,0.919-0.179c1.071-0.462,1.637-1.626,1.36-2.747L155.998,61.276 ',
'						C155.465,59.193,151.962,59.193,151.445,61.276z M156.259,163.428c-0.43-0.674-1.169-1.088-1.974-1.088h-0.005 ',
'						c-0.805,0-1.556,0.397-1.985,1.071l-36.512,56.92l37.927-148.949l37.801,148.416L156.259,163.428z"/> ',
'				</g> ',
'			</g> ',
'			<g> ',
'				<g> ',
'					<path style="fill:#010002;" d="M197.52,236.909c-1.055,0-2.072-0.555-2.622-1.441l-40.657-65.024l-41.718,65.035 ',
'						c-0.794,1.246-2.464,1.762-3.829,1.186c-1.403-0.615-2.143-2.132-1.762-3.601l43.801-171.972 ',
'						c0.315-1.256,1.518-2.116,2.986-2.116c1.463,0,2.676,0.848,2.997,2.116l43.79,171.972c0.381,1.479-0.364,3.002-1.773,3.601 ',
'						C198.33,236.828,197.933,236.909,197.52,236.909z M154.246,167.686l0.631,0.995l41.277,66.003 ',
'						c0.397,0.647,1.246,0.925,2.007,0.615c0.718-0.31,1.115-1.104,0.919-1.871L155.28,61.456c-0.19-0.745-0.957-1.012-1.566-1.012 ',
'						c-0.609,0-1.371,0.267-1.561,1.012l-43.795,171.972c-0.207,0.767,0.185,1.561,0.908,1.871c0.696,0.277,1.588,0.033,2.002-0.615 ',
'						L154.246,167.686z M113.943,224.557l39.765-156.172l39.705,155.818l-37.78-60.379c-0.604-0.968-2.138-0.919-2.714-0.016 ',
'						L113.943,224.557z"/>',
'				</g>',
'			</g>',
'		</g>',
'	</g>',
'</g>',
].join("\n");
}

function haulTruckSVG(angle){
return [
'<svg id="haultruck" style="transform-origin:50% 50%; transform:rotate('+angle+'deg)"',
'   xmlns:dc="http://purl.org/dc/elements/1.1/"',
'   xmlns:cc="http://creativecommons.org/ns#"',
'   xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"',
'   xmlns:svg="http://www.w3.org/2000/svg"',
'   xmlns="http://www.w3.org/2000/svg"',
'   xmlns:xlink="http://www.w3.org/1999/xlink"',
'   xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd"',
'   xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape"',
'   version="1.1"',
'   preserveAspectRatio="xMidYMid meet"',
'   viewBox="0 0 41 52"',
'   width="41"',
'   height="52"',
'   inkscape:version="0.91 r13725"',
'   sodipodi:docname="haultruck.svg">',
'  <metadata',
'     id="metadata3371">',
'    <rdf:RDF>',
'      <cc:Work',
'         rdf:about="">',
'        <dc:format>image/svg+xml</dc:format>',
'        <dc:type',
'           rdf:resource="http://purl.org/dc/dcmitype/StillImage" />',
'        <dc:title></dc:title>',
'      </cc:Work>',
'    </rdf:RDF>',
'  </metadata>',
'  <sodipodi:namedview',
'     pagecolor="#ffffff"',
'     bordercolor="#666666"',
'     borderopacity="1"',
'     objecttolerance="10"',
'     gridtolerance="10"',
'     guidetolerance="10"',
'     inkscape:pageopacity="0"',
'     inkscape:pageshadow="2"',
'     inkscape:window-width="1280"',
'     inkscape:window-height="738"',
'     id="namedview3369"',
'     showgrid="false"',
'     inkscape:zoom="11.668525"',
'     inkscape:cx="20.408617"',
'     inkscape:cy="606.4255"',
'     inkscape:window-x="-8"',
'     inkscape:window-y="-8"',
'     inkscape:window-maximized="1"',
'     inkscape:current-layer="g3365" />',
'  <defs',
'     id="defs3342">',
'    <linearGradient',
'       inkscape:collect="always"',
'       id="linearGradient3431">',
'      <stop',
'         style="stop-color:#000000;stop-opacity:1"',
'         offset="0"',
'         id="stop3433" />',
'      <stop',
'         style="stop-color:#ffff00;stop-opacity:1"',
'         offset="1"',
'         id="stop3435" />',
'    </linearGradient>',
'    <path',
'       d="M402 441.42L402 198.42L360 153.42L174 153.42L129 198.42L129 441.42L402 441.42Z"',
'       id="a1bcqcjjf2" />',
'    <path',
'       d="M340 85.42L340 112.42L385 112.42L385 180.42L361 153.42L175 153.42L146 180.42L146 85.42L340 85.42Z"',
'       id="e81QixRZa1" />',
'    <path',
'       d="M151 421.42C155.93 319.78 159.02 256.26 160.25 230.85C160.67 222.21 167.8 215.42 176.45 215.42C214.36 215.42 312.58 215.42 350.48 215.42C359.22 215.42 366.46 222.19 367.05 230.91C368.78 256.31 373.09 319.81 380 421.42C380 312.16 380 243.88 380 216.56C380 208.75 373.67 202.42 365.86 202.42C322.89 202.42 208.11 202.42 165.14 202.42C157.33 202.42 151 208.75 151 216.56C151 243.88 151 312.16 151 421.42Z"',
'       id="c4dszKAwmG" />',
'    <radialGradient',
'       inkscape:collect="always"',
'       xlink:href="#linearGradient3431"',
'       id="radialGradient3437"',
'       cx="272.6958"',
'       cy="189.50267"',
'       fx="272.6958"',
'       fy="189.50267"',
'       r="113.3903"',
'     gradientTransform="matrix(1.6101793,-1.6249662,1.6932181,1.6778554,-618.46881,270.82196)"',
'       gradientUnits="userSpaceOnUse" />',
'  </defs>',
'  <g',
'     id="g3347">',
'    <g',
'       id="g3349">',
'      <g',
'         id="g3363">',
'        <g',
'           id="g3365">',
'          <g',
'             id="g4865"',
'             transform="matrix(0.125,0,0,0.125,2.5479722,3.5662581)">',
'            <g',
'               id="g4847">',
'              <g',
'                 id="g3351"',
'                 transform="translate(-122.47655,-79.249531)">',
'                <g',
'                   id="g3353">',
'                  <use',
'                     xlink:href="#a1bcqcjjf2"',
'                     id="use3355"',
'                     style="opacity:1;fill-opacity:0;stroke:#000000;stroke-width:2;stroke-opacity:1"',
'                     x="0"',
'                     y="0"',
'                     width="100%"',
'                     height="100%" />',
'                </g>',
'              </g>',
'              <g',
'                 id="g3357"',
'                 transform="translate(-122.47655,-79.249531)">',
'                <g',
'                   id="g3359">',
'                  <use',
'                     xlink:href="#e81QixRZa1"',
'                     id="use3361"',
'                     style="opacity:1;fill-opacity:0;stroke:#000000;stroke-width:2;stroke-opacity:1"',
'                     x="0"',
'                     y="0"',
'                     width="100%"',
'                     height="100%" />',
'                </g>',
'              </g>',
'              <use',
'                 xlink:href="#c4dszKAwmG"',
'                 id="use3367"',
'                 transform="translate(-121.13321,-67.831145)"',
'                 style="opacity:1;fill-opacity:0;stroke:#000000;stroke-width:2;stroke-opacity:1"',
'                 x="0"',
'                 y="0"',
'                 width="100%"',
'                 height="100%" />',
'              <path',
'                 style="fill:#ffff00"',
'                 d="m 8.0178221,240.08496 0,-120.466 22.1472099,-21.928001 22.14721,-21.92799 92.540408,0.0262 92.54041,0.0262 12.42589,13.49346 c 6.83424,7.4214 13.22462,14.285821 14.20085,15.254281 0.97623,0.96845 4.52769,4.7194 7.89212,8.33543 l 6.11716,6.57461 0,120.5389 0,120.5389 -135.00563,0 -135.0056279,0 0,-120.466 z m 27.7014799,18.69892 c 2.49088,-52.08299 4.84619,-96.24378 5.23403,-98.1351 0.85915,-4.18975 4.41108,-8.62479 8.3347,-10.40695 2.60315,-1.18239 6.73717,-1.23736 93.063748,-1.23736 85.96196,0 90.46978,0.0593 93.02627,1.22361 3.42023,1.55769 7.42418,5.97965 8.40633,9.28393 0.41859,1.40829 3.68556,45.62727 7.25992,98.26439 5.96358,87.82136 6.59617,95.7226 7.68048,95.9313 1.12427,0.21641 1.17318,-4.88831 1.0075,-105.15638 l -0.17412,-105.38383 -1.85283,-2.79971 c -1.01905,-1.53985 -3.11274,-3.6335 -4.65264,-4.65255 l -2.7998,-1.85283 -105.8861,0 -105.886098,0 -2.79981,1.85283 c -1.53989,1.01905 -3.63358,3.1127 -4.65263,4.65255 l -1.85283,2.79971 -0.17413,105.38383 c -0.16567,100.26807 -0.11676,105.37279 1.00751,105.15637 1.09523,-0.21083 1.51279,-7.15184 5.7105,-94.92381 z"',
'                 id="path3381"',
'                 inkscape:connector-curvature="0" />',
'              <path',
'                 style="fill:#2b0000"',
'                 d="m 24.809572,52.664239 0,-45.411594 95.712938,0 95.71295,0 0,13.769234 0,13.76923 22.50094,0 22.50093,0 0,31.23264 c 0,17.17796 -0.096,31.23265 -0.21337,31.23265 -0.11736,0 -5.02524,-5.44053 -10.9064,-12.09006 l -10.69303,-12.09005 -94.3911,0 -94.391108,0 -6.3676,6.42937 c -3.50217,3.53616 -9.31454,9.16106 -12.91637,12.49978 l -6.54878,6.07039 0,-45.41159 z"',
'                 id="path3383"',
'                 inkscape:connector-curvature="0" />',
'              <path',
'                 style="fill:#ffff00"',
'                 d="m 24.809572,52.323689 0,-45.071044 95.712938,0 95.71295,0 0,13.769234 0,13.76923 22.50094,0 22.50093,0 -0.0838,18.63883 c -0.0461,10.25136 -0.2728,24.0487 -0.50375,30.66074 l -0.41992,12.0219 -10.07505,-11.49286 -10.07504,-11.49286 -95.05178,-0.0253 -95.051778,-0.0253 -8.04953,8.10714 c -4.42725,4.45894 -10.08974,9.93059 -12.58331,12.15924 l -4.53377,4.05207 0,-45.07105 z"',
'                 id="path3385"',
'                 inkscape:connector-curvature="0" />',
'              <path',
'                 style="fill:url(#radialGradient3437);fill-opacity:1"',
'                 d="m 252.62843,241.88274 c -2.7031,-40.20143 -5.19371,-75.47989 -5.53468,-78.39659 -0.71059,-6.07845 -2.60443,-9.91169 -6.47198,-13.09965 -5.26251,-4.33781 0.48279,-4.09821 -98.26999,-4.09821 -98.795708,0 -93.003868,-0.24257 -98.292448,4.11672 -1.37735,1.13533 -3.29634,3.62047 -4.26444,5.52254 -1.98961,3.9091 -1.57284,-2.42362 -6.34988,96.48457 l -2.25458,46.68105 -0.17567,-74.55535 c -0.12262,-52.04182 0.0464,-75.63238 0.55976,-78.12203 0.84252,-4.086 3.75861,-7.8822 7.14013,-9.29509 3.22776,-1.34864 208.076518,-1.34864 211.304278,0 3.38164,1.41294 6.29764,5.20909 7.13998,9.29509 0.51501,2.49818 0.68271,28.28105 0.55977,86.06357 l -0.17553,82.49688 -4.91472,-73.0935 z"',
'                 id="path3389"',
'                 inkscape:connector-curvature="0" />',
'              <g',
'                 id="g4862">',
'                <path',
'                   inkscape:connector-curvature="0"',
'                   id="path4837"',
'                   d="M 7.2045028,360.22514 6.0037523,121.2758 52.833021,73.245779 236.54784,72.045028 l 43.22702,48.030022 0,243.75234 z"',
'                   style="fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:8.10000038;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1" />',
'              </g>',
'              <path',
'                 style="fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:7;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1 "',
'                 d="m 24.015009,98.461538 1.200751,-92.4577857 190.91932,0 -1.20075,27.6172607  45.62852,-1.20075 1.20075,64.840525 0,0 -25.21576,-28.818011 -183.714819,3.602251 z"',
'                 id="path4839"',
'                 inkscape:connector-curvature="0" />',
'            </g>',
'          </g>',
'        </g>',
'      </g>',
'    </g>',
'  </g>',
'</svg>'
].join("\n");
}


function arrowSVG(angle){
return [
'<svg width="20" height="30">',
'    <g transform="translate(10,50)rotate(-90)">',
'        <path d="M10 0 l40 0 l-2 0 l-15 -5 m15 5 l-15 5" />',
'    </g>',
'</svg>'].join("\n");
}

console.log("WENASHORO: svg-generator ok");