function $(selector) {
    return document.querySelector(selector);
}

const app = document.getElementById("app");


function showToast(message, success = true, duration = null) {
    const toast = document.createElement("div");
    toast.textContent = message;

        Object.assign(toast.style, {
        position: "fixed",
        top: "50px",
        right: "50px",
        padding: "10px 20px",
        backgroundColor: success ? "green" : "red",
        color: "white",
        fontWeight: "bold",
        zIndex: 9999,
        borderRadius: "5px",
        opacity: "1",
    });

    document.body.appendChild(toast);
    if (duration != null){
        setTimeout(() => toast.remove(), duration);
    }
}

const h1 = document.createElement("h1");
h1.textContent = "Cargando máquina...";
app.appendChild(h1);

const h2 = document.createElement("h2");
h2.textContent = "";
app.appendChild(h2);

async function get_machine_data() {
    try {
        const response = await fetch("/get_machine_data");
        const json = await response.json();

        let machineName = json.machine_name || "Máquina Desconocida";
        let machineId   = json.machine_id   || "N/A";
        let faena      = json.faena        || "N/A";
        let ubicacion  = json.ubicacion    || "N/A";
        let evos       = json.evos         || [];

        return { machineName, machineId , faena, ubicacion, evos};

    } catch (err) {
        console.error("Error cargando datos de máquina:", err);
        return { machineName: "N/A", machineId: "N/A" };
    }
}

async function cargarTitulo() {
    const data = await get_machine_data();
    h1.textContent = `${data.machineName} / ID ${data.machineId}`;

    const sinAsignacion = (data.faena === "N/A" && data.ubicacion === "N/A");

    if (sinAsignacion) {
        h2.innerHTML = `❌ Equipo sin asignación`;
        h2.classList.remove("asignado");
        h2.classList.add("sin-asignacion");
    } else {
        h2.innerHTML = `✔️ ${data.ubicacion}  ${data.faena}`;
        h2.classList.remove("sin-asignacion");
        h2.classList.add("asignado");
    }
}

cargarTitulo();

// EVOS CERCANOS

const evosBlock = document.createElement("div");
evosBlock.classList.add("evos-block"); 
app.appendChild(evosBlock);

const evos_h2 = document.createElement("h2");
evos_h2.textContent = "EVOS CERCANOS";
evos_h2.classList.add("evos-titulo");
evosBlock.appendChild(evos_h2);

const evosContainer = document.createElement("div");
evosContainer.id = "evos-container";
evosContainer.classList.add("evos-container");
evosBlock.appendChild(evosContainer);

async function get_evos_listened() {
    try {
        const response = await fetch("/get_evos_listened");
        const json = await response.json();
        return json;
    } catch (err) {
        console.error("Error cargando EVOS escuchados:", err);
        return [];
    }
}

const modalConfirm = document.createElement("div");
modalConfirm.id = "modal-confirm";
Object.assign(modalConfirm.style, {
    position: "fixed",
    top: "50%",
    left: "50%",
    transform: "translate(-50%, -50%)",
    background: "white",
    padding: "20px",
    borderRadius: "10px",
    boxShadow: "0 0 15px rgba(0,0,0,0.3)",
    zIndex: "99999",
    display: "none",
    textAlign: "center",
});

modalConfirm.innerHTML = `
    <p style="font-size:18px; margin-bottom:15px;">¿Agregar EVO?</p>
    <button id="btn-modal-si" style="padding:8px 20px; margin-right:10px;">Sí</button>
    <button id="btn-modal-no" style="padding:8px 20px;">No</button>
`;

document.body.appendChild(modalConfirm);

let EVO_SELECTED_FROM_CLICK = null;

document.getElementById("btn-modal-si").onclick = () => {
    if (!EVO_SELECTED_FROM_CLICK) return;

    if (!array_evos.includes("evo-" + EVO_SELECTED_FROM_CLICK) && !array_evos.includes(EVO_SELECTED_FROM_CLICK)) {
        evos.value = "";
        showToast("❌ EVO no disponible", false, 1000);
        modalConfirm.style.display = "none";
        return;
    }

    evos.value = EVO_SELECTED_FROM_CLICK;
    showToast("✅ EVO agregado", true, 1000);
    modalConfirm.style.display = "none";
};

document.getElementById("btn-modal-no").onclick = () => {
    EVO_SELECTED_FROM_CLICK = null;
    modalConfirm.style.display = "none";
};

const evoTimestamps = {};
const EVO_TIMEOUT = 60000; 

function cleanOldEvos() {
    const now = Date.now();
    for (const evo in evoTimestamps) {
        console.log(evo, now - evoTimestamps[evo]);
        if (now - evoTimestamps[evo] > EVO_TIMEOUT) {
            delete evoTimestamps[evo];
        }
    }
}

async function renderEvos() {
    const evos = await get_evos_listened();
    const machineData = await get_machine_data();
    const connectedEvo = machineData.evos[0];
    const now = Date.now();

    const activeEvos = evos.filter(evoData => {
        if (!evoData || evoData.length < 4) return false;

        const [evo, tipo, valor, timestamp] = evoData;

        return (now - timestamp) <= EVO_TIMEOUT;
    });

    evosContainer.innerHTML = "";

    activeEvos.forEach(evoData => {
        const [evo, tipo, valor] = evoData;

        if (tipo !== "pm100") return;

        const evoBox = document.createElement("div");
        evoBox.classList.add("evo-box");

        //console.log("EVO escuchado", evo)
        //console.log("EVO conectado", connectedEvo)
        if (evo === connectedEvo || "evo-" + evo === connectedEvo || evo === connectedEvo + "c" || "evo-" + evo === connectedEvo + "c") {
            evoBox.classList.add("evo-conectado");
            evoBox.innerHTML = `⭐ ${evo} <br> ${tipo}: ${valor*10}`;
        } else {
            evoBox.innerHTML = `${evo} <br> ${tipo}: ${valor*10}`;
        }

        evoBox.addEventListener("click", () => {
            EVO_SELECTED_FROM_CLICK = evo;
            modalConfirm.style.display = "block";
        });

        evosContainer.appendChild(evoBox);
    });
}

// FORMULARIO DE RESPONSABLE

const formResponsable = document.createElement("form");
formResponsable.id = "form-responsable";
formResponsable.classList.add("form-responsable");

const tituloResp = document.createElement("h2");
tituloResp.textContent = "Seleccionar Responsable";
formResponsable.appendChild(tituloResp);

const divResp = document.createElement("div");
const labelResp = document.createElement("label");
labelResp.textContent = "Responsable";
labelResp.htmlFor = "responsable";
divResp.appendChild(labelResp);

const selectResp = document.createElement("select");
selectResp.id = "responsable";
selectResp.name = "responsable";
selectResp.required = true;

selectResp.innerHTML = `<option value="">Seleccionar Responsable</option>`;
divResp.appendChild(selectResp);

formResponsable.appendChild(divResp);

const btnResp = document.createElement("button");
btnResp.type = "submit";
btnResp.textContent = "Continuar";
btnResp.classList.add("btn-submit");
formResponsable.appendChild(btnResp);

app.appendChild(formResponsable);

async function cargarResponsable() {
    try {
        const response = await fetch("/get_users");
        const json = await response.json();

        const usuarios = Object.values(json)
            .filter(u => u.id && u.nombre_completo)
            .sort((a, b) => a.nombre_completo.localeCompare(b.nombre_completo));

        selectResp.innerHTML = `<option value="">Seleccionar Responsable</option>`;

        usuarios.forEach(user => {
            const op = document.createElement("option");
            op.value = user.id;                      
            op.textContent = user.nombre_completo;    
            selectResp.appendChild(op);
        });

    } catch (err) {
        console.error("Error cargando responsables:", err);
    }
}

cargarResponsable();

let RESPONSABLE_FINAL = null;

formResponsable.addEventListener("submit", (e) => {
    e.preventDefault();

    if (!selectResp.value) {
        showToast("Debe seleccionar un responsable", false, 1000);
        return;
    }

    RESPONSABLE_FINAL = selectResp.value; 

    formResponsable.style.display = "none";

    form.style.display = "block";
    evosBlock.style.display = "block"; 

    update_ayudantes(); 
    actualizarDiv.style.display = "block";
});

// FORMULARIO DE ASIGNACIÓN

const form = document.createElement("form");
form.action = "/submit";
form.method = "POST";
app.appendChild(form);

form.style.display = "none"; 
evosBlock.style.display = "block"; 


function crearSelect(id, name, opciones = [], labelText = "", obligatorio = false) {
    const div = document.createElement("div");

    const select = document.createElement("select");
    select.id = id;
    select.name = name;
    if (obligatorio) select.required = true; 

    const label = document.createElement("label");
    label.htmlFor = id;
    label.textContent = labelText;
    div.appendChild(label);

    opciones.forEach(op => {
        const option = document.createElement("option");
        option.value = op.value;
        option.textContent = op.text;
        select.appendChild(option);
    });

    div.appendChild(select);
    return div;
}


const asign = document.createElement("h2");
asign.textContent = "ASIGNACIÓN";
asign.classList.add("asignacion-titulo");
form.appendChild(asign);

form.appendChild(
    crearSelect("ayudante1", "ayudante1", [{value: "", text: "Seleccionar Ayudante 1"}], "AYUDANTE 1")
);

form.appendChild(
    crearSelect("ayudante2", "ayudante2", [{value: "", text: "Seleccionar Ayudante 2"}], "AYUDANTE 2")
);

const ayudante1Select = document.getElementById("ayudante1");
const ayudante2Select = document.getElementById("ayudante2");

async function update_ayudantes() {
    try {
        const response = await fetch("/get_users");
        const json = await response.json();

        if (!json || typeof json !== "object") {
            console.warn("JSON de usuarios inválido:", json);
            return;
        }

        const usuarios = Object.values(json)
            .filter(u => u.nombre_completo && u.id)
            .sort((a, b) => a.nombre_completo.localeCompare(b.nombre_completo));

        const selected1 = ayudante1Select.value;
        const selected2 = ayudante2Select.value; 

        ayudante1Select.innerHTML = `<option value="">Seleccionar Ayudante 1</option>`;
        ayudante2Select.innerHTML = `<option value="">Seleccionar Ayudante 2</option>`;

        usuarios.forEach(user => {

            // Ayudante 1
            if (user.id != selected2 && user.id != RESPONSABLE_FINAL) {
                const option1 = document.createElement("option");
                option1.value = user.id;                       
                option1.textContent = user.nombre_completo;    
                if (user.id == selected1) option1.selected = true;
                ayudante1Select.appendChild(option1);
            }

            // Ayudante 2
            if (user.id != selected1 && user.id != RESPONSABLE_FINAL) {
                const option2 = document.createElement("option");
                option2.value = user.id;
                option2.textContent = user.nombre_completo;
                if (user.id == selected2) option2.selected = true;
                ayudante2Select.appendChild(option2);
            }
        });

    } catch (err) {
        console.error("Error cargando usuarios:", err);
    }
}


update_ayudantes();
ayudante1Select.addEventListener("change", update_ayudantes);
ayudante2Select.addEventListener("change", update_ayudantes);
setInterval(update_ayudantes, 300000);

form.appendChild(
    crearSelect("faena", "faena", [
        { value: "", text: "Seleccionar Faena" },
        { value: "Antucoya", text: "ANTUCOYA" },
        { value: "Candelaria", text: "CANDELARIA" },
        { value: "Centinela", text: "CENTINELA" },
        { value: "Ministro Hales", text: "MINISTRO HALES" },
        { value: "Pelambres", text: "PELAMBRES" },
    ], "FAENA", true )
);

form.appendChild(
    crearSelect("ubicacion", "ubicacion", [
        { value: "", text: "Seleccionar Ubicación" }
    ], "UBICACIÓN", true)
);

form.appendChild(
    crearSelect("evos", "evos", [
        { value: "", text: "Seleccionar EVO" }
    ], "EVO")
);

form.appendChild(
    crearSelect("cabina", "cabina", [
        { value: "", text: "Seleccionar CABINA" }
    ], "CABINA")
);

const notasDiv = document.createElement("div");

const notasLabel = document.createElement("label");
notasLabel.htmlFor = "notas";
notasLabel.textContent = "Notas";
notasDiv.appendChild(notasLabel);

const notasTextArea = document.createElement("textarea");
notasTextArea.id = "notas";
notasTextArea.name = "notas";
notasTextArea.placeholder = "Comentarios adicionales sobre la tarea (máx. 200 caracteres)";
notasTextArea.rows = 4;
notasTextArea.maxLength = 200;
notasDiv.appendChild(notasTextArea);

form.appendChild(notasDiv);

async function compressImage(file, maxSizeKB = 100) {
    return new Promise((resolve, reject) => {
        const img = new Image();
        const reader = new FileReader();

        reader.onload = e => {
            img.src = e.target.result;
        };

        img.onload = () => {
            let canvas = document.createElement("canvas");
            let ctx = canvas.getContext("2d");

            let width = img.width;
            let height = img.height;

            canvas.width = width;
            canvas.height = height;

            ctx.drawImage(img, 0, 0, width, height);

            let quality = 0.9;
            let blob;

            const tryCompress = () => {
                canvas.toBlob(b => {
                    if (!b) return reject();

                    if (b.size / 1024 <= maxSizeKB || quality <= 0.3) {
                        resolve(new File([b], file.name, { type: "image/jpeg" }));
                    } else {
                        quality -= 0.1;
                        width *= 0.9;
                        height *= 0.9;

                        canvas.width = width;
                        canvas.height = height;
                        ctx.drawImage(img, 0, 0, width, height);

                        tryCompress();
                    }
                }, "image/jpeg", quality);
            };

            tryCompress();
        };

        reader.onerror = reject;
        reader.readAsDataURL(file);
    });
}

const imagenesDiv = document.createElement("div");
imagenesDiv.classList.add("imagenes-container");

const imagenesLabel = document.createElement("label");
imagenesLabel.textContent = "Imágenes";
imagenesDiv.appendChild(imagenesLabel);

const dropArea = document.createElement("div");
dropArea.classList.add("drop-area");
dropArea.textContent = "Haz clic o arrastra imágenes aquí";
imagenesDiv.appendChild(dropArea);

const imagenesInput = document.createElement("input");
imagenesInput.type = "file";
imagenesInput.id = "imagenes";
imagenesInput.name = "imagenes";
imagenesInput.accept = ".png, .jpg, .jpeg";
imagenesInput.multiple = true;
imagenesInput.style.display = "none";

imagenesDiv.appendChild(imagenesInput);
form.appendChild(imagenesDiv);

dropArea.addEventListener("click", () => {
    imagenesInput.click();
});

imagenesInput.addEventListener("change", async (e) => {
    const files = Array.from(e.target.files);
    const dt = new DataTransfer();

    dropArea.textContent = "⏳ Procesando imágenes...";

    for (const file of files) {
        if (!file.type.startsWith("image/")) continue;

        const compressed = await compressImage(file, 100);
        dt.items.add(compressed);
    }

    imagenesInput.files = dt.files;

    dropArea.classList.add("has-files");
    dropArea.textContent = `${imagenesInput.files.length} imagen(es) seleccionada(s)`;
});

dropArea.addEventListener("dragover", (e) => {
    e.preventDefault();
    dropArea.classList.add("dragging");
});

dropArea.addEventListener("dragleave", () => {
    dropArea.classList.remove("dragging");
});

dropArea.addEventListener("drop", async (e) => {
    e.preventDefault();
    dropArea.classList.remove("dragging");

    const files = Array.from(e.dataTransfer.files);
    const dt = new DataTransfer();

    dropArea.textContent = "⏳ Procesando imágenes...";

    for (const file of files) {
        if (!file.type.startsWith("image/")) continue;

        const compressed = await compressImage(file, 100);
        dt.items.add(compressed);
    }

    imagenesInput.files = dt.files;

    dropArea.classList.add("has-files");
    dropArea.textContent = `${imagenesInput.files.length} imagen(es) seleccionada(s)`;
});

const divSubmit = document.createElement("div");
const submit = document.createElement("input");
submit.type = "submit";
submit.value = "Aplicar Asignación";
submit.classList.add("btn-submit");
divSubmit.appendChild(submit);
form.appendChild(divSubmit);

form.addEventListener("submit", async (e) => {
    e.preventDefault(); 

    const formData = new FormData(form); 
    formData.append("responsable", RESPONSABLE_FINAL);

    submit.disabled = true;
    submit.value = "⏳ Aplicando...";

    try {
        const response = await fetch(form.action, {
            method: form.method, 
            body: formData
        });

        let result = {};
        try {
            result = await response.json();
        } catch {}

        if (response.status === 503) {
            showToast("📡 Sin conexión. Datos guardados localmente y se enviarán automáticamente.", false, null);
            return;
        }

        if (!response.ok) {
            showToast(result.message || "❌ Error al aplicar asignación", false, 2000);
            return;
        }

        submit.disabled = false;
        submit.value = "Aplicar asignación";

        showToast("✅ Asignación aplicada correctamente", true, 2000);

        console.log("Formulario enviado correctamente:", result);

        form.reset();
        dropArea.textContent = "Haz clic o arrastra imágenes aquí";
        dropArea.classList.remove("has-files");

        const modal = document.createElement("div");
        Object.assign(modal.style, {
            position: "fixed",
            top: "50%",
            left: "50%",
            transform: "translate(-50%, -50%)",
            background: "white",
            padding: "20px",
            borderRadius: "10px",
            boxShadow: "0 0 15px rgba(0,0,0,0.3)",
            zIndex: "100000",
            maxHeight: "80vh",
            overflowY: "auto",
            width: "90%",
            maxWidth: "500px",
            boxSizing: "border-box",
        });

        function formatDate(fechaStr) {
            const d = new Date(fechaStr);
            const dd = String(d.getDate()).padStart(2, "0");
            const mm = String(d.getMonth() + 1).padStart(2, "0");
            const yy = String(d.getFullYear());
            return `${dd}-${mm}-${yy}`;
        }

        modal.innerHTML = `
            <h3>Resumen Asignación</h3>
            <div id="modal-content">
            <p><strong>Faena:</strong> ${result.faena || "-"}</p>
            <p><strong>Fecha:</strong> ${formatDate(result.fecha_inicio)}</p>
            <p><strong>Ubicación:</strong> ${result.ubicacion || "-"}</p>
            ${result.reemplazo_ecom ? (() => {
                if (!result.ecom) {
                    return `<p><strong>ECOM entrante:</strong> ${result.reemplazo_ecom}</p>`;
                }
                if (result.ecom !== result.reemplazo_ecom) {
                    return `
                        <p><strong>ECOM entrante:</strong> ${result.reemplazo_ecom}</p>
                        <p><strong>ECOM saliente:</strong> ${result.ecom}</p>
                    `;
                }
                return "";
            })() : ""}
            ${result.reemplazo_evo ? (() => {
                const evoEntrante = result.reemplazo_evo?.trim();
                const evoSaliente = result.evo?.trim();

                if (!evoSaliente) {
                    return `<p><strong>EVO entrante:</strong> ${evoEntrante}</p>`;
                }

                if (evoEntrante !== evoSaliente) {
                    return `
                        <p><strong>EVO entrante:</strong> ${evoEntrante}</p>
                        <p><strong>EVO saliente:</strong> ${evoSaliente}</p>
                    `;
                }

                return "";
            })() : ""}

            ${result.reemplazo_cab ? (() => {
                const cabEntrante = result.reemplazo_cab?.trim();
                const cabSaliente = result.cab?.trim();

                if (!cabSaliente) {
                    return `<p><strong>Cabina entrante:</strong> ${cabEntrante}</p>`;
                }

                if (cabEntrante !== cabSaliente) {
                    return `
                        <p><strong>Cabina entrante:</strong> ${cabEntrante}</p>
                        <p><strong>Cabina saliente:</strong> ${cabSaliente}</p>
                    `;
                }

                return "";
            })() : ""}
            <p><strong>Encargado:</strong> ${result.responsable || "-"}</p>
            </div>
            <div style="margin-top:10px; display:flex; gap:10px; justify-content:center;">
                <button id="copy-json-modal" style="padding:8px 20px;">Copiar</button>
                <button id="close-json-modal" style="padding:8px 20px;">Cerrar</button>
            </div>
        `;


        document.body.appendChild(modal);

        $("#close-json-modal").onclick = () => {
            modal.remove();
        };
        
        $("#copy-json-modal").onclick = () => {
        const container = document.getElementById("modal-content");

        const text = Array.from(container.querySelectorAll("p"))
            .map(p => p.innerText.trim())
            .filter(Boolean)
            .join("\n");

        if (navigator.clipboard && navigator.clipboard.writeText) {
            navigator.clipboard.writeText(text)
                .then(() => showToast("✅ Datos copiados al portapapeles", true, 1000))
                .catch(() => showToast("❌ Error al copiar", false, 1000));
        } else {
            const textarea = document.createElement("textarea");
            textarea.value = text;
            document.body.appendChild(textarea);
            textarea.select();
            try {
                document.execCommand("copy");
                showToast("✅ Datos copiados al portapapeles", true, 1000);
            } catch {
                showToast("❌ Error al copiar", false, 1000);
            }
            document.body.removeChild(textarea);
        }
    };

    } catch (err) {
        console.error("Error real de red:", err);

        showToast(
            "📡 Sin conexión. Datos guardados localmente y se enviarán automáticamente.",
            false,
            null
        );
    } finally {
        submit.disabled = false;
        submit.value = "Aplicar asignación";
    }
});

const faena = $("#faena");
const ubicacion = $("#ubicacion");
const evos = $("#evos");
const cabina = $("#cabina");

faena.onchange = async (e) => {
    let sval = e.target.value;

    ubicacion.innerHTML = `<option>Cargando...</option>`;

    try {
        const response = await fetch("/get_faenas");
        const json = await response.json();
        console.log("Faenas:", json);

        if (!json || typeof json !== "object") {
            ubicacion.innerHTML = `<option>Error al cargar</option>`;
            console.warn("JSON de faenas inválido:", json);
            return;
        }

        if (!json[sval]) {
            ubicacion.innerHTML = `<option>Sin datos para esta faena</option>`;
            return;
        }

        let lista = json[sval];
        console.log("Ubicaciones:", lista);

        lista.sort((a, b) =>
            a.faenaubicacion.localeCompare(b.faenaubicacion, "es", { sensitivity: "base" })
        );

        let optionsHTML = `<option value="">Seleccionar Ubicación</option>`;
        lista.forEach((u) => {
            optionsHTML += `<option value="${u.faenaubicacion}">${u.faenaubicacion}</option>`;
        });

        ubicacion.innerHTML = optionsHTML;

    } catch (err) {
        console.error("Error cargando ubicaciones:", err);
        ubicacion.innerHTML = `<option>Error al cargar</option>`;
    }
};


let array_evos = [];

async function update_evos() {
    try {
        const response = await fetch("/get_evos");
        const json = await response.json();
        //console.log(json);

        if (!json || typeof json !== "object") {
            console.warn("JSON de EVOS inválido:", json);
            return;
        }

        const selected = evos.value; 
        evos.innerHTML = `<option value="">Seleccionar EVO</option>`;
        array_evos = []; 

        Object.entries(json).forEach(([evoName, evoData]) => {
            if (evoData.state !== "Disponible") return;

            array_evos.push(evoName);

            const option = document.createElement("option");
            option.value = evoName;
            option.textContent = evoName;
            if (evoName === selected) option.selected = true; 
            evos.appendChild(option);
        });

    } catch (err) {
        console.error("Error cargando evos:", err);
    }
}

let array_cabina = [];

async function update_cabinas() {
    try {
        const response = await fetch("/get_cabinas");
        const json = await response.json();
        //console.log(json);

        if (!json || typeof json !== "object") {
            console.warn("JSON de CABINAS inválido:", json);
            return;
        }

        const selected = cabina.value; 
        cabina.innerHTML = `<option value="">Seleccionar CABINA</option>`;
        array_cabina = [];

        Object.entries(json).forEach(([cabinaName, cabinaData]) => {
            if (cabinaData.state !== "Disponible") return;

            array_cabina.push(cabinaName);

            const option = document.createElement("option");
            option.value = cabinaName;
            option.textContent = cabinaName;
            if (cabinaName === selected) option.selected = true; 
            cabina.appendChild(option);
        });

    } catch (err) {
        console.error("Error cargando cabinas:", err);
    }
}

update_evos();
setInterval(update_evos, 300000);

update_cabinas();
setInterval(update_cabinas, 300000);

renderEvos();
setInterval(renderEvos, 5000);

const actualizarDiv = document.createElement("div");
actualizarDiv.style.marginTop = "40px";
actualizarDiv.style.textAlign = "center";
actualizarDiv.style.display = "none"; 

const btnActualizar = document.createElement("button");
btnActualizar.textContent = "🔄 Actualizar";
btnActualizar.type = "button";

Object.assign(btnActualizar.style, {
    backgroundColor: "#007bff",
    color: "white",
    border: "none",
    padding: "12px 30px",
    fontSize: "16px",
    borderRadius: "6px",
    cursor: "pointer"
});

btnActualizar.onclick = async () => {
    try {
        btnActualizar.disabled = true;
        btnActualizar.textContent = "⏳ Actualizando...";

        const response = await fetch("/actualizar", { method: "POST" });

        if (!response.ok) throw new Error();

        const result = await response.json();
        showToast(result.message || "Actualización ejecutada", true, 1000);

    } catch {
        showToast("❌ Error al actualizar", false);
    } finally {
        btnActualizar.disabled = false;
        btnActualizar.textContent = "🔄 Actualizar";
    }
};

actualizarDiv.appendChild(btnActualizar);
app.appendChild(actualizarDiv);