import requests
import json
import time
from keys import API_TOKEN # Recordar añadir keys.py en la actualización ecom

token = API_TOKEN

# =========== FAENAS ============ #
def get_faenas_data(token):
    base_url = 'http://core.mine-360.com:1337/api/faena-ubicacions?fields=FaenaUbicacion&populate[faena][fields][1]=Faena&pagination[limit]=1000&'

    headers = {
        'accept': 'application/json',
        'Authorization': f'Bearer {token}',
        'Content-Type': 'application/json'
    }

    source_config = "/srv/datalogger_mmr/web-server/FAENAS_DATA.json"
    #source_config = "web-server/FAENAS_DATA.json"
    FAENAS_DATA = {}

    response = requests.get(base_url, headers=headers)

    if response.status_code == 200:
        data = response.json()
        
        for x in data["data"]:
            faena = x["attributes"]["faena"]["data"]["attributes"]["Faena"]
            faena_ubicacion = x["attributes"]["FaenaUbicacion"]
            faena_ubicacion_id = x["id"]  
            
            if faena_ubicacion.startswith(("REG")):
                if faena not in FAENAS_DATA:
                    FAENAS_DATA[faena] = []
                FAENAS_DATA[faena].append({
                    "id": faena_ubicacion_id,
                    "faenaubicacion": faena_ubicacion
                })

    with open(source_config, "w") as f:
        json.dump(FAENAS_DATA, f, indent=4)

    return FAENAS_DATA

# =========== USERS ============ #
def get_users_data(token):
    base_url = 'http://core.mine-360.com:1337/api/users?&pagination[limit]=1000'

    headers = {
                'accept': 'application/json',
                'Authorization': f'Bearer {token}',
                'Content-Type': 'application/json'
            }

    source_config = "/srv/datalogger_mmr/web-server/USERS_DATA.json"
    #source_config = "web-server/USERS_DATA.json"
    USERS_DATA = {}

    response = requests.get(base_url, headers=headers)

    if response.status_code == 200:
        data = response.json()  
        for x in data:  
            username = x.get("username", "unknown")
            #print(username)
            nombre_completo = x.get("NombreCompleto", "unknown")
            #print(nombre_completo)
            USERS_DATA[username] = {"id": x.get("id"),"nombre_completo": nombre_completo}
            
    with open(source_config, "w") as f:
        json.dump(USERS_DATA, f, indent=1)
        
# =========== DATALOGGERS ============ #
def get_datalogger_data(token):
    base_url = "http://core.mine-360.com:1337/api/dataloggers?fields[0]=MachineName&populate[datalogger_estado]=DataloggerEstado&populate[faena_ubicacion][fields][0]=FaenaUbicacion&pagination[limit]=1000"

    headers = {
        'accept': 'application/json',
        'Authorization': f'Bearer {token}',
        'Content-Type': 'application/json'
    }

    source_config = "/srv/datalogger_mmr/web-server/DATALOGGER_DATA.json"
    #source_config = "web-server/DATALOGGER_DATA.json"
    DATALOGGER_DATA = {}

    response = requests.get(base_url, headers=headers)

    if response.status_code == 200:
        data = response.json()

        for x in data.get("data", []):
            machine_name = x["attributes"].get("MachineName", "").lower()

            if machine_name.startswith(("mmr", "tablet")):

                state_data = x["attributes"].get("datalogger_estado", {}).get("data")
                if state_data is None:
                    estado = "unknown"
                else:
                    estado = state_data["attributes"].get("DataloggerEstado", "unknown")

                faena_data = x["attributes"].get("faena_ubicacion", {}).get("data")
                if faena_data is None:
                    faena = "unknown"
                else:
                    faena = faena_data["attributes"].get("FaenaUbicacion", "unknown")

                DATALOGGER_DATA[x["attributes"]["MachineName"]] = {
                    "id": x["id"],
                    "faena": faena,
                    "state": estado
                }

    with open(source_config, "w", encoding="utf-8") as f:
        json.dump(DATALOGGER_DATA, f, indent=4, ensure_ascii=False)
        
# =========== FAENA UBICACION DATA ============ #

def get_loc_data(token):
    base_url = 'http://core.mine-360.com:1337/api/faena-ubicacions?fields[0]=FaenaUbicacion&populate[dataloggers][fields][0]=MachineName&pagination[limit]=1000'
    
    headers = {
                'accept': 'application/json',
                'Authorization': f'Bearer {token}',
                'Content-Type': 'application/json'
            }
    source_config = "/srv/datalogger_mmr/web-server/LOC_DATA.json"
    #source_config = "web-server/LOC_DATA.json"
    LOC_DATA = {}
    
    response = requests.get(base_url, headers=headers)
    
    if response.status_code == 200:
        data = response.json()
        for item in data.get("data", []):
            attrs = item.get("attributes", {})

            filtered_dataloggers = [
                x["attributes"]["MachineName"]
                for x in attrs.get("dataloggers", {}).get("data", [])
                if x.get("attributes", {})
                .get("MachineName", "")
                .lower()
                .startswith(("mmr", "tablet"))
            ]

            if filtered_dataloggers:
                LOC_DATA[item["id"]] = {
                    "id": item["id"],
                    "FaenaUbicacion": attrs.get("FaenaUbicacion", "unknown"),
                    "dataloggers": filtered_dataloggers
                }

    with open(source_config, "w") as f:
        json.dump(LOC_DATA, f, indent=1)

while True:
    print("Updating data...")
    get_faenas_data(token)
    get_users_data(token)
    get_datalogger_data(token)
    get_loc_data(token)
    print("Data updated. Waiting 10 minutes for next update...")
    time.sleep(600)