import requests
import os
import subprocess
from datetime import datetime
from PIL import Image
import time
import json

def get_faena_assigned():
    FAENA = "TALLER" # Default
    map_faenas = {
        "Minisstro Hales": "DMH",
        "Antucoya": "ANTUCOYA",
        "Centinela": "CENTINELA",
        "Candelaria": "CANDELARIA",
    }
    try:
        f = open('/topic.json')
        config:dict = json.load(f)
        topic_faena= config["topic"].split("/")[0]
        FAENA = map_faenas[topic_faena]
    except:
        print("Error al decodificar la faena")

    return FAENA


# Obtener nombre de la máquina y el ID de la máquina
try:
    name = subprocess.check_output(['machinename'], text=True).strip()
    idMachine = subprocess.check_output(['machineid'], text=True).strip()
except subprocess.CalledProcessError as e:
    print(f'Error al obtener el nombre de la máquina o el ID: {e}')
    exit(1)

while True:
        # Get Faena
        faena = get_faena_assigned()

        # Obtener fecha y hora actual
        fecha_actual = datetime.now().strftime('%Y/%m/%d %H:%M:%S')
        timestamp_actual = int(datetime.now().timestamp())

        # URL a la que se enviará la solicitud POST
        url = 'http://www.mine-360.com:8080/api/archivos/upload'

        # Ruta del archivo de captura de pantalla (PNG)
        png_file_path = f'/home/pi/pantalla/screen-{idMachine}.png'
        # Ruta del archivo de captura de pantalla (JPG)
        jpg_file_path = f'/home/pi/pantalla/screen-{idMachine}.jpg'

        # Eliminar la imagen existente si existe
        if os.path.exists(png_file_path):
            os.remove(png_file_path)
        if os.path.exists(jpg_file_path):
            os.remove(jpg_file_path)

        # Capturar la pantalla y guardar la imagen como PNG
        captura_cmd = f'export DISPLAY=:0 && export XAUTHORITY=/home/pi/.Xauthority && scrot -bu {png_file_path}'
        os.system(captura_cmd)

        # Verificar si el archivo de captura de pantalla fue creado
        if not os.path.exists(png_file_path):
            print('Error: No se pudo crear la captura de pantalla.')
            exit(1)

        # Convertir la imagen PNG a JPG y redimensionarla para reducir el tamaño
        with Image.open(png_file_path) as img:
            img = img.convert('RGB')  # Convertir a RGB (JPG no soporta transparencia)
            img = img.resize((1024, 600), Image.ANTIALIAS)  # Redimensionar a 800x600 píxeles
            img.save(jpg_file_path, 'JPEG', quality=85)  # Guardar como JPG con calidad 85

        # Verificar si el archivo de captura de pantalla JPG fue creado
        if not os.path.exists(jpg_file_path):
            print('Error: No se pudo crear la imagen JPG.')
            exit(1)

        # Datos que se enviarán en el cuerpo de la solicitud POST
        data = {
            'nombre_tablet': name,  # Nombre de la tablet
            'id_maquina': idMachine,  # ID de la máquina
            'faena': faena,  # Nombre de la faena
            'ult_recepc_foto': fecha_actual,  # Fecha y hora de la última recepción de la foto
            'timestamp': timestamp_actual,  # Timestamp
            'lat': '73.1',  # Latitud
            'long': '88.1'  # Longitud
        }

        # Archivo que se adjuntará a la solicitud POST
        files = {'file': open(jpg_file_path, 'rb')}  # Ruta al archivo de imagen


        if os.path.exists(png_file_path):
            os.remove(png_file_path)
            
        # Envío de la solicitud POST
        try:
            print(data)
            
            response = requests.post(url, data=data, files=files)
            # Comprobación del resultado de la solicitud
            if response.status_code == 200:
                print('Solicitud exitosa')
                try:
                    response_json = response.json()
                    if isinstance(response_json, list) and len(response_json) > 0:
                        respuesta_servidor = response_json[0]
                        print('Respuesta del servidor:')
                        print('Nombre de la tablet:', respuesta_servidor['nombre_tablet'])
                        print('Fecha de recepción de la foto:', respuesta_servidor['ult_recepc_foto'])
                        print('ID de la máquina:', respuesta_servidor['id_maquina'])
                        print('Faena:', respuesta_servidor['faena'])
                        print('Latitud:', respuesta_servidor['lat'])
                        print('Longitud:', respuesta_servidor['long'])
                        print('URL de la foto:', respuesta_servidor['url_foto'])
                    else:
                        print('La respuesta del servidor no tiene el formato esperado.')
                        print('Contenido de la respuesta:', response.text)
                except ValueError:
                    print('La respuesta del servidor no es un JSON válido.')
                    print('Contenido de la respuesta:', response.text)
            else:
                print('Error en la solicitud:', response.status_code)
                print('Detalle del error:', response.text)
        except requests.exceptions.RequestException as e:
            print(f'Error durante la solicitud POST: {e}')
        finally:
            files['file'].close()
        
        time.sleep(120)
